/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.chunking;

import java.util.ArrayList;
import java.util.List;
import org.languagetool.AnalyzedToken;
import org.languagetool.chunking.ChunkTag;
import org.languagetool.chunking.ChunkTaggedToken;

class EnglishChunkFilter {
    private static final ChunkTag BEGIN_NOUN_PHRASE_TAG = new ChunkTag("B-NP");
    private static final ChunkTag IN_NOUN_PHRASE_TAG = new ChunkTag("I-NP");

    EnglishChunkFilter() {
    }

    List<ChunkTaggedToken> filter(List<ChunkTaggedToken> tokens) {
        ArrayList<ChunkTaggedToken> result = new ArrayList<ChunkTaggedToken>();
        String newChunkTag = null;
        int i = 0;
        for (ChunkTaggedToken taggedToken : tokens) {
            ArrayList<ChunkTag> chunkTags = new ArrayList<ChunkTag>();
            if (this.isBeginningOfNounPhrase(taggedToken)) {
                ChunkType chunkType = this.getChunkType(tokens, i);
                if (chunkType == ChunkType.SINGULAR) {
                    chunkTags.add(new ChunkTag("B-NP-singular"));
                    newChunkTag = "NP-singular";
                } else if (chunkType == ChunkType.PLURAL) {
                    chunkTags.add(new ChunkTag("B-NP-plural"));
                    newChunkTag = "NP-plural";
                } else {
                    throw new IllegalStateException("Unknown chunk type: " + (Object)((Object)chunkType));
                }
            }
            if (newChunkTag != null && this.isEndOfNounPhrase(tokens, i)) {
                chunkTags.add(new ChunkTag("E-" + newChunkTag));
                newChunkTag = null;
            }
            if (newChunkTag != null && this.isContinuationOfNounPhrase(taggedToken)) {
                chunkTags.add(new ChunkTag("I-" + newChunkTag));
            }
            if (chunkTags.size() > 0) {
                result.add(new ChunkTaggedToken(taggedToken.getToken(), chunkTags, taggedToken.getReadings()));
            } else {
                result.add(taggedToken);
            }
            ++i;
        }
        return result;
    }

    private boolean isBeginningOfNounPhrase(ChunkTaggedToken taggedToken) {
        return taggedToken.getChunkTags().contains(BEGIN_NOUN_PHRASE_TAG);
    }

    private boolean isEndOfNounPhrase(List<ChunkTaggedToken> tokens, int i) {
        if (i > tokens.size() - 2) {
            return true;
        }
        return !this.isContinuationOfNounPhrase(tokens.get(i + 1));
    }

    private boolean isContinuationOfNounPhrase(ChunkTaggedToken taggedToken) {
        return taggedToken.getChunkTags().contains(IN_NOUN_PHRASE_TAG);
    }

    private ChunkType getChunkType(List<ChunkTaggedToken> tokens, int chunkStartPos) {
        boolean isPlural = false;
        for (int i = chunkStartPos; i < tokens.size(); ++i) {
            ChunkTaggedToken token = tokens.get(i);
            if (this.hasNounWithPluralReading(token)) {
                isPlural = true;
            }
            if (!this.isBeginningOfNounPhrase(token) && !this.isContinuationOfNounPhrase(token)) break;
        }
        return isPlural ? ChunkType.PLURAL : ChunkType.SINGULAR;
    }

    private boolean hasNounWithPluralReading(ChunkTaggedToken token) {
        if (token.getReadings() != null) {
            for (AnalyzedToken analyzedToken : token.getReadings().getReadings()) {
                if (!"NNS".equals(analyzedToken.getPOSTag())) continue;
                return true;
            }
        }
        return false;
    }

    static enum ChunkType {
        SINGULAR,
        PLURAL;

    }
}

