/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.Category;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.en.EnglishRule;
import org.languagetool.tools.StringTools;

public class AvsAnRule
extends EnglishRule {
    private static final String FILENAME_A = "/en/det_a.txt";
    private static final String FILENAME_AN = "/en/det_an.txt";
    private final Set<String> requiresA;
    private final Set<String> requiresAn;

    public AvsAnRule(ResourceBundle messages) throws IOException {
        if (messages != null) {
            super.setCategory(new Category(messages.getString("category_misc")));
        }
        this.requiresA = this.loadWords(JLanguageTool.getDataBroker().getFromRulesDirAsStream(FILENAME_A));
        this.requiresAn = this.loadWords(JLanguageTool.getDataBroker().getFromRulesDirAsStream(FILENAME_AN));
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.addExamplePair(Example.wrong((String)"The train arrived <marker>a hour</marker> ago."), Example.fixed((String)"The train arrived <marker>an hour</marker> ago."));
    }

    public String getId() {
        return "EN_A_VS_AN";
    }

    public String getDescription() {
        return "Use of 'a' vs. 'an'";
    }

    public RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        String prevToken = "";
        int prevPos = 0;
        for (int i = 1; i < tokens.length; ++i) {
            String replacement;
            String token = tokens[i].getToken();
            boolean doesRequireA = false;
            boolean doesRequireAn = false;
            boolean isException = false;
            String[] parts = token.split("[-']");
            if (parts.length >= 1 && !parts[0].equalsIgnoreCase("a")) {
                token = parts[0];
            }
            if ((tokens[i].isWhitespaceBefore() || !"-".equals(token)) && StringTools.isEmpty((String)(token = token.replaceAll("[^\u03b1a-zA-Z0-9\\.;,:']", "")))) continue;
            char tokenFirstChar = token.charAt(0);
            if (this.requiresA.contains(token.toLowerCase()) || this.requiresA.contains(token)) {
                isException = true;
                doesRequireA = true;
            }
            if (this.requiresAn.contains(token.toLowerCase()) || this.requiresAn.contains(token)) {
                if (isException) {
                    isException = true;
                    doesRequireA = false;
                    doesRequireAn = false;
                } else {
                    isException = true;
                    doesRequireAn = true;
                }
            }
            if (!isException) {
                if (StringTools.isAllUppercase((String)token) || StringTools.isMixedCase((String)token)) {
                    doesRequireAn = false;
                    doesRequireA = false;
                } else if (AvsAnRule.isVowel(tokenFirstChar)) {
                    doesRequireAn = true;
                } else {
                    doesRequireA = true;
                }
            }
            String msg = null;
            if (prevToken.equalsIgnoreCase("a") && doesRequireAn) {
                replacement = "an";
                if (prevToken.equals("A")) {
                    replacement = "An";
                }
                msg = "Use <suggestion>" + replacement + "</suggestion> instead of '" + prevToken + "' if the following " + "word starts with a vowel sound, e.g. 'an article', 'an hour'";
            } else if (prevToken.equalsIgnoreCase("an") && doesRequireA) {
                replacement = "a";
                if (prevToken.equals("An")) {
                    replacement = "A";
                }
                msg = "Use <suggestion>" + replacement + "</suggestion> instead of '" + prevToken + "' if the following " + "word doesn't start with a vowel sound, e.g. 'a sentence', 'a university'";
            }
            if (msg != null) {
                RuleMatch ruleMatch = new RuleMatch((Rule)this, prevPos, prevPos + prevToken.length(), msg, "Wrong article");
                ruleMatches.add(ruleMatch);
            }
            if (tokens[i].hasPosTag("DT")) {
                prevToken = token;
                prevPos = tokens[i].getStartPos();
                continue;
            }
            prevToken = "";
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    public final String suggestAorAn(String noun) {
        String word = noun;
        boolean doesRequireA = false;
        boolean doesRequireAn = false;
        boolean isException = false;
        String[] parts = word.split("[-']");
        if (parts.length >= 1 && !parts[0].equalsIgnoreCase("a")) {
            word = parts[0];
        }
        if (StringTools.isEmpty((String)word)) {
            return word;
        }
        char tokenFirstChar = word.charAt(0);
        if (this.requiresA.contains(word.toLowerCase()) || this.requiresA.contains(word)) {
            isException = true;
            doesRequireA = true;
        }
        if (this.requiresAn.contains(word.toLowerCase()) || this.requiresAn.contains(word)) {
            if (isException) {
                throw new IllegalStateException(word + " is listed in both det_a.txt and det_an.txt");
            }
            isException = true;
            doesRequireAn = true;
        }
        if (!isException) {
            if (StringTools.isAllUppercase((String)word) || StringTools.isMixedCase((String)word)) {
                doesRequireAn = false;
                doesRequireA = false;
            } else if (AvsAnRule.isVowel(tokenFirstChar)) {
                doesRequireAn = true;
            } else {
                doesRequireA = true;
            }
        }
        if (doesRequireA) {
            return "a " + noun;
        }
        if (doesRequireAn) {
            return "an " + noun;
        }
        return noun;
    }

    private static boolean isVowel(char c) {
        return (c = Character.toLowerCase(c)) == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u';
    }

    private Set<String> loadWords(InputStream file) throws IOException {
        TreeSet<String> set = new TreeSet<String>();
        try (Scanner scanner = new Scanner(file, "utf-8");){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().trim();
                if (line.length() < 1 || line.charAt(0) == '#') continue;
                if (line.charAt(0) == '*') {
                    set.add(line.substring(1));
                    continue;
                }
                set.add(line.toLowerCase());
            }
        }
        return set;
    }

    public void reset() {
    }
}

