/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.ip2region;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.lionsoul.ip2region.DataBlock;
import org.lionsoul.ip2region.DbConfig;
import org.lionsoul.ip2region.IndexBlock;
import org.lionsoul.ip2region.Util;

public class DbSearcher {
    public static final int BTREE_ALGORITHM = 1;
    public static final int BINARY_ALGORITHM = 2;
    public static final int MEMORY_ALGORITYM = 3;
    private DbConfig dbConfig = null;
    private RandomAccessFile raf = null;
    private long[] HeaderSip = null;
    private int[] HeaderPtr = null;
    private int headerLength;
    private long firstIndexPtr = 0L;
    private long lastIndexPtr = 0L;
    private int totalIndexBlocks = 0;
    private byte[] dbBinStr = null;

    public DbSearcher(DbConfig dbConfig, String dbFile) throws FileNotFoundException {
        this.dbConfig = dbConfig;
        this.raf = new RandomAccessFile(dbFile, "r");
    }

    public DataBlock memorySearch(long ip) throws IOException {
        int blen = IndexBlock.getIndexBlockLength();
        if (this.dbBinStr == null) {
            this.dbBinStr = new byte[(int)this.raf.length()];
            this.raf.seek(0L);
            this.raf.readFully(this.dbBinStr, 0, this.dbBinStr.length);
            this.firstIndexPtr = Util.getIntLong(this.dbBinStr, 0);
            this.lastIndexPtr = Util.getIntLong(this.dbBinStr, 4);
            this.totalIndexBlocks = (int)((this.lastIndexPtr - this.firstIndexPtr) / (long)blen) + 1;
        }
        int l = 0;
        int h = this.totalIndexBlocks;
        long dataptr = 0L;
        while (l <= h) {
            int m = l + h >> 1;
            int p = (int)(this.firstIndexPtr + (long)(m * blen));
            long sip = Util.getIntLong(this.dbBinStr, p);
            if (ip < sip) {
                h = m - 1;
                continue;
            }
            long eip = Util.getIntLong(this.dbBinStr, p + 4);
            if (ip > eip) {
                l = m + 1;
                continue;
            }
            dataptr = Util.getIntLong(this.dbBinStr, p + 8);
            break;
        }
        if (dataptr == 0L) {
            return null;
        }
        int dataLen = (int)(dataptr >> 24 & 0xFFL);
        int dataPtr = (int)(dataptr & 0xFFFFFFL);
        int city_id = (int)Util.getIntLong(this.dbBinStr, dataPtr);
        String region = new String(this.dbBinStr, dataPtr + 4, dataLen - 4, "UTF-8");
        return new DataBlock(city_id, region, dataPtr);
    }

    public DataBlock memorySearch(String ip) throws IOException {
        return this.memorySearch(Util.ip2long(ip));
    }

    public DataBlock getByIndexPtr(long ptr) throws IOException {
        this.raf.seek(ptr);
        byte[] buffer = new byte[12];
        this.raf.readFully(buffer, 0, buffer.length);
        long extra = Util.getIntLong(buffer, 8);
        int dataLen = (int)(extra >> 24 & 0xFFL);
        int dataPtr = (int)(extra & 0xFFFFFFL);
        this.raf.seek(dataPtr);
        byte[] data = new byte[dataLen];
        this.raf.readFully(data, 0, data.length);
        int city_id = (int)Util.getIntLong(data, 0);
        String region = new String(data, 4, data.length - 4, "UTF-8");
        return new DataBlock(city_id, region, dataPtr);
    }

    public DataBlock btreeSearch(long ip) throws IOException {
        if (this.HeaderSip == null) {
            this.raf.seek(8L);
            byte[] b = new byte[4096];
            this.raf.readFully(b, 0, b.length);
            int len = b.length >> 3;
            int idx = 0;
            this.HeaderSip = new long[len];
            this.HeaderPtr = new int[len];
            for (int i = 0; i < b.length; i += 8) {
                long startIp = Util.getIntLong(b, i);
                long dataPtr = Util.getIntLong(b, i + 4);
                if (dataPtr == 0L) break;
                this.HeaderSip[idx] = startIp;
                this.HeaderPtr[idx] = (int)dataPtr;
                ++idx;
            }
            this.headerLength = idx;
        }
        if (ip == this.HeaderSip[0]) {
            return this.getByIndexPtr(this.HeaderPtr[0]);
        }
        if (ip == this.HeaderSip[this.headerLength - 1]) {
            return this.getByIndexPtr(this.HeaderPtr[this.headerLength - 1]);
        }
        int l = 0;
        int h = this.headerLength;
        int sptr = 0;
        int eptr = 0;
        while (l <= h) {
            int m = l + h >> 1;
            if (ip == this.HeaderSip[m]) {
                if (m > 0) {
                    sptr = this.HeaderPtr[m - 1];
                    eptr = this.HeaderPtr[m];
                    break;
                }
                sptr = this.HeaderPtr[m];
                eptr = this.HeaderPtr[m + 1];
                break;
            }
            if (ip < this.HeaderSip[m]) {
                if (m == 0) {
                    sptr = this.HeaderPtr[m];
                    eptr = this.HeaderPtr[m + 1];
                    break;
                }
                if (ip > this.HeaderSip[m - 1]) {
                    sptr = this.HeaderPtr[m - 1];
                    eptr = this.HeaderPtr[m];
                    break;
                }
                h = m - 1;
                continue;
            }
            if (m == this.headerLength - 1) {
                sptr = this.HeaderPtr[m - 1];
                eptr = this.HeaderPtr[m];
                break;
            }
            if (ip <= this.HeaderSip[m + 1]) {
                sptr = this.HeaderPtr[m];
                eptr = this.HeaderPtr[m + 1];
                break;
            }
            l = m + 1;
        }
        if (sptr == 0) {
            return null;
        }
        int blockLen = eptr - sptr;
        int blen = IndexBlock.getIndexBlockLength();
        byte[] iBuffer = new byte[blockLen + blen];
        this.raf.seek(sptr);
        this.raf.readFully(iBuffer, 0, iBuffer.length);
        l = 0;
        h = blockLen / blen;
        long dataptr = 0L;
        while (l <= h) {
            int m = l + h >> 1;
            int p = m * blen;
            long sip = Util.getIntLong(iBuffer, p);
            if (ip < sip) {
                h = m - 1;
                continue;
            }
            long eip = Util.getIntLong(iBuffer, p + 4);
            if (ip > eip) {
                l = m + 1;
                continue;
            }
            dataptr = Util.getIntLong(iBuffer, p + 8);
            break;
        }
        if (dataptr == 0L) {
            return null;
        }
        int dataLen = (int)(dataptr >> 24 & 0xFFL);
        int dataPtr = (int)(dataptr & 0xFFFFFFL);
        this.raf.seek(dataPtr);
        byte[] data = new byte[dataLen];
        this.raf.readFully(data, 0, data.length);
        int city_id = (int)Util.getIntLong(data, 0);
        String region = new String(data, 4, data.length - 4, "UTF-8");
        return new DataBlock(city_id, region, dataPtr);
    }

    public DataBlock btreeSearch(String ip) throws IOException {
        return this.btreeSearch(Util.ip2long(ip));
    }

    public DataBlock binarySearch(long ip) throws IOException {
        int blen = IndexBlock.getIndexBlockLength();
        if (this.totalIndexBlocks == 0) {
            this.raf.seek(0L);
            byte[] superBytes = new byte[8];
            this.raf.readFully(superBytes, 0, superBytes.length);
            this.firstIndexPtr = Util.getIntLong(superBytes, 0);
            this.lastIndexPtr = Util.getIntLong(superBytes, 4);
            this.totalIndexBlocks = (int)((this.lastIndexPtr - this.firstIndexPtr) / (long)blen) + 1;
        }
        int l = 0;
        int h = this.totalIndexBlocks;
        byte[] buffer = new byte[blen];
        long dataptr = 0L;
        while (l <= h) {
            int m = l + h >> 1;
            this.raf.seek(this.firstIndexPtr + (long)(m * blen));
            this.raf.readFully(buffer, 0, buffer.length);
            long sip = Util.getIntLong(buffer, 0);
            if (ip < sip) {
                h = m - 1;
                continue;
            }
            long eip = Util.getIntLong(buffer, 4);
            if (ip > eip) {
                l = m + 1;
                continue;
            }
            dataptr = Util.getIntLong(buffer, 8);
            break;
        }
        if (dataptr == 0L) {
            return null;
        }
        int dataLen = (int)(dataptr >> 24 & 0xFFL);
        int dataPtr = (int)(dataptr & 0xFFFFFFL);
        this.raf.seek(dataPtr);
        byte[] data = new byte[dataLen];
        this.raf.readFully(data, 0, data.length);
        int city_id = (int)Util.getIntLong(data, 0);
        String region = new String(data, 4, data.length - 4, "UTF-8");
        return new DataBlock(city_id, region, dataPtr);
    }

    public DataBlock binarySearch(String ip) throws IOException {
        return this.binarySearch(Util.ip2long(ip));
    }

    public DbConfig getDbConfig() {
        return this.dbConfig;
    }

    public void close() throws IOException {
        this.HeaderSip = null;
        this.HeaderPtr = null;
        this.dbBinStr = null;
        this.raf.close();
    }
}

