/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.UnexpectedAlertBehaviour;

public class ChromeOptions
extends MutableCapabilities {
    public static final String CAPABILITY = "goog:chromeOptions";
    private String binary;
    private List<String> args = Lists.newArrayList();
    private List<File> extensionFiles = Lists.newArrayList();
    private List<String> extensions = Lists.newArrayList();
    private Map<String, Object> experimentalOptions = Maps.newHashMap();

    public ChromeOptions() {
        this.setCapability("browserName", "chrome");
    }

    public ChromeOptions merge(Capabilities extraCapabilities) {
        super.merge(extraCapabilities);
        return this;
    }

    public ChromeOptions setBinary(File path) {
        this.binary = ((File)Preconditions.checkNotNull((Object)path)).getPath();
        return this;
    }

    public ChromeOptions setBinary(String path) {
        this.binary = (String)Preconditions.checkNotNull((Object)path);
        return this;
    }

    public ChromeOptions addArguments(String ... arguments) {
        this.addArguments((List<String>)ImmutableList.copyOf((Object[])arguments));
        return this;
    }

    public ChromeOptions addArguments(List<String> arguments) {
        this.args.addAll(arguments);
        return this;
    }

    public ChromeOptions addExtensions(File ... paths) {
        this.addExtensions((List<File>)ImmutableList.copyOf((Object[])paths));
        return this;
    }

    public ChromeOptions addExtensions(List<File> paths) {
        for (File path : paths) {
            Preconditions.checkNotNull((Object)path);
            Preconditions.checkArgument((boolean)path.exists(), (String)"%s does not exist", (Object)path.getAbsolutePath());
            Preconditions.checkArgument((!path.isDirectory() ? 1 : 0) != 0, (String)"%s is a directory", (Object)path.getAbsolutePath());
        }
        this.extensionFiles.addAll(paths);
        return this;
    }

    public ChromeOptions addEncodedExtensions(String ... encoded) {
        this.addEncodedExtensions((List<String>)ImmutableList.copyOf((Object[])encoded));
        return this;
    }

    public ChromeOptions addEncodedExtensions(List<String> encoded) {
        for (String extension : encoded) {
            Preconditions.checkNotNull((Object)extension);
        }
        this.extensions.addAll(encoded);
        return this;
    }

    public ChromeOptions setExperimentalOption(String name, Object value) {
        this.experimentalOptions.put((String)Preconditions.checkNotNull((Object)name), value);
        return this;
    }

    @Deprecated
    public Object getExperimentalOption(String name) {
        return this.experimentalOptions.get(Preconditions.checkNotNull((Object)name));
    }

    public ChromeOptions setPageLoadStrategy(PageLoadStrategy strategy) {
        this.setCapability("pageLoadStrategy", strategy);
        return this;
    }

    public ChromeOptions setUnhandledPromptBehaviour(UnexpectedAlertBehaviour behaviour) {
        this.setCapability("unhandledPromptBehavior", behaviour);
        this.setCapability("unexpectedAlertBehaviour", behaviour);
        return this;
    }

    public ChromeOptions setAcceptInsecureCerts(boolean acceptInsecureCerts) {
        this.setCapability("acceptInsecureCerts", acceptInsecureCerts);
        return this;
    }

    public ChromeOptions setHeadless(boolean headless) {
        this.args.remove("--headless");
        if (headless) {
            this.args.add("--headless");
            this.args.add("--disable-gpu");
        }
        return this;
    }

    public ChromeOptions setProxy(Proxy proxy) {
        this.setCapability("proxy", proxy);
        return this;
    }

    @Deprecated
    MutableCapabilities toCapabilities() {
        return this;
    }

    protected int amendHashCode() {
        return Objects.hash(this.args, this.binary, this.experimentalOptions, this.extensionFiles, this.extensions);
    }

    public Map<String, Object> asMap() {
        TreeMap toReturn = new TreeMap();
        toReturn.putAll(super.asMap());
        TreeMap<String, String> options = new TreeMap<String, String>();
        this.experimentalOptions.forEach(options::put);
        if (this.binary != null) {
            options.put("binary", this.binary);
        }
        options.put("args", (String)ImmutableList.copyOf(this.args));
        options.put("extensions", (String)Stream.concat(this.extensionFiles.stream().map(file -> {
            try {
                return Base64.getEncoder().encodeToString(Files.toByteArray((File)file));
            }
            catch (IOException e) {
                throw new SessionNotCreatedException(e.getMessage(), (Throwable)e);
            }
        }), this.extensions.stream()).collect(ImmutableList.toImmutableList()));
        toReturn.put(CAPABILITY, options);
        return Collections.unmodifiableMap(toReturn);
    }
}

