/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import org.simpleframework.common.buffer.Allocator;
import org.simpleframework.http.core.Collector;
import org.simpleframework.http.core.ContainerEvent;
import org.simpleframework.http.core.Controller;
import org.simpleframework.http.core.Timer;
import org.simpleframework.http.message.Body;
import org.simpleframework.http.message.EntityConsumer;
import org.simpleframework.http.message.Header;
import org.simpleframework.transport.ByteCursor;
import org.simpleframework.transport.Channel;
import org.simpleframework.transport.TransportEvent;
import org.simpleframework.transport.trace.Trace;

class RequestCollector
implements Collector {
    private final EntityConsumer entity;
    private final ByteCursor cursor;
    private final Channel channel;
    private final Trace trace;
    private final Timer timer;

    public RequestCollector(Allocator allocator, Channel channel) {
        this.entity = new EntityConsumer(allocator, channel);
        this.timer = new Timer(TimeUnit.MILLISECONDS);
        this.cursor = channel.getCursor();
        this.trace = channel.getTrace();
        this.channel = channel;
    }

    public void collect(Controller controller) throws IOException {
        while (this.cursor.isReady() && !this.entity.isFinished()) {
            this.timer.set();
            this.entity.consume(this.cursor);
        }
        if (this.cursor.isOpen()) {
            if (this.entity.isFinished()) {
                this.trace.trace((Object)ContainerEvent.REQUEST_READY);
                controller.ready(this);
            } else {
                this.trace.trace((Object)TransportEvent.READ_WAIT);
                controller.select(this);
            }
        }
    }

    public long getTime() {
        return this.timer.get();
    }

    public Header getHeader() {
        return this.entity.getHeader();
    }

    public Body getBody() {
        return this.entity.getBody();
    }

    public Channel getChannel() {
        return this.channel;
    }

    public SocketChannel getSocket() {
        return this.channel.getSocket();
    }
}

