/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.message;

import java.io.IOException;
import org.simpleframework.common.buffer.Allocator;
import org.simpleframework.common.buffer.Buffer;
import org.simpleframework.http.message.Body;
import org.simpleframework.http.message.BufferBody;
import org.simpleframework.http.message.UpdateConsumer;

public class FixedLengthConsumer
extends UpdateConsumer {
    private Allocator allocator;
    private Buffer buffer;
    private long limit;

    public FixedLengthConsumer(Allocator allocator, long limit) {
        this.allocator = allocator;
        this.limit = limit;
    }

    public Body getBody() {
        return new BufferBody(this.buffer);
    }

    private void append(byte[] array, int off, int len) throws IOException {
        if (this.buffer == null) {
            this.buffer = this.allocator.allocate(this.limit);
        }
        this.buffer.append(array, off, len);
    }

    protected int update(byte[] array, int off, int count) throws IOException {
        int mark = (int)this.limit;
        if ((long)count >= this.limit) {
            this.append(array, off, mark);
            this.finished = true;
            this.limit = 0L;
            return count - mark;
        }
        if (count > 0) {
            this.append(array, off, count);
            this.limit -= (long)count;
        }
        return 0;
    }
}

