/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.socket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CloseCode {
    NORMAL_CLOSURE(1000),
    GOING_AWAY(1001),
    PROTOCOL_ERROR(1002),
    UNSUPPORTED_DATA(1003),
    RESERVED(1004),
    NO_STATUS_CODE(1005),
    ABNORMAL_CLOSURE(1006),
    INVALID_FRAME_DATA(1007),
    POLICY_VIOLATION(1008),
    TOO_BIG(1009),
    NO_EXTENSION(1010),
    INTERNAL_SERVER_ERROR(1011),
    TLS_HANDSHAKE_FAILURE(1015);

    public final int code;
    public final int high;
    public final int low;

    private CloseCode(int code) {
        this.high = code & 0xF;
        this.low = code & 0xF0;
        this.code = code;
    }

    public byte[] getData() {
        return new byte[]{(byte)this.high, (byte)this.low};
    }

    public static CloseCode resolveCode(int high, int low) {
        for (CloseCode code : CloseCode.values()) {
            if (code.high != high || code.low != low) continue;
            return code;
        }
        return NO_STATUS_CODE;
    }
}

