/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.data;

import java.util.Iterator;
import org.springframework.batch.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.util.Assert;

public abstract class AbstractPaginatedDataItemReader<T>
extends AbstractItemCountingItemStreamItemReader<T> {
    protected volatile int page = 0;
    protected int pageSize = 10;
    protected Iterator<T> results;
    private Object lock = new Object();

    public void setPageSize(int pageSize) {
        Assert.isTrue((pageSize > 0 ? 1 : 0) != 0, (String)"pageSize must be greater than zero");
        this.pageSize = pageSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected T doRead() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.results == null || !this.results.hasNext()) {
                this.results = this.doPageRead();
                ++this.page;
                if (this.results == null || !this.results.hasNext()) {
                    return null;
                }
            }
            if (this.results.hasNext()) {
                return this.results.next();
            }
            return null;
        }
    }

    protected abstract Iterator<T> doPageRead();

    @Override
    protected void doOpen() throws Exception {
    }

    @Override
    protected void doClose() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void jumpToItem(int itemLastIndex) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.page = itemLastIndex / this.pageSize;
            Iterator<T> initialPage = this.doPageRead();
            for (int current = itemLastIndex % this.pageSize; current >= 0; --current) {
                initialPage.next();
            }
        }
    }
}

