/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.support.transaction;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.springframework.batch.item.WriteFailedException;
import org.springframework.batch.support.transaction.FlushFailedException;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class TransactionAwareBufferedWriter
extends Writer {
    private final Object bufferKey;
    private final Object closeKey;
    private FileChannel channel;
    private final Runnable closeCallback;
    private static final String DEFAULT_CHARSET = "UTF-8";
    private String encoding = "UTF-8";
    private boolean forceSync = false;

    public TransactionAwareBufferedWriter(FileChannel channel, Runnable closeCallback) {
        this.channel = channel;
        this.closeCallback = closeCallback;
        this.bufferKey = new Object();
        this.closeKey = new Object();
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setForceSync(boolean forceSync) {
        this.forceSync = forceSync;
    }

    private StringBuilder getCurrentBuffer() {
        if (!TransactionSynchronizationManager.hasResource((Object)this.bufferKey)) {
            TransactionSynchronizationManager.bindResource((Object)this.bufferKey, (Object)new StringBuilder());
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCompletion(int status) {
                    this.clear();
                }

                public void beforeCommit(boolean readOnly) {
                    try {
                        if (!readOnly) {
                            this.complete();
                        }
                    }
                    catch (IOException e) {
                        throw new FlushFailedException("Could not write to output buffer", e);
                    }
                }

                private void complete() throws IOException {
                    StringBuilder buffer = (StringBuilder)TransactionSynchronizationManager.getResource((Object)TransactionAwareBufferedWriter.this.bufferKey);
                    if (buffer != null) {
                        String string = buffer.toString();
                        byte[] bytes = string.getBytes(TransactionAwareBufferedWriter.this.encoding);
                        int bufferLength = bytes.length;
                        ByteBuffer bb = ByteBuffer.wrap(bytes);
                        int bytesWritten = TransactionAwareBufferedWriter.this.channel.write(bb);
                        if (bytesWritten != bufferLength) {
                            throw new IOException("All bytes to be written were not successfully written");
                        }
                        if (TransactionAwareBufferedWriter.this.forceSync) {
                            TransactionAwareBufferedWriter.this.channel.force(false);
                        }
                        if (TransactionSynchronizationManager.hasResource((Object)TransactionAwareBufferedWriter.this.closeKey)) {
                            TransactionAwareBufferedWriter.this.closeCallback.run();
                        }
                    }
                }

                private void clear() {
                    if (TransactionSynchronizationManager.hasResource((Object)TransactionAwareBufferedWriter.this.bufferKey)) {
                        TransactionSynchronizationManager.unbindResource((Object)TransactionAwareBufferedWriter.this.bufferKey);
                    }
                    if (TransactionSynchronizationManager.hasResource((Object)TransactionAwareBufferedWriter.this.closeKey)) {
                        TransactionSynchronizationManager.unbindResource((Object)TransactionAwareBufferedWriter.this.closeKey);
                    }
                }
            });
        }
        return (StringBuilder)TransactionSynchronizationManager.getResource((Object)this.bufferKey);
    }

    public long getBufferSize() {
        if (!this.transactionActive()) {
            return 0L;
        }
        try {
            return this.getCurrentBuffer().toString().getBytes(this.encoding).length;
        }
        catch (UnsupportedEncodingException e) {
            throw new WriteFailedException("Could not determine buffer size because of unsupported encoding: " + this.encoding, e);
        }
    }

    private boolean transactionActive() {
        return TransactionSynchronizationManager.isActualTransactionActive();
    }

    @Override
    public void close() throws IOException {
        if (this.transactionActive()) {
            if (this.getCurrentBuffer().length() > 0) {
                TransactionSynchronizationManager.bindResource((Object)this.closeKey, (Object)Boolean.TRUE);
            }
            return;
        }
        this.closeCallback.run();
    }

    @Override
    public void flush() throws IOException {
        if (!this.transactionActive() && this.forceSync) {
            this.channel.force(false);
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (!this.transactionActive()) {
            char[] subArray = new char[len];
            System.arraycopy(cbuf, off, subArray, 0, len);
            byte[] bytes = new String(subArray).getBytes(this.encoding);
            int length = bytes.length;
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            int bytesWritten = this.channel.write(bb);
            if (bytesWritten != length) {
                throw new IOException("Unable to write all data.  Bytes to write: " + len + ".  Bytes written: " + bytesWritten);
            }
            return;
        }
        StringBuilder buffer = this.getCurrentBuffer();
        buffer.append(cbuf, off, len);
    }
}

