/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.util;

import java.util.HashMap;
import java.util.Map;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public abstract class EnvironmentTestUtils {
    public static void addEnvironment(ConfigurableApplicationContext context, String ... pairs) {
        EnvironmentTestUtils.addEnvironment(context.getEnvironment(), pairs);
    }

    public static void addEnvironment(ConfigurableEnvironment environment, String ... pairs) {
        EnvironmentTestUtils.addEnvironment("test", environment, pairs);
    }

    public static void addEnvironment(String name, ConfigurableEnvironment environment, String ... pairs) {
        MutablePropertySources sources = environment.getPropertySources();
        Map<String, Object> map = EnvironmentTestUtils.getOrAdd(sources, name);
        String[] stringArray = pairs;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String pair;
            int index = EnvironmentTestUtils.getSeparatorIndex(pair = stringArray[i]);
            String key = pair.substring(0, index > 0 ? index : pair.length());
            String value = index > 0 ? pair.substring(index + 1) : "";
            map.put(key.trim(), value.trim());
        }
    }

    private static Map<String, Object> getOrAdd(MutablePropertySources sources, String name) {
        if (sources.contains(name)) {
            return (Map)sources.get(name).getSource();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        sources.addFirst((PropertySource)new MapPropertySource(name, map));
        return map;
    }

    private static int getSeparatorIndex(String pair) {
        int colonIndex = pair.indexOf(":");
        int equalIndex = pair.indexOf("=");
        if (colonIndex == -1) {
            return equalIndex;
        }
        if (equalIndex == -1) {
            return colonIndex;
        }
        return Math.min(colonIndex, equalIndex);
    }
}

