/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.error;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

public final class ErrorAttributeOptions {
    private final Set<Include> includes;

    private ErrorAttributeOptions(Set<Include> includes) {
        this.includes = includes;
    }

    public boolean isIncluded(Include include) {
        return this.includes.contains((Object)include);
    }

    public Set<Include> getIncludes() {
        return this.includes;
    }

    public ErrorAttributeOptions including(Include ... includes) {
        EnumSet<Include> updated = this.copyIncludes();
        updated.addAll(Arrays.asList(includes));
        return new ErrorAttributeOptions(Collections.unmodifiableSet(updated));
    }

    public ErrorAttributeOptions excluding(Include ... excludes) {
        EnumSet<Include> updated = this.copyIncludes();
        Arrays.stream(excludes).forEach(updated::remove);
        return new ErrorAttributeOptions(Collections.unmodifiableSet(updated));
    }

    public void retainIncluded(Map<String, Object> map) {
        for (Include candidate : Include.values()) {
            if (this.includes.contains((Object)candidate)) continue;
            map.remove(candidate.key);
        }
    }

    private EnumSet<Include> copyIncludes() {
        return this.includes.isEmpty() ? EnumSet.noneOf(Include.class) : EnumSet.copyOf(this.includes);
    }

    public static ErrorAttributeOptions defaults() {
        return ErrorAttributeOptions.of(Include.STATUS, Include.ERROR);
    }

    public static ErrorAttributeOptions of(Include ... includes) {
        return ErrorAttributeOptions.of(Arrays.asList(includes));
    }

    public static ErrorAttributeOptions of(Collection<Include> includes) {
        return new ErrorAttributeOptions(includes.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(EnumSet.copyOf(includes)));
    }

    public static enum Include {
        EXCEPTION("exception"),
        STACK_TRACE("trace"),
        MESSAGE("message"),
        BINDING_ERRORS("errors"),
        STATUS("status"),
        ERROR("error");

        private final String key;

        private Include(String key) {
            this.key = key;
        }
    }
}

