/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.client.discovery.simple;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.cloud.client.DefaultServiceInstance;

@ConfigurationProperties(prefix="spring.cloud.discovery.client.simple")
public class SimpleDiscoveryProperties
implements InitializingBean {
    private Map<String, List<DefaultServiceInstance>> instances = new HashMap<String, List<DefaultServiceInstance>>();
    @NestedConfigurationProperty
    private DefaultServiceInstance local = new DefaultServiceInstance(null, null, null, 0, false);
    private int order = 0;

    public Map<String, List<DefaultServiceInstance>> getInstances() {
        return this.instances;
    }

    public void setInstances(Map<String, List<DefaultServiceInstance>> instances) {
        this.instances = instances;
    }

    public DefaultServiceInstance getLocal() {
        return this.local;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void afterPropertiesSet() {
        for (String key : this.instances.keySet()) {
            for (DefaultServiceInstance instance : this.instances.get(key)) {
                instance.setServiceId(key);
            }
        }
    }

    public void setInstance(String serviceId, String host, int port) {
        this.local = new DefaultServiceInstance(null, serviceId, host, port, false);
    }
}

