/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.ssh;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.transport.URIish;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.config.server.environment.JGitEnvironmentProperties;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentProperties;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@EnableConfigurationProperties(value={MultipleJGitEnvironmentProperties.class})
public class SshPropertyValidator {
    protected static boolean isSshUri(Object uri) {
        if (uri != null) {
            try {
                URIish urIish = new URIish(uri.toString());
                String scheme = urIish.getScheme();
                if (scheme == null && StringUtils.hasText((String)urIish.getHost()) && StringUtils.hasText((String)urIish.getUser())) {
                    return true;
                }
                return scheme != null && !scheme.matches("^(http|https)$");
            }
            catch (URISyntaxException e) {
                return false;
            }
        }
        return false;
    }

    protected List<JGitEnvironmentProperties> extractRepoProperties(MultipleJGitEnvironmentProperties sshUriProperties) {
        ArrayList<JGitEnvironmentProperties> allRepoProperties = new ArrayList<JGitEnvironmentProperties>();
        allRepoProperties.add(sshUriProperties);
        Map<String, MultipleJGitEnvironmentProperties.PatternMatchingJGitEnvironmentProperties> repos = sshUriProperties.getRepos();
        if (repos != null) {
            allRepoProperties.addAll(repos.values());
        }
        return allRepoProperties;
    }
}

