/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.springframework.cloud.contract.spec.ContractVerifierException;
import org.springframework.cloud.contract.verifier.FileSaver;
import org.springframework.cloud.contract.verifier.builder.JavaTestGenerator;
import org.springframework.cloud.contract.verifier.builder.SingleTestGenerator;
import org.springframework.cloud.contract.verifier.config.ContractVerifierConfigProperties;
import org.springframework.cloud.contract.verifier.file.ContractFileScanner;
import org.springframework.cloud.contract.verifier.file.ContractFileScannerBuilder;
import org.springframework.cloud.contract.verifier.file.ContractMetadata;
import org.springframework.cloud.contract.verifier.util.NamesUtil;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.StringUtils;
import wiremock.com.google.common.collect.ListMultimap;

public class TestGenerator
implements GroovyObject {
    private static final String DEFAULT_CLASS_PREFIX = "ContractVerifier";
    private static final String DEFAULT_TEST_PACKAGE = "org.springframework.cloud.contract.verifier.tests";
    private static final Log log;
    private final ContractVerifierConfigProperties configProperties;
    private AtomicInteger counter;
    private SingleTestGenerator generator;
    private FileSaver saver;
    private ContractFileScanner contractFileScanner;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public TestGenerator(ContractVerifierConfigProperties configProperties) {
        this(configProperties, TestGenerator.singleTestGenerator(), new FileSaver(configProperties.getGeneratedTestSourcesDir(), TestGenerator.singleTestGenerator(), configProperties));
    }

    public TestGenerator(ContractVerifierConfigProperties configProperties, SingleTestGenerator generator, FileSaver saver) {
        ContractFileScanner contractFileScanner;
        FileSaver fileSaver;
        SingleTestGenerator singleTestGenerator;
        ContractVerifierConfigProperties contractVerifierConfigProperties;
        MetaClass metaClass;
        AtomicInteger atomicInteger;
        this.counter = atomicInteger = new AtomicInteger();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.configProperties = contractVerifierConfigProperties = configProperties;
        if (configProperties.getContractsDslDir() == null) {
            throw (Throwable)new ContractVerifierException(StringGroovyMethods.plus((CharSequence)"Stubs directory not found under ", (Object)configProperties.getContractsDslDir()));
        }
        this.generator = singleTestGenerator = generator;
        this.saver = fileSaver = saver;
        this.contractFileScanner = contractFileScanner = new ContractFileScannerBuilder().baseDir(configProperties.getContractsDslDir()).excluded((Set)ScriptBytecodeAdapter.asType(configProperties.getExcludedFiles(), Set.class)).ignored((Set)ScriptBytecodeAdapter.asType(configProperties.getIgnoredFiles(), Set.class)).included((Set)ScriptBytecodeAdapter.asType(configProperties.getIncludedFiles(), Set.class)).includeMatcher(this.configProperties.getIncludedContracts()).build();
    }

    private static SingleTestGenerator singleTestGenerator() {
        List factories = SpringFactoriesLoader.loadFactories(SingleTestGenerator.class, null);
        if (factories.isEmpty()) {
            return new JavaTestGenerator();
        }
        return (SingleTestGenerator)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.first((List)factories), SingleTestGenerator.class);
    }

    public int generate() {
        this.generateTestClasses(this.basePackageName());
        NamesUtil.recrusiveDirectoryToPackage(this.configProperties.getGeneratedTestSourcesDir());
        NamesUtil.recrusiveDirectoryToPackage(this.configProperties.getGeneratedTestResourcesDir());
        return this.counter.get();
    }

    private String basePackageName() {
        if (DefaultTypeTransformation.booleanUnbox((Object)this.configProperties.getBasePackageForTests())) {
            return this.configProperties.getBasePackageForTests();
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.configProperties.getBaseClassForTests())) {
            return NamesUtil.toLastDot(this.configProperties.getBaseClassForTests());
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.configProperties.getPackageWithBaseClasses())) {
            return this.configProperties.getPackageWithBaseClasses();
        }
        return DEFAULT_TEST_PACKAGE;
    }

    void generateTestClasses(String basePackageName) {
        Reference basePackageName2 = new Reference((Object)basePackageName);
        ListMultimap<Path, ContractMetadata> contracts = this.contractFileScanner.findContracts();
        public class _generateTestClasses_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference basePackageName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _generateTestClasses_closure1(Object _outerInstance, Object _thisObject, Reference basePackageName) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.basePackageName = reference = basePackageName;
            }

            public Object doCall(Map.Entry<Path, Collection<ContractMetadata>> entry) {
                ((TestGenerator)this.getThisObject()).processIncludedDirectory(((TestGenerator)this.getThisObject()).relativizeContractPath(entry), entry.getValue(), ShortTypeHandling.castToString((Object)this.basePackageName.get()));
                return null;
            }

            public Object call(Map.Entry<Path, Collection<ContractMetadata>> entry) {
                return this.doCall(entry);
            }

            public String getBasePackageName() {
                return ShortTypeHandling.castToString((Object)this.basePackageName.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _generateTestClasses_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        DefaultGroovyMethods.each(contracts.asMap().entrySet(), (Closure)new _generateTestClasses_closure1(this, this, basePackageName2));
    }

    private String relativizeContractPath(Map.Entry<Path, Collection<ContractMetadata>> entry) {
        Path relativePath = this.configProperties.getContractsDslDir().toPath().relativize((Path)ScriptBytecodeAdapter.castToType((Object)entry.getKey(), Path.class));
        if (StringUtils.isEmpty((Object)relativePath.toString())) {
            return DEFAULT_CLASS_PREFIX;
        }
        return relativePath.toString();
    }

    private void processIncludedDirectory(String includedDirectoryRelativePath, Collection<ContractMetadata> contracts, String basePackageNameForClass) {
        if (log.isDebugEnabled()) {
            log.debug((Object)new GStringImpl(new Object[]{contracts, includedDirectoryRelativePath}, new String[]{"Collected contracts with metadata ", " relative path is [", "]"}));
        }
        if (contracts.size() != 0) {
            String className = StringGroovyMethods.plus((String)NamesUtil.afterLast(includedDirectoryRelativePath.toString(), File.separator), (CharSequence)this.resolveNameSuffix());
            String convertedClassName = NamesUtil.convertIllegalPackageChars(className);
            String packageName = TestGenerator.buildPackage(basePackageNameForClass, includedDirectoryRelativePath);
            Path dir = this.saver.generateTestBaseDir(basePackageNameForClass, NamesUtil.convertIllegalPackageChars(includedDirectoryRelativePath.toString()));
            Path classPath = this.saver.pathToClass(dir, convertedClassName);
            byte[] classBytes = this.generator.buildClass(this.configProperties, contracts, includedDirectoryRelativePath, new SingleTestGenerator.GeneratedClassData(convertedClassName, packageName, classPath)).getBytes(StandardCharsets.UTF_8);
            this.saver.saveClassFile(classPath, classBytes);
            this.counter.incrementAndGet();
        }
    }

    private String resolveNameSuffix() {
        String string = this.configProperties.getNameSuffixForTests();
        return DefaultTypeTransformation.booleanUnbox((Object)string) ? string : this.configProperties.getTestFramework().getClassNameSuffix();
    }

    protected static String buildPackage(String packageNameForClass, String includedDirectoryRelativePath) {
        String directory = NamesUtil.beforeLast(includedDirectoryRelativePath, File.separator);
        String convertedPackage = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{packageNameForClass, NamesUtil.directoryToPackage(NamesUtil.convertIllegalPackageChars(directory))}, new String[]{"", ".", ""}));
        return !directory.isEmpty() ? convertedPackage : packageNameForClass;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != TestGenerator.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Log log;
        TestGenerator.log = log = LogFactory.getLog(TestGenerator.class);
    }
}

