/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.ExpirationOptions;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.ValueEncoding;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.KeyScanOptions;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public interface RedisKeyCommands {
    @Nullable
    public Boolean copy(byte[] var1, byte[] var2, boolean var3);

    @Nullable
    default public Boolean exists(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Long count = this.exists(new byte[][]{key});
        return count != null ? Boolean.valueOf(count > 0L) : null;
    }

    @Nullable
    public Long exists(byte[] ... var1);

    @Nullable
    public Long del(byte[] ... var1);

    @Nullable
    public Long unlink(byte[] ... var1);

    @Nullable
    public DataType type(byte[] var1);

    @Nullable
    public Long touch(byte[] ... var1);

    @Nullable
    public Set<byte[]> keys(byte[] var1);

    default public Cursor<byte[]> scan(KeyScanOptions options) {
        return this.scan((ScanOptions)options);
    }

    public Cursor<byte[]> scan(ScanOptions var1);

    @Nullable
    public byte[] randomKey();

    public void rename(byte[] var1, byte[] var2);

    @Nullable
    public Boolean renameNX(byte[] var1, byte[] var2);

    @Nullable
    default public Boolean applyExpiration(byte[] key, Expiration expiration, ExpirationOptions options) {
        if (expiration.isPersistent()) {
            return this.persist(key);
        }
        if (ObjectUtils.nullSafeEquals((Object)ExpirationOptions.none(), (Object)options)) {
            if (ObjectUtils.nullSafeEquals((Object)((Object)TimeUnit.MILLISECONDS), (Object)((Object)expiration.getTimeUnit()))) {
                if (expiration.isUnixTimestamp()) {
                    return this.expireAt(key, expiration.getExpirationTimeInMilliseconds());
                }
                return this.expire(key, expiration.getExpirationTimeInMilliseconds());
            }
            if (expiration.isUnixTimestamp()) {
                return this.expireAt(key, expiration.getExpirationTimeInSeconds());
            }
            return this.expire(key, expiration.getExpirationTimeInSeconds());
        }
        if (ObjectUtils.nullSafeEquals((Object)((Object)TimeUnit.MILLISECONDS), (Object)((Object)expiration.getTimeUnit()))) {
            if (expiration.isUnixTimestamp()) {
                return this.expireAt(key, expiration.getExpirationTimeInMilliseconds(), options.getCondition());
            }
            return this.expire(key, expiration.getExpirationTimeInMilliseconds(), options.getCondition());
        }
        if (expiration.isUnixTimestamp()) {
            return this.expireAt(key, expiration.getExpirationTimeInSeconds(), options.getCondition());
        }
        return this.expire(key, expiration.getExpirationTimeInSeconds(), options.getCondition());
    }

    @Nullable
    default public Boolean expire(byte[] key, long seconds) {
        return this.expire(key, seconds, ExpirationOptions.Condition.ALWAYS);
    }

    @Nullable
    public Boolean expire(byte[] var1, long var2, ExpirationOptions.Condition var4);

    @Nullable
    default public Boolean expire(byte[] key, Duration duration) {
        return this.expire(key, duration.toSeconds());
    }

    @Nullable
    default public Boolean pExpire(byte[] key, long millis) {
        return this.pExpire(key, millis, ExpirationOptions.Condition.ALWAYS);
    }

    @Nullable
    public Boolean pExpire(byte[] var1, long var2, ExpirationOptions.Condition var4);

    @Nullable
    default public Boolean pExpire(byte[] key, Duration duration) {
        return this.pExpire(key, duration.toMillis());
    }

    @Nullable
    default public Boolean expireAt(byte[] key, long unixTime) {
        return this.expireAt(key, unixTime, ExpirationOptions.Condition.ALWAYS);
    }

    @Nullable
    public Boolean expireAt(byte[] var1, long var2, ExpirationOptions.Condition var4);

    @Nullable
    default public Boolean expireAt(byte[] key, Instant unixTime) {
        return this.expireAt(key, unixTime.getEpochSecond());
    }

    @Nullable
    default public Boolean pExpireAt(byte[] key, long unixTimeInMillis) {
        return this.pExpireAt(key, unixTimeInMillis, ExpirationOptions.Condition.ALWAYS);
    }

    @Nullable
    public Boolean pExpireAt(byte[] var1, long var2, ExpirationOptions.Condition var4);

    @Nullable
    default public Boolean pExpireAt(byte[] key, Instant unixTime) {
        return this.pExpireAt(key, unixTime.toEpochMilli());
    }

    @Nullable
    public Boolean persist(byte[] var1);

    @Nullable
    public Boolean move(byte[] var1, int var2);

    @Nullable
    public Long ttl(byte[] var1);

    @Nullable
    public Long ttl(byte[] var1, TimeUnit var2);

    @Nullable
    public Long pTtl(byte[] var1);

    @Nullable
    public Long pTtl(byte[] var1, TimeUnit var2);

    @Nullable
    public List<byte[]> sort(byte[] var1, SortParameters var2);

    @Nullable
    public Long sort(byte[] var1, SortParameters var2, byte[] var3);

    @Nullable
    public byte[] dump(byte[] var1);

    default public void restore(byte[] key, long ttlInMillis, byte[] serializedValue) {
        this.restore(key, ttlInMillis, serializedValue, false);
    }

    public void restore(byte[] var1, long var2, byte[] var4, boolean var5);

    @Nullable
    public ValueEncoding encodingOf(byte[] var1);

    @Nullable
    public Duration idletime(byte[] var1);

    @Nullable
    public Long refcount(byte[] var1);
}

