/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.core;

import org.springframework.integration.kafka.core.Partition;
import org.springframework.util.Assert;

public class KafkaMessageMetadata {
    private final long offset;
    private final long nextOffset;
    private final Partition partition;

    public KafkaMessageMetadata(Partition partition, long offset, long nextOffset) {
        Assert.notNull((Object)partition);
        Assert.isTrue((offset >= 0L ? 1 : 0) != 0);
        Assert.isTrue((nextOffset >= 0L ? 1 : 0) != 0);
        this.offset = offset;
        this.nextOffset = nextOffset;
        this.partition = partition;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getNextOffset() {
        return this.nextOffset;
    }

    public String toString() {
        return "KafkaMessageMetadata [offset=" + this.offset + ", nextOffset=" + this.nextOffset + ", " + this.partition.toString();
    }
}

