/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.serializer.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;

public class AvroSerializer<T> {
    public T deserialize(byte[] bytes, DatumReader<T> reader) throws IOException {
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(bytes, null);
        return (T)reader.read(null, (Decoder)decoder);
    }

    public byte[] serialize(T input, DatumWriter<T> writer) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)stream, null);
        writer.write(input, (Encoder)encoder);
        encoder.flush();
        return stream.toByteArray();
    }
}

