/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.kafka.support.DefaultProducerListener;
import org.springframework.util.ObjectUtils;

public class LoggingProducerListener
extends DefaultProducerListener {
    private static final Log log = LogFactory.getLog(LoggingProducerListener.class);
    private boolean includeContents = true;
    private int maxContentLogged = 100;

    public void setIncludeContents(boolean includeContents) {
        this.includeContents = includeContents;
    }

    public void setMaxContentLogged(int maxContentLogged) {
        this.maxContentLogged = maxContentLogged;
    }

    @Override
    public void onError(String topic, Integer partition, Object key, Object payload, Exception exception) {
        if (log.isErrorEnabled()) {
            StringBuffer logOutput = new StringBuffer();
            logOutput.append("Exception thrown when sending a message");
            if (this.includeContents) {
                logOutput.append(" with key='" + this.toDisplayString(ObjectUtils.nullSafeToString((Object)key), this.maxContentLogged) + "'");
                logOutput.append(" and payload='" + this.toDisplayString(ObjectUtils.nullSafeToString((Object)payload), this.maxContentLogged) + "'");
            }
            logOutput.append(" to topic " + topic);
            if (partition != null) {
                logOutput.append(" and partition " + partition);
            }
            logOutput.append(":");
            log.error((Object)logOutput, (Throwable)exception);
        }
    }

    private String toDisplayString(String original, int maxCharacters) {
        if (original.length() <= maxCharacters) {
            return original;
        }
        return original.substring(0, maxCharacters) + "...";
    }
}

