/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.support;

import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.springframework.integration.kafka.support.ProducerListener;
import org.springframework.util.Assert;

public class ProducerListenerInvokingCallback
implements Callback {
    private final String topic;
    private final Integer partition;
    private final Object key;
    private final Object payload;
    private final ProducerListener producerListener;

    public ProducerListenerInvokingCallback(String topic, Integer partition, Object key, Object payload, ProducerListener producerListener) {
        Assert.notNull((Object)producerListener, (String)"must not be null");
        this.topic = topic;
        this.partition = partition;
        this.key = key;
        this.payload = payload;
        this.producerListener = producerListener;
    }

    public void onCompletion(RecordMetadata metadata, Exception exception) {
        if (exception != null) {
            this.producerListener.onError(this.topic, this.partition, this.key, this.payload, exception);
        } else {
            this.producerListener.onSuccess(this.topic, this.partition, this.key, this.payload, metadata);
        }
    }
}

