/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.dsl;

import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.OffsetCommitCallback;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.integration.dsl.ComponentsRegistration;
import org.springframework.integration.dsl.IntegrationComponentSpec;
import org.springframework.integration.dsl.MessageProducerSpec;
import org.springframework.integration.kafka.inbound.KafkaMessageDrivenChannelAdapter;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.listener.AbstractMessageListenerContainer;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.ErrorHandler;
import org.springframework.kafka.listener.adapter.RecordFilterStrategy;
import org.springframework.kafka.listener.config.ContainerProperties;
import org.springframework.kafka.support.TopicPartitionInitialOffset;
import org.springframework.kafka.support.converter.BatchMessageConverter;
import org.springframework.kafka.support.converter.MessageConverter;
import org.springframework.kafka.support.converter.RecordMessageConverter;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class KafkaMessageDrivenChannelAdapterSpec<K, V, S extends KafkaMessageDrivenChannelAdapterSpec<K, V, S>>
extends MessageProducerSpec<S, KafkaMessageDrivenChannelAdapter<K, V>> {
    KafkaMessageDrivenChannelAdapterSpec(AbstractMessageListenerContainer<K, V> messageListenerContainer, KafkaMessageDrivenChannelAdapter.ListenerMode listenerMode) {
        super(new KafkaMessageDrivenChannelAdapter<K, V>(messageListenerContainer, listenerMode));
    }

    public S messageConverter(MessageConverter messageConverter) {
        ((KafkaMessageDrivenChannelAdapter)((Object)this.target)).setMessageConverter(messageConverter);
        return (S)((Object)((KafkaMessageDrivenChannelAdapterSpec)this._this()));
    }

    public S recordMessageConverter(RecordMessageConverter messageConverter) {
        ((KafkaMessageDrivenChannelAdapter)((Object)this.target)).setRecordMessageConverter(messageConverter);
        return (S)((Object)((KafkaMessageDrivenChannelAdapterSpec)this._this()));
    }

    public S batchMessageConverter(BatchMessageConverter messageConverter) {
        ((KafkaMessageDrivenChannelAdapter)((Object)this.target)).setBatchMessageConverter(messageConverter);
        return (S)((Object)((KafkaMessageDrivenChannelAdapterSpec)this._this()));
    }

    public S recordFilterStrategy(RecordFilterStrategy<K, V> recordFilterStrategy) {
        ((KafkaMessageDrivenChannelAdapter)((Object)this.target)).setRecordFilterStrategy(recordFilterStrategy);
        return (S)((Object)((KafkaMessageDrivenChannelAdapterSpec)this._this()));
    }

    public S ackDiscarded(boolean ackDiscarded) {
        ((KafkaMessageDrivenChannelAdapter)((Object)this.target)).setAckDiscarded(ackDiscarded);
        return (S)((Object)((KafkaMessageDrivenChannelAdapterSpec)this._this()));
    }

    public S retryTemplate(RetryTemplate retryTemplate) {
        ((KafkaMessageDrivenChannelAdapter)((Object)this.target)).setRetryTemplate(retryTemplate);
        return (S)((Object)((KafkaMessageDrivenChannelAdapterSpec)this._this()));
    }

    public S recoveryCallback(RecoveryCallback<? extends Object> recoveryCallback) {
        ((KafkaMessageDrivenChannelAdapter)((Object)this.target)).setRecoveryCallback(recoveryCallback);
        return (S)((Object)((KafkaMessageDrivenChannelAdapterSpec)this._this()));
    }

    public S filterInRetry(boolean filterInRetry) {
        ((KafkaMessageDrivenChannelAdapter)((Object)this.target)).setFilterInRetry(filterInRetry);
        return (S)((Object)((KafkaMessageDrivenChannelAdapterSpec)this._this()));
    }

    public static class KafkaMessageListenerContainerSpec<K, V>
    extends IntegrationComponentSpec<KafkaMessageListenerContainerSpec<K, V>, ConcurrentMessageListenerContainer<K, V>> {
        private final ConcurrentMessageListenerContainer<K, V> container;

        KafkaMessageListenerContainerSpec(ConsumerFactory<K, V> consumerFactory, ContainerProperties containerProperties) {
            this.container = new ConcurrentMessageListenerContainer(consumerFactory, containerProperties);
        }

        KafkaMessageListenerContainerSpec(ConsumerFactory<K, V> consumerFactory, TopicPartitionInitialOffset ... topicPartitions) {
            this(consumerFactory, new ContainerProperties(topicPartitions));
        }

        KafkaMessageListenerContainerSpec(ConsumerFactory<K, V> consumerFactory, String ... topics) {
            this(consumerFactory, new ContainerProperties(topics));
        }

        KafkaMessageListenerContainerSpec(ConsumerFactory<K, V> consumerFactory, Pattern topicPattern) {
            this(consumerFactory, new ContainerProperties(topicPattern));
        }

        public KafkaMessageListenerContainerSpec<K, V> id(String id) {
            return (KafkaMessageListenerContainerSpec)super.id(id);
        }

        public KafkaMessageListenerContainerSpec<K, V> concurrency(int concurrency) {
            this.container.setConcurrency(concurrency);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> errorHandler(ErrorHandler errorHandler) {
            this.container.getContainerProperties().setErrorHandler(errorHandler);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> ackMode(AbstractMessageListenerContainer.AckMode ackMode) {
            this.container.getContainerProperties().setAckMode(ackMode);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> pollTimeout(long pollTimeout) {
            this.container.getContainerProperties().setPollTimeout(pollTimeout);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> ackCount(int count) {
            this.container.getContainerProperties().setAckCount(count);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> ackTime(long millis) {
            this.container.getContainerProperties().setAckTime(millis);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> consumerTaskExecutor(AsyncListenableTaskExecutor consumerTaskExecutor) {
            this.container.getContainerProperties().setConsumerTaskExecutor(consumerTaskExecutor);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> shutdownTimeout(long shutdownTimeout) {
            this.container.getContainerProperties().setShutdownTimeout(shutdownTimeout);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> consumerRebalanceListener(ConsumerRebalanceListener consumerRebalanceListener) {
            this.container.getContainerProperties().setConsumerRebalanceListener(consumerRebalanceListener);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> commitCallback(OffsetCommitCallback commitCallback) {
            this.container.getContainerProperties().setCommitCallback(commitCallback);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> syncCommits(boolean syncCommits) {
            this.container.getContainerProperties().setSyncCommits(syncCommits);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> idleEventInterval(Long idleEventInterval) {
            this.container.getContainerProperties().setIdleEventInterval(idleEventInterval);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> ackOnError(boolean ackOnError) {
            this.container.getContainerProperties().setAckOnError(ackOnError);
            return this;
        }

        public KafkaMessageListenerContainerSpec<K, V> groupId(String groupId) {
            this.container.getContainerProperties().setGroupId(groupId);
            return this;
        }
    }

    public static class KafkaMessageDrivenChannelAdapterListenerContainerSpec<K, V>
    extends KafkaMessageDrivenChannelAdapterSpec<K, V, KafkaMessageDrivenChannelAdapterListenerContainerSpec<K, V>>
    implements ComponentsRegistration {
        private final KafkaMessageListenerContainerSpec<K, V> spec;

        KafkaMessageDrivenChannelAdapterListenerContainerSpec(KafkaMessageListenerContainerSpec<K, V> spec, KafkaMessageDrivenChannelAdapter.ListenerMode listenerMode) {
            super(((KafkaMessageListenerContainerSpec)spec).container, listenerMode);
            this.spec = spec;
        }

        public KafkaMessageDrivenChannelAdapterListenerContainerSpec<K, V> configureListenerContainer(Consumer<KafkaMessageListenerContainerSpec<K, V>> configurer) {
            Assert.notNull(configurer, (String)"The 'configurer' cannot be null");
            configurer.accept(this.spec);
            return (KafkaMessageDrivenChannelAdapterListenerContainerSpec)this._this();
        }

        public Map<Object, String> getComponentsToRegister() {
            return Collections.singletonMap(((KafkaMessageListenerContainerSpec)this.spec).container, this.spec.getId());
        }
    }
}

