/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.inbound;

import java.util.List;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.core.AttributeAccessor;
import org.springframework.integration.context.OrderlyShutdownCapable;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.kafka.support.RawRecordHeaderErrorMessageStrategy;
import org.springframework.integration.support.ErrorMessageUtils;
import org.springframework.kafka.listener.AbstractMessageListenerContainer;
import org.springframework.kafka.listener.BatchMessageListener;
import org.springframework.kafka.listener.MessageListener;
import org.springframework.kafka.listener.adapter.BatchMessagingMessageListenerAdapter;
import org.springframework.kafka.listener.adapter.FilteringBatchMessageListenerAdapter;
import org.springframework.kafka.listener.adapter.FilteringMessageListenerAdapter;
import org.springframework.kafka.listener.adapter.RecordFilterStrategy;
import org.springframework.kafka.listener.adapter.RecordMessagingMessageListenerAdapter;
import org.springframework.kafka.listener.adapter.RetryingMessageListenerAdapter;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.kafka.support.converter.BatchMessageConverter;
import org.springframework.kafka.support.converter.ConversionException;
import org.springframework.kafka.support.converter.MessageConverter;
import org.springframework.kafka.support.converter.RecordMessageConverter;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryListener;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class KafkaMessageDrivenChannelAdapter<K, V>
extends MessageProducerSupport
implements OrderlyShutdownCapable {
    private static final ThreadLocal<AttributeAccessor> attributesHolder = new ThreadLocal();
    private final AbstractMessageListenerContainer<K, V> messageListenerContainer;
    private final IntegrationRecordMessageListener recordListener = new IntegrationRecordMessageListener();
    private final IntegrationBatchMessageListener batchListener = new IntegrationBatchMessageListener();
    private final ListenerMode mode;
    private RecordFilterStrategy<K, V> recordFilterStrategy;
    private boolean ackDiscarded;
    private RetryTemplate retryTemplate;
    private RecoveryCallback<? extends Object> recoveryCallback;
    private boolean filterInRetry;

    public KafkaMessageDrivenChannelAdapter(AbstractMessageListenerContainer<K, V> messageListenerContainer) {
        this(messageListenerContainer, ListenerMode.record);
    }

    public KafkaMessageDrivenChannelAdapter(AbstractMessageListenerContainer<K, V> messageListenerContainer, ListenerMode mode) {
        Assert.notNull(messageListenerContainer, (String)"messageListenerContainer is required");
        Assert.isNull((Object)messageListenerContainer.getContainerProperties().getMessageListener(), (String)"Container must not already have a listener");
        this.messageListenerContainer = messageListenerContainer;
        this.messageListenerContainer.setAutoStartup(false);
        this.mode = mode;
        this.setErrorMessageStrategy(new RawRecordHeaderErrorMessageStrategy());
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        if (messageConverter instanceof RecordMessageConverter) {
            this.recordListener.setMessageConverter((RecordMessageConverter)messageConverter);
        } else if (messageConverter instanceof BatchMessageConverter) {
            this.batchListener.setBatchMessageConverter((BatchMessageConverter)messageConverter);
        } else {
            throw new IllegalArgumentException("Message converter must be a 'RecordMessageConverter' or 'BatchMessageConverter'");
        }
    }

    public void setRecordMessageConverter(RecordMessageConverter messageConverter) {
        this.recordListener.setMessageConverter(messageConverter);
    }

    public void setBatchMessageConverter(BatchMessageConverter messageConverter) {
        this.batchListener.setBatchMessageConverter(messageConverter);
    }

    public void setRecordFilterStrategy(RecordFilterStrategy<K, V> recordFilterStrategy) {
        this.recordFilterStrategy = recordFilterStrategy;
    }

    public void setAckDiscarded(boolean ackDiscarded) {
        this.ackDiscarded = ackDiscarded;
    }

    public void setRetryTemplate(RetryTemplate retryTemplate) {
        Assert.isTrue((retryTemplate == null || this.mode.equals((Object)ListenerMode.record) ? 1 : 0) != 0, (String)"Retry is not supported with mode=batch");
        this.retryTemplate = retryTemplate;
    }

    public void setRecoveryCallback(RecoveryCallback<? extends Object> recoveryCallback) {
        this.recoveryCallback = recoveryCallback;
    }

    public void setFilterInRetry(boolean filterInRetry) {
        this.filterInRetry = filterInRetry;
    }

    public void setPayloadType(Class<?> payloadType) {
        this.recordListener.setFallbackType(payloadType);
        this.batchListener.setFallbackType(payloadType);
    }

    protected void onInit() {
        super.onInit();
        if (this.retryTemplate != null) {
            Assert.state((this.getErrorChannel() == null ? 1 : 0) != 0, (String)"Cannot have an 'errorChannel' property when a 'RetryTemplate' is provided; use an 'ErrorMessageSendingRecoverer' in the 'recoveryCallback' property to send an error message when retries are exhausted");
        }
        if (this.mode.equals((Object)ListenerMode.record)) {
            boolean filterInRetry;
            IntegrationRecordMessageListener listener = this.recordListener;
            boolean bl = filterInRetry = this.filterInRetry && this.retryTemplate != null && this.recordFilterStrategy != null;
            if (filterInRetry) {
                listener = new FilteringMessageListenerAdapter((MessageListener)listener, this.recordFilterStrategy, this.ackDiscarded);
                listener = new RetryingMessageListenerAdapter((MessageListener)listener, this.retryTemplate, this.recoveryCallback);
                this.retryTemplate.registerListener((RetryListener)this.recordListener);
            } else {
                if (this.retryTemplate != null) {
                    listener = new RetryingMessageListenerAdapter((MessageListener)listener, this.retryTemplate, this.recoveryCallback);
                    this.retryTemplate.registerListener((RetryListener)this.recordListener);
                }
                if (this.recordFilterStrategy != null) {
                    listener = new FilteringMessageListenerAdapter((MessageListener)listener, this.recordFilterStrategy, this.ackDiscarded);
                }
            }
            this.messageListenerContainer.getContainerProperties().setMessageListener((Object)listener);
        } else {
            IntegrationBatchMessageListener listener = this.batchListener;
            if (this.recordFilterStrategy != null) {
                listener = new FilteringBatchMessageListenerAdapter((BatchMessageListener)listener, this.recordFilterStrategy, this.ackDiscarded);
            }
            this.messageListenerContainer.getContainerProperties().setMessageListener((Object)listener);
        }
    }

    protected void doStart() {
        this.messageListenerContainer.start();
    }

    protected void doStop() {
        this.messageListenerContainer.stop();
    }

    public String getComponentType() {
        return "kafka:message-driven-channel-adapter";
    }

    public int beforeShutdown() {
        this.messageListenerContainer.stop();
        return this.getPhase();
    }

    public int afterShutdown() {
        return this.getPhase();
    }

    private void setAttributesIfNecessary(Object record, Message<?> message) {
        AttributeAccessor attributes;
        boolean needHolder = this.getErrorChannel() != null && this.retryTemplate == null;
        boolean needAttributes = needHolder | this.retryTemplate != null;
        if (needHolder) {
            attributesHolder.set(ErrorMessageUtils.getAttributeAccessor(null, null));
        }
        if (needAttributes && (attributes = attributesHolder.get()) != null) {
            attributes.setAttribute("inputMessage", message);
            attributes.setAttribute("kafka_data", record);
        }
    }

    protected AttributeAccessor getErrorMessageAttributes(Message<?> message) {
        AttributeAccessor attributes = attributesHolder.get();
        if (attributes == null) {
            return super.getErrorMessageAttributes(message);
        }
        return attributes;
    }

    private class IntegrationBatchMessageListener
    extends BatchMessagingMessageListenerAdapter<K, V>
    implements RetryListener {
        IntegrationBatchMessageListener() {
            super(null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(List<ConsumerRecord<K, V>> records, Acknowledgment acknowledgment, Consumer<?, ?> consumer) {
            Message message;
            block8: {
                message = null;
                try {
                    message = this.toMessagingMessage(records, acknowledgment, consumer);
                    KafkaMessageDrivenChannelAdapter.this.setAttributesIfNecessary(records, message);
                }
                catch (RuntimeException e) {
                    ConversionException exception = new ConversionException("Failed to convert to message for: " + records, (Throwable)e);
                    if (KafkaMessageDrivenChannelAdapter.this.getErrorChannel() == null) break block8;
                    KafkaMessageDrivenChannelAdapter.this.getMessagingTemplate().send((Object)KafkaMessageDrivenChannelAdapter.this.getErrorChannel(), (Message)new ErrorMessage((Throwable)exception));
                }
            }
            if (message != null) {
                try {
                    KafkaMessageDrivenChannelAdapter.this.sendMessage(message);
                }
                finally {
                    if (KafkaMessageDrivenChannelAdapter.this.retryTemplate == null) {
                        attributesHolder.remove();
                    }
                }
            } else {
                KafkaMessageDrivenChannelAdapter.this.logger.debug((Object)("Converter returned a null message for: " + records));
            }
        }

        public <T, E extends Throwable> boolean open(RetryContext context, RetryCallback<T, E> callback) {
            if (KafkaMessageDrivenChannelAdapter.this.recoveryCallback != null) {
                attributesHolder.set(context);
            }
            return true;
        }

        public <T, E extends Throwable> void close(RetryContext context, RetryCallback<T, E> callback, Throwable throwable) {
            attributesHolder.remove();
        }

        public <T, E extends Throwable> void onError(RetryContext context, RetryCallback<T, E> callback, Throwable throwable) {
        }
    }

    private class IntegrationRecordMessageListener
    extends RecordMessagingMessageListenerAdapter<K, V>
    implements RetryListener {
        IntegrationRecordMessageListener() {
            super(null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(ConsumerRecord<K, V> record, Acknowledgment acknowledgment, Consumer<?, ?> consumer) {
            Message message = null;
            try {
                message = this.toMessagingMessage(record, acknowledgment, consumer);
                KafkaMessageDrivenChannelAdapter.this.setAttributesIfNecessary(record, message);
            }
            catch (RuntimeException e) {
                ConversionException exception = new ConversionException("Failed to convert to message for: " + record, (Throwable)e);
                KafkaMessageDrivenChannelAdapter.this.sendErrorMessageIfNecessary(null, (RuntimeException)exception);
            }
            if (message != null) {
                try {
                    KafkaMessageDrivenChannelAdapter.this.sendMessage(message);
                }
                finally {
                    if (KafkaMessageDrivenChannelAdapter.this.retryTemplate == null) {
                        attributesHolder.remove();
                    }
                }
            } else {
                KafkaMessageDrivenChannelAdapter.this.logger.debug((Object)("Converter returned a null message for: " + record));
            }
        }

        public <T, E extends Throwable> boolean open(RetryContext context, RetryCallback<T, E> callback) {
            if (KafkaMessageDrivenChannelAdapter.this.recoveryCallback != null) {
                attributesHolder.set(context);
            }
            return true;
        }

        public <T, E extends Throwable> void close(RetryContext context, RetryCallback<T, E> callback, Throwable throwable) {
            attributesHolder.remove();
        }

        public <T, E extends Throwable> void onError(RetryContext context, RetryCallback<T, E> callback, Throwable throwable) {
        }
    }

    public static enum ListenerMode {
        record,
        batch;

    }
}

