/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.MatchableHandlerMapping;

public class HandlerMappingIntrospector
implements CorsConfigurationSource {
    private final List<HandlerMapping> handlerMappings;

    public HandlerMappingIntrospector(ApplicationContext context) {
        this.handlerMappings = HandlerMappingIntrospector.initHandlerMappings(context);
    }

    private static List<HandlerMapping> initHandlerMappings(ApplicationContext context) {
        Map beans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)context, HandlerMapping.class, (boolean)true, (boolean)false);
        if (!beans.isEmpty()) {
            ArrayList<HandlerMapping> mappings = new ArrayList<HandlerMapping>(beans.values());
            AnnotationAwareOrderComparator.sort(mappings);
            return mappings;
        }
        return HandlerMappingIntrospector.initDefaultHandlerMappings(context);
    }

    private static List<HandlerMapping> initDefaultHandlerMappings(ApplicationContext context) {
        Properties props;
        String path = "DispatcherServlet.properties";
        try {
            ClassPathResource resource = new ClassPathResource(path, DispatcherServlet.class);
            props = PropertiesLoaderUtils.loadProperties((Resource)resource);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not load '" + path + "': " + ex.getMessage());
        }
        String value = props.getProperty(HandlerMapping.class.getName());
        String[] names = StringUtils.commaDelimitedListToStringArray((String)value);
        ArrayList<HandlerMapping> result = new ArrayList<HandlerMapping>(names.length);
        for (String name : names) {
            try {
                Class clazz = ClassUtils.forName((String)name, (ClassLoader)DispatcherServlet.class.getClassLoader());
                Object mapping = context.getAutowireCapableBeanFactory().createBean(clazz);
                result.add((HandlerMapping)mapping);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException("Could not find default HandlerMapping [" + name + "]");
            }
        }
        return result;
    }

    public List<HandlerMapping> getHandlerMappings() {
        return this.handlerMappings;
    }

    public MatchableHandlerMapping getMatchableHandlerMapping(HttpServletRequest request) throws Exception {
        RequestAttributeChangeIgnoringWrapper wrapper = new RequestAttributeChangeIgnoringWrapper(request);
        for (HandlerMapping handlerMapping : this.handlerMappings) {
            HandlerExecutionChain handler = handlerMapping.getHandler((HttpServletRequest)wrapper);
            if (handler == null) continue;
            if (handlerMapping instanceof MatchableHandlerMapping) {
                return (MatchableHandlerMapping)handlerMapping;
            }
            throw new IllegalStateException("HandlerMapping is not a MatchableHandlerMapping");
        }
        return null;
    }

    public CorsConfiguration getCorsConfiguration(HttpServletRequest request) {
        RequestAttributeChangeIgnoringWrapper wrapper = new RequestAttributeChangeIgnoringWrapper(request);
        for (HandlerMapping handlerMapping : this.handlerMappings) {
            HandlerExecutionChain handler = null;
            try {
                handler = handlerMapping.getHandler((HttpServletRequest)wrapper);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (handler == null) continue;
            if (handler.getInterceptors() != null) {
                for (HandlerInterceptor interceptor : handler.getInterceptors()) {
                    if (!(interceptor instanceof CorsConfigurationSource)) continue;
                    return ((CorsConfigurationSource)interceptor).getCorsConfiguration((HttpServletRequest)wrapper);
                }
            }
            if (!(handler.getHandler() instanceof CorsConfigurationSource)) continue;
            return ((CorsConfigurationSource)handler.getHandler()).getCorsConfiguration((HttpServletRequest)wrapper);
        }
        return null;
    }

    private static class RequestAttributeChangeIgnoringWrapper
    extends HttpServletRequestWrapper {
        public RequestAttributeChangeIgnoringWrapper(HttpServletRequest request) {
            super(request);
        }

        public void setAttribute(String name, Object value) {
        }
    }
}

