/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.faces.webflow;

import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextWrapper;
import org.springframework.util.ClassUtils;

public class JsfRuntimeInformation {
    private static final ClassLoader CLASSLOADER = JsfRuntimeInformation.class.getClassLoader();
    private static final boolean mojarraPresent = ClassUtils.isPresent((String)"com.sun.faces.context.FacesContextImpl", (ClassLoader)CLASSLOADER);
    private static final boolean myFacesPresent = ClassUtils.isPresent((String)"org.apache.myfaces.webapp.MyFacesServlet", (ClassLoader)CLASSLOADER);
    private static Boolean myFacesInUse;

    public static boolean isAtLeastJsf22() {
        return true;
    }

    public static boolean isAtLeastJsf21() {
        return true;
    }

    public static boolean isAtLeastJsf20() {
        return true;
    }

    public static boolean isAtLeastJsf12() {
        return true;
    }

    public static boolean isLessThanJsf20() {
        return false;
    }

    public static boolean isMojarraPresent() {
        return mojarraPresent;
    }

    public static boolean isMyFacesPresent() {
        return myFacesPresent;
    }

    public static boolean isMyFacesInUse() {
        if (myFacesInUse == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (facesContext == null) {
                return false;
            }
            while (facesContext instanceof FacesContextWrapper) {
                facesContext = ((FacesContextWrapper)facesContext).getWrapped();
            }
            myFacesInUse = facesContext.getClass().getPackage().getName().startsWith("org.apache.myfaces.");
        }
        return myFacesInUse;
    }
}

