/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.cluster;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.ssssssss.magicapi.cluster.ClusterConfig;
import org.ssssssss.magicapi.cluster.MagicSynchronizationService;
import org.ssssssss.magicapi.core.config.MagicAPIProperties;
import org.ssssssss.magicapi.core.config.MagicPluginConfiguration;
import org.ssssssss.magicapi.core.model.MagicNotify;
import org.ssssssss.magicapi.core.model.Plugin;
import org.ssssssss.magicapi.core.service.MagicAPIService;
import org.ssssssss.magicapi.core.service.MagicNotifyService;
import org.ssssssss.magicapi.redis.RedisModule;
import org.ssssssss.magicapi.utils.JsonUtils;

@EnableConfigurationProperties(value={ClusterConfig.class})
@Configuration
public class MagicClusterConfiguration
implements MagicPluginConfiguration {
    private final ClusterConfig config;
    private final MagicAPIProperties properties;
    private final Logger logger = LoggerFactory.getLogger(MagicClusterConfiguration.class);

    public MagicClusterConfiguration(MagicAPIProperties properties, ClusterConfig config) {
        this.properties = properties;
        this.config = config;
    }

    public Plugin plugin() {
        return new Plugin("Cluster");
    }

    @Bean
    @ConditionalOnMissingBean
    public MagicNotifyService magicNotifyService(RedisModule redisModule) {
        return magicNotify -> redisModule.execute("publish", Arrays.asList(this.config.getChannel(), JsonUtils.toJsonString((Object)magicNotify)));
    }

    @Bean
    @ConditionalOnMissingBean
    public MagicSynchronizationService magicSynchronizationService(MagicNotifyService magicNotifyService) {
        return new MagicSynchronizationService(magicNotifyService, this.properties.getInstanceId());
    }

    @Bean
    public RedisMessageListenerContainer magicRedisMessageListenerContainer(RedisConnectionFactory redisConnectionFactory, MagicAPIService magicAPIService) {
        this.logger.info("\u5f00\u542f\u96c6\u7fa4\u901a\u77e5\u76d1\u542c\uff0c Redis channel: {}", (Object)this.config.getChannel());
        RedisMessageListenerContainer redisMessageListenerContainer = new RedisMessageListenerContainer();
        redisMessageListenerContainer.setConnectionFactory(redisConnectionFactory);
        redisMessageListenerContainer.addMessageListener((message, pattern) -> magicAPIService.processNotify((MagicNotify)JsonUtils.readValue((byte[])message.getBody(), MagicNotify.class)), (Topic)ChannelTopic.of((String)this.config.getChannel()));
        return redisMessageListenerContainer;
    }
}

