/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.core.resource;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public interface Resource {
    default public boolean readonly() {
        return false;
    }

    default public boolean exists() {
        return false;
    }

    default public boolean isDirectory() {
        return false;
    }

    default public boolean delete() {
        return false;
    }

    default public boolean mkdir() {
        return false;
    }

    default public boolean renameTo(Resource resource) {
        return false;
    }

    default public boolean write(String content) {
        return false;
    }

    default public boolean write(byte[] bytes) {
        return false;
    }

    default public String separator() {
        return null;
    }

    default public void processExport(ZipOutputStream zos, String path, Resource directory, List<Resource> resources, List<String> excludes) throws IOException {
        for (Resource resource : resources) {
            String fullName = directory.getAbsolutePath();
            if (!fullName.endsWith(this.separator())) {
                fullName = fullName + this.separator();
            }
            fullName = fullName + resource.name();
            if (resource.isDirectory()) {
                fullName = fullName + this.separator();
            }
            if (!fullName.equals(resource.getAbsolutePath()) || excludes.contains(resource.name())) continue;
            if (resource.isDirectory()) {
                String newPath = path + resource.name() + "/";
                zos.putNextEntry(new ZipEntry(newPath));
                zos.closeEntry();
                this.processExport(zos, newPath, resource, resources, excludes);
                continue;
            }
            zos.putNextEntry(new ZipEntry(path + resource.name()));
            zos.write(resource.read());
            zos.closeEntry();
        }
    }

    default public void export(OutputStream os, String ... excludes) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(os);
        this.processExport(zos, "", this, this.resources(), Arrays.asList(excludes == null ? new String[]{} : excludes));
        zos.close();
    }

    public byte[] read();

    default public void readAll() {
    }

    default public Resource getDirectory(String name) {
        return this.getResource(name);
    }

    public Resource getResource(String var1);

    public String name();

    public List<Resource> resources();

    public Resource parent();

    public List<Resource> dirs();

    public List<Resource> files(String var1);

    public String getAbsolutePath();

    public String getFilePath();
}

