/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.core.service;

import java.util.Objects;
import org.ssssssss.magicapi.core.config.JsonCodeConstants;
import org.ssssssss.magicapi.core.model.MagicEntity;
import org.ssssssss.magicapi.core.model.PathMagicEntity;
import org.ssssssss.magicapi.core.service.MagicResourceService;
import org.ssssssss.magicapi.core.service.MagicResourceStorage;
import org.ssssssss.magicapi.utils.PathUtils;

public abstract class AbstractPathMagicResourceStorage<T extends PathMagicEntity>
implements MagicResourceStorage<T>,
JsonCodeConstants {
    protected MagicResourceService magicResourceService;

    @Override
    public String suffix() {
        return ".ms";
    }

    @Override
    public boolean requirePath() {
        return true;
    }

    @Override
    public void setMagicResourceService(MagicResourceService magicResourceService) {
        this.magicResourceService = magicResourceService;
    }

    public String buildMappingKey(T entity, String path) {
        return PathUtils.replaceSlash("/" + Objects.toString(path, "") + "/" + Objects.toString(((PathMagicEntity)entity).getPath(), ""));
    }

    @Override
    public void validate(T entity) {
        this.notBlank(((PathMagicEntity)entity).getPath(), REQUEST_PATH_REQUIRED);
        this.notBlank(((MagicEntity)entity).getScript(), SCRIPT_REQUIRED);
    }
}

