/*
 * Decompiled with CFR 0.152.
 */
package org.ssssssss.magicapi.modules.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;

public class SingleRowResultSetExtractor<T>
implements ResultSetExtractor<T> {
    private final boolean singleColumn;
    private final RowMapper<T> mapper;
    private final Class<T> requiredType;

    public SingleRowResultSetExtractor(RowMapper<T> mapper) {
        this(mapper, null, false);
    }

    public SingleRowResultSetExtractor(Class<T> requiredType) {
        this(null, requiredType, true);
    }

    private SingleRowResultSetExtractor(RowMapper<T> mapper, Class<T> requiredType, boolean singleColumn) {
        this.mapper = mapper;
        this.requiredType = requiredType;
        this.singleColumn = singleColumn;
    }

    public T extractData(ResultSet rs) throws SQLException, DataAccessException {
        if (rs.next()) {
            if (this.singleColumn) {
                return (T)JdbcUtils.getResultSetValue((ResultSet)rs, (int)1, this.requiredType);
            }
            return (T)this.mapper.mapRow(rs, 0);
        }
        return null;
    }
}

