/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import ise.antelope.tasks.StopWatch;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class StopWatchTask
extends Task {
    private String name = null;
    private String action = null;
    private static Hashtable watches = null;
    private static final String STOP = "stop";
    private static final String START = "start";
    private static final String ELAPSED = "elapsed";
    private static final String TOTAL = "total";

    public void setName(String name) {
        this.name = name;
    }

    public void setAction(String action) {
        if (!((action = action.toLowerCase()).equals(STOP) || action.equals(START) || action.equals(ELAPSED) || action.equals(TOTAL))) {
            throw new BuildException("invalid action: " + action);
        }
        this.action = action;
    }

    public void execute() {
        StopWatch sw;
        if (this.name == null) {
            throw new BuildException("name is null");
        }
        if (this.action == null) {
            this.action = START;
        }
        if (watches == null) {
            watches = new Hashtable();
        }
        if ((sw = (StopWatch)watches.get(this.name)) == null && this.action.equals(START)) {
            sw = new StopWatch(this.name);
            watches.put(this.name, sw);
            return;
        }
        if (sw == null) {
            return;
        }
        if (this.action.equals(START)) {
            sw.start();
            return;
        }
        if (this.action.equals(STOP)) {
            sw.stop();
            return;
        }
        if (this.action.equals(TOTAL)) {
            String time = sw.format(sw.total());
            this.log("[" + this.name + ": " + time + "]");
            this.getProject().setProperty(this.name, time);
            return;
        }
        if (this.action.equals(ELAPSED)) {
            String time = sw.format(sw.elapsed());
            this.log("[" + this.name + ": " + time + "]");
            this.getProject().setProperty(this.name, time);
            return;
        }
    }
}

