/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.zip;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.zeroturnaround.zip.FileSource;
import org.zeroturnaround.zip.ZipBreakException;
import org.zeroturnaround.zip.ZipEntryCallback;
import org.zeroturnaround.zip.ZipEntrySource;
import org.zeroturnaround.zip.ZipInfoCallback;
import org.zeroturnaround.zip.ZipUtil;
import org.zeroturnaround.zip.transform.ZipEntryTransformer;
import org.zeroturnaround.zip.transform.ZipEntryTransformerEntry;

public class Zips {
    private final File src;
    private File dest;
    private Charset charset;
    private boolean preserveTimestamps;
    private List changedEntries = new ArrayList();
    private Set removedEntries = new HashSet();
    private List transformers = new ArrayList();

    private Zips(File src) {
        this.src = src;
    }

    public static Zips get(File src) {
        return new Zips(src);
    }

    public static Zips create() {
        return new Zips(null);
    }

    public Zips addEntry(ZipEntrySource entry) {
        this.changedEntries.add(entry);
        return this;
    }

    public Zips addEntries(ZipEntrySource[] entries) {
        this.changedEntries.addAll(Arrays.asList(entries));
        return this;
    }

    public Zips addFile(File file) {
        return this.addFile(file, false, null);
    }

    public Zips addFile(File file, boolean preserveRoot) {
        return this.addFile(file, preserveRoot, null);
    }

    public Zips addFile(File file, FileFilter filter) {
        return this.addFile(file, false, filter);
    }

    public Zips addFile(File file, boolean preserveRoot, FileFilter filter) {
        if (!file.isDirectory()) {
            this.changedEntries.add(new FileSource(file.getName(), file));
            return this;
        }
        Collection files = FileUtils.listFiles((File)file, null, (boolean)true);
        Iterator iter = files.iterator();
        while (iter.hasNext()) {
            File entryFile = (File)iter.next();
            if (filter != null && !filter.accept(entryFile)) continue;
            String entryPath = this.getRelativePath(file, entryFile);
            if (preserveRoot) {
                entryPath = file.getName() + entryPath;
            }
            if (entryPath.startsWith("/")) {
                entryPath = entryPath.substring(1);
            }
            this.changedEntries.add(new FileSource(entryPath, entryFile));
        }
        return this;
    }

    private String getRelativePath(File parent, File file) {
        String parentPath = parent.getPath();
        String filePath = file.getPath();
        if (!filePath.startsWith(parentPath)) {
            throw new IllegalArgumentException("File " + file + " is not a child of " + parent);
        }
        return filePath.substring(parentPath.length());
    }

    public Zips removeEntry(String entry) {
        this.removedEntries.add(entry);
        return this;
    }

    public Zips removeEntries(String[] entries) {
        this.removedEntries.addAll(Arrays.asList(entries));
        return this;
    }

    public Zips preserveTimestamps() {
        this.preserveTimestamps = true;
        return this;
    }

    public Zips setPreserveTimestamps(boolean preserve) {
        this.preserveTimestamps = true;
        return this;
    }

    public Zips charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public Zips destination(File destination) {
        this.dest = destination;
        return this;
    }

    private boolean isInPlace() {
        return this.dest == null;
    }

    public Zips addTransformer(String path, ZipEntryTransformer transformer) {
        this.transformers.add(new ZipEntryTransformerEntry(path, transformer));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        if (this.src == null && this.dest == null) {
            throw new IllegalArgumentException("Source and destination shouldn't be null together");
        }
        ZipEntryTransformerEntry[] transformersArray = this.getTransformersArray();
        File destinationZip = null;
        try {
            destinationZip = this.isInPlace() ? File.createTempFile("zips", ".zip") : this.dest;
            ZipOutputStream out = this.createZipOutputStream(new BufferedOutputStream(new FileOutputStream(destinationZip)));
            try {
                ZipEntryOrInfoAdapter zipEntryAdapter = new ZipEntryOrInfoAdapter(new CopyingCallback(transformersArray, out), null);
                this.iterateChangedAndAdded(zipEntryAdapter);
                this.iterateExistingExceptRemoved(zipEntryAdapter);
                this.handleInPlaceActions(destinationZip);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
        catch (IOException e) {
            throw ZipUtil.rethrow(e);
        }
        finally {
            if (this.isInPlace()) {
                FileUtils.deleteQuietly((File)destinationZip);
            }
        }
    }

    public void iterate(ZipEntryCallback zipEntryCallback) {
        ZipEntryOrInfoAdapter zipEntryAdapter = new ZipEntryOrInfoAdapter(zipEntryCallback, null);
        this.iterateChangedAndAdded(zipEntryAdapter);
        this.iterateExistingExceptRemoved(zipEntryAdapter);
    }

    public void iterate(ZipInfoCallback action) {
        ZipEntryOrInfoAdapter zipEntryAdapter = new ZipEntryOrInfoAdapter(null, action);
        this.iterateChangedAndAdded(zipEntryAdapter);
        this.iterateExistingExceptRemoved(zipEntryAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void iterateExistingExceptRemoved(ZipEntryOrInfoAdapter zipEntryCallback) {
        if (this.src == null) {
            return;
        }
        Set removedDirs = ZipUtil.filterDirEntries(this.src, this.removedEntries);
        ZipFile zf = null;
        try {
            zf = this.getZipFile();
            Enumeration<? extends ZipEntry> en = zf.entries();
            while (en.hasMoreElements()) {
                ZipEntry e = en.nextElement();
                String entryName = e.getName();
                if (this.removedEntries.contains(entryName) || this.isEntryInDir(removedDirs, entryName)) continue;
                InputStream is = zf.getInputStream(e);
                try {
                    zipEntryCallback.process(is, e);
                }
                catch (ZipBreakException ex) {
                    return;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
            return;
        }
        catch (IOException e) {
            throw ZipUtil.rethrow(e);
        }
        finally {
            ZipUtil.closeQuietly(zf);
        }
    }

    private void iterateChangedAndAdded(ZipEntryOrInfoAdapter zipEntryCallback) {
        Iterator it = this.changedEntries.iterator();
        while (it.hasNext()) {
            ZipEntrySource entrySource = (ZipEntrySource)it.next();
            try {
                zipEntryCallback.process(entrySource.getInputStream(), entrySource.getEntry());
            }
            catch (ZipBreakException ex) {
                break;
            }
            catch (IOException e) {
                throw ZipUtil.rethrow(e);
            }
        }
    }

    private void handleInPlaceActions(File result) throws IOException {
        if (this.isInPlace()) {
            FileUtils.forceDelete((File)this.src);
            FileUtils.moveFile((File)result, (File)this.src);
        }
    }

    private boolean isEntryInDir(Set dirNames, String entryName) {
        Iterator iter = dirNames.iterator();
        while (iter.hasNext()) {
            String dirName = (String)iter.next();
            if (!entryName.startsWith(dirName)) continue;
            return true;
        }
        return false;
    }

    private ZipEntryTransformerEntry[] getTransformersArray() {
        ZipEntryTransformerEntry[] result = new ZipEntryTransformerEntry[this.transformers.size()];
        int idx = 0;
        Iterator iter = this.transformers.iterator();
        while (iter.hasNext()) {
            result[idx++] = (ZipEntryTransformerEntry)iter.next();
        }
        return result;
    }

    private void copyEntry(ZipEntry zipEntry, InputStream in, ZipOutputStream out) throws IOException {
        ZipEntry copy = new ZipEntry(zipEntry.getName());
        copy.setTime(this.preserveTimestamps ? zipEntry.getTime() : System.currentTimeMillis());
        ZipUtil.addEntry(copy, new BufferedInputStream(in), out);
    }

    private ZipFile getZipFile() throws IOException {
        return Zips.getZipFile(this.src, this.charset);
    }

    static ZipFile getZipFile(File src, Charset charset) throws IOException {
        if (charset == null) {
            return new ZipFile(src);
        }
        try {
            Constructor constructor = ZipFile.class.getConstructor(File.class, Charset.class);
            return (ZipFile)constructor.newInstance(src, charset);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Using constructor ZipFile(File, Charset) has failed: " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Using constructor ZipFile(File, Charset) has failed: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Using constructor ZipFile(File, Charset) has failed: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Using constructor ZipFile(File, Charset) has failed: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Using constructor ZipFile(File, Charset) has failed: " + e.getMessage());
        }
    }

    private ZipOutputStream createZipOutputStream(BufferedOutputStream outStream) {
        if (this.charset == null) {
            return new ZipOutputStream(outStream);
        }
        try {
            Constructor constructor = ZipOutputStream.class.getConstructor(OutputStream.class, Charset.class);
            return (ZipOutputStream)constructor.newInstance(outStream, this.charset);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Using constructor ZipOutputStream(OutputStream, Charset) has failed: " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Using constructor ZipOutputStream(OutputStream, Charset) has failed: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Using constructor ZipOutputStream(OutputStream, Charset) has failed: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Using constructor ZipOutputStream(OutputStream, Charset) has failed: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Using constructor ZipOutputStream(OutputStream, Charset) has failed: " + e.getMessage());
        }
    }

    private class ZipEntryOrInfoAdapter
    implements ZipEntryCallback,
    ZipInfoCallback {
        private final ZipEntryCallback entryCallback;
        private final ZipInfoCallback infoCallback;

        public ZipEntryOrInfoAdapter(ZipEntryCallback entryCallback, ZipInfoCallback infoCallback) {
            if (entryCallback != null && infoCallback != null || entryCallback == null && infoCallback == null) {
                throw new IllegalArgumentException("Only one of ZipEntryCallback and ZipInfoCallback must be specified together");
            }
            this.entryCallback = entryCallback;
            this.infoCallback = infoCallback;
        }

        public void process(ZipEntry zipEntry) throws IOException {
            this.infoCallback.process(zipEntry);
        }

        public void process(InputStream in, ZipEntry zipEntry) throws IOException {
            if (this.entryCallback != null) {
                this.entryCallback.process(in, zipEntry);
            } else {
                this.process(zipEntry);
            }
        }
    }

    private final class CopyingCallback
    implements ZipEntryCallback {
        private final Map entryByPath;
        private final ZipOutputStream out;
        private final Set visitedNames;

        private CopyingCallback(ZipEntryTransformerEntry[] entries, ZipOutputStream out) {
            this.out = out;
            this.entryByPath = ZipUtil.byPath(entries);
            this.visitedNames = new HashSet();
        }

        public void process(InputStream in, ZipEntry zipEntry) throws IOException {
            String entryName = zipEntry.getName();
            if (this.visitedNames.contains(entryName)) {
                return;
            }
            this.visitedNames.add(entryName);
            ZipEntryTransformer transformer = (ZipEntryTransformer)this.entryByPath.remove(entryName);
            if (transformer == null) {
                Zips.this.copyEntry(zipEntry, in, this.out);
            } else {
                transformer.transform(in, zipEntry, this.out);
            }
        }
    }
}

