/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.project13.maven.git.CommitIdGenerationMode;
import pl.project13.maven.git.GitCommitIdExecutionException;
import pl.project13.maven.git.GitDataProvider;
import pl.project13.maven.git.GitDescribeConfig;
import pl.project13.maven.git.GitDirLocator;
import pl.project13.maven.git.JGitProvider;
import pl.project13.maven.git.NativeGitProvider;
import pl.project13.maven.git.PropertiesFilterer;
import pl.project13.maven.git.PropertiesReplacer;
import pl.project13.maven.git.ReplacementProperty;
import pl.project13.maven.git.log.LoggerBridge;
import pl.project13.maven.git.log.MavenLoggerBridge;
import pl.project13.maven.git.util.PropertyManager;
import pl.project13.maven.git.util.SortedProperties;

@org.apache.maven.plugins.annotations.Mojo(name="revision", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true)
public class GitCommitIdMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", readonly=true)
    private List<MavenProject> reactorProjects;
    @Parameter(property="session", required=true, readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="false")
    private boolean injectAllReactorProjects;
    @Parameter(defaultValue="false")
    private boolean verbose;
    @Parameter(defaultValue="true")
    private boolean skipPoms;
    @Parameter(defaultValue="false")
    private boolean generateGitPropertiesFile;
    @Parameter(defaultValue="${project.build.outputDirectory}/git.properties")
    private String generateGitPropertiesFilename;
    @Parameter(defaultValue="${project.basedir}/.git")
    private File dotGitDirectory;
    @Parameter
    private GitDescribeConfig gitDescribe;
    @Parameter(defaultValue="7")
    private int abbrevLength;
    @Parameter(defaultValue="properties")
    private String format;
    @Parameter(defaultValue="git")
    private String prefix;
    private String prefixDot = "";
    @Parameter(defaultValue="yyyy-MM-dd'T'HH:mm:ssZ")
    private String dateFormat;
    @Parameter
    private String dateFormatTimeZone;
    @Parameter(defaultValue="true")
    private boolean failOnNoGitDirectory;
    @Parameter(defaultValue="true")
    private boolean failOnUnableToExtractRepoInfo;
    @Parameter(defaultValue="false")
    private boolean useNativeGit;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter(property="maven.gitcommitid.skip", defaultValue="false")
    private boolean skipViaCommandLine;
    @Parameter(defaultValue="false")
    private boolean runOnlyOnce;
    @Parameter
    private List<String> excludeProperties;
    @Parameter
    private List<String> includeOnlyProperties;
    @Parameter(defaultValue="flat")
    private String commitIdGenerationMode;
    private CommitIdGenerationMode commitIdGenerationModeEnum;
    @Parameter
    @VisibleForTesting
    List<ReplacementProperty> replacementProperties;
    @Parameter(defaultValue="HEAD")
    private String evaluateOnCommit;
    protected static final Pattern allowedCharactersForEvaluateOnCommit = Pattern.compile("[a-zA-Z0-9\\_\\-\\^\\/\\.]+");
    private Properties properties;
    private Charset sourceCharset = StandardCharsets.UTF_8;
    @NotNull
    private final LoggerBridge log = new MavenLoggerBridge((Mojo)this, false);
    @NotNull
    private PropertiesFilterer propertiesFilterer = new PropertiesFilterer(this.log);
    @NotNull
    @VisibleForTesting
    PropertiesReplacer propertiesReplacer = new PropertiesReplacer(this.log);

    public void execute() throws MojoExecutionException {
        try {
            this.log.setVerbose(this.verbose);
            String sourceEncoding = this.project.getProperties().getProperty("project.build.sourceEncoding");
            this.sourceCharset = null != sourceEncoding ? Charset.forName(sourceEncoding) : Charset.defaultCharset();
            if (this.skip || this.skipViaCommandLine) {
                this.log.info("skip is enabled, skipping execution!");
                return;
            }
            if (this.runOnlyOnce && !this.session.getExecutionRootDirectory().equals(this.session.getCurrentProject().getBasedir().getAbsolutePath())) {
                this.log.info("runOnlyOnce is enabled and this project is not the top level project, skipping execution!");
                return;
            }
            if (this.isPomProject(this.project) && this.skipPoms) {
                this.log.info("isPomProject is true and skipPoms is true, return");
                return;
            }
            this.dotGitDirectory = this.lookupGitDirectory();
            if (this.failOnNoGitDirectory && !this.directoryExists(this.dotGitDirectory)) {
                throw new GitCommitIdExecutionException(".git directory is not found! Please specify a valid [dotGitDirectory] in your pom.xml");
            }
            if (this.gitDescribe == null) {
                this.gitDescribe = new GitDescribeConfig();
            }
            if (this.dotGitDirectory == null) {
                this.log.info("dotGitDirectory is null, aborting execution!");
                return;
            }
            this.log.info("dotGitDirectory {}", (Object)this.dotGitDirectory.getAbsolutePath());
            if (this.evaluateOnCommit == null || !allowedCharactersForEvaluateOnCommit.matcher(this.evaluateOnCommit).matches()) {
                this.log.error("suspicious argument for evaluateOnCommit, aborting execution!");
                return;
            }
            try {
                try {
                    this.commitIdGenerationModeEnum = CommitIdGenerationMode.valueOf(this.commitIdGenerationMode.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    this.log.warn("Detected wrong setting for 'commitIdGenerationMode'. Falling back to default 'flat' mode!");
                    this.commitIdGenerationModeEnum = CommitIdGenerationMode.FLAT;
                }
                this.properties = new Properties();
                String trimmedPrefix = this.prefix.trim();
                this.prefixDot = trimmedPrefix.equals("") ? "" : trimmedPrefix + ".";
                this.loadGitData(this.properties);
                this.loadBuildVersionAndTimeData(this.properties);
                this.loadBuildHostData(this.properties);
                this.loadShortDescribe(this.properties);
                this.propertiesReplacer.performReplacement(this.properties, this.replacementProperties);
                this.propertiesFilterer.filter(this.properties, this.includeOnlyProperties, this.prefixDot);
                this.propertiesFilterer.filterNot(this.properties, this.excludeProperties, this.prefixDot);
                this.logProperties();
                if (this.generateGitPropertiesFile) {
                    this.maybeGeneratePropertiesFile(this.properties, this.project.getBasedir(), this.generateGitPropertiesFilename);
                }
                this.publishPropertiesInto(this.project);
                if (this.injectAllReactorProjects) {
                    this.appendPropertiesToReactorProjects();
                }
            }
            catch (Exception e) {
                this.handlePluginFailure(e);
            }
        }
        catch (GitCommitIdExecutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void publishPropertiesInto(MavenProject target) {
        target.getProperties().putAll((Map<?, ?>)this.properties);
    }

    private void handlePluginFailure(Exception e) throws GitCommitIdExecutionException {
        if (this.failOnUnableToExtractRepoInfo) {
            throw new GitCommitIdExecutionException("Could not complete Mojo execution...", e);
        }
        this.log.error(e.getMessage(), e);
    }

    private void appendPropertiesToReactorProjects() {
        for (MavenProject mavenProject : this.reactorProjects) {
            this.log.info("{}] project {}", (Object)mavenProject.getName(), (Object)mavenProject.getName());
            this.publishPropertiesInto(mavenProject);
        }
    }

    @VisibleForTesting
    File lookupGitDirectory() throws GitCommitIdExecutionException {
        return new GitDirLocator(this.project, this.reactorProjects).lookupGitDirectory(this.dotGitDirectory);
    }

    private void logProperties() {
        for (Object key : this.properties.keySet()) {
            String keyString = key.toString();
            this.log.info("found property {}", (Object)keyString);
        }
    }

    void loadBuildVersionAndTimeData(@NotNull Properties properties) {
        Date buildDate = new Date();
        SimpleDateFormat smf = new SimpleDateFormat(this.dateFormat);
        if (this.dateFormatTimeZone != null) {
            smf.setTimeZone(TimeZone.getTimeZone(this.dateFormatTimeZone));
        }
        this.put(properties, "build.time", smf.format(buildDate));
        this.put(properties, "build.version", this.project.getVersion());
    }

    void loadBuildHostData(@NotNull Properties properties) {
        String buildHost = null;
        try {
            buildHost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.log.info("Unable to get build host, skipping property {}. Error message: {}", (Object)"build.host", (Object)e.getMessage());
        }
        this.put(properties, "build.host", buildHost);
    }

    void loadShortDescribe(@NotNull Properties properties) {
        String commitDescribe = properties.getProperty(this.prefixDot + "commit.id.describe");
        if (commitDescribe != null) {
            int startPos = commitDescribe.indexOf("-g");
            if (startPos > 0) {
                int endPos = commitDescribe.indexOf(45, startPos + 1);
                String commitShortDescribe = endPos < 0 ? commitDescribe.substring(0, startPos) : commitDescribe.substring(0, startPos) + commitDescribe.substring(endPos);
                this.put(properties, "commit.id.describe-short", commitShortDescribe);
            } else {
                this.put(properties, "commit.id.describe-short", commitDescribe);
            }
        }
    }

    void loadGitData(@NotNull Properties properties) throws GitCommitIdExecutionException {
        if (this.useNativeGit) {
            this.loadGitDataWithNativeGit(properties);
        } else {
            this.loadGitDataWithJGit(properties);
        }
    }

    void loadGitDataWithNativeGit(@NotNull Properties properties) throws GitCommitIdExecutionException {
        try {
            File basedir = this.project.getBasedir().getCanonicalFile();
            GitDataProvider nativeGitProvider = NativeGitProvider.on(basedir, this.log).setPrefixDot(this.prefixDot).setAbbrevLength(this.abbrevLength).setDateFormat(this.dateFormat).setDateFormatTimeZone(this.dateFormatTimeZone).setGitDescribe(this.gitDescribe).setCommitIdGenerationMode(this.commitIdGenerationModeEnum);
            nativeGitProvider.loadGitData(this.evaluateOnCommit, properties);
        }
        catch (IOException e) {
            throw new GitCommitIdExecutionException(e);
        }
    }

    void loadGitDataWithJGit(@NotNull Properties properties) throws GitCommitIdExecutionException {
        GitDataProvider jGitProvider = JGitProvider.on(this.dotGitDirectory, this.log).setPrefixDot(this.prefixDot).setAbbrevLength(this.abbrevLength).setDateFormat(this.dateFormat).setDateFormatTimeZone(this.dateFormatTimeZone).setGitDescribe(this.gitDescribe).setCommitIdGenerationMode(this.commitIdGenerationModeEnum);
        jGitProvider.loadGitData(this.evaluateOnCommit, properties);
    }

    void maybeGeneratePropertiesFile(@NotNull Properties localProperties, File base, String propertiesFilename) throws GitCommitIdExecutionException {
        block17: {
            try {
                File gitPropsFile = this.craftPropertiesOutputFile(base, propertiesFilename);
                boolean isJsonFormat = "json".equalsIgnoreCase(this.format);
                boolean shouldGenerate = true;
                if (gitPropsFile.exists()) {
                    try {
                        Properties persistedProperties;
                        if (isJsonFormat) {
                            this.log.info("Reading existing json file [{}] (for module {})...", (Object)gitPropsFile.getAbsolutePath(), (Object)this.project.getName());
                            persistedProperties = this.readJsonProperties(gitPropsFile);
                        } else {
                            this.log.info("Reading existing properties file [{}] (for module {})...", (Object)gitPropsFile.getAbsolutePath(), (Object)this.project.getName());
                            persistedProperties = this.readProperties(gitPropsFile);
                        }
                        Properties propertiesCopy = (Properties)localProperties.clone();
                        String buildTimeProperty = this.prefixDot + "build.time";
                        propertiesCopy.remove(buildTimeProperty);
                        persistedProperties.remove(buildTimeProperty);
                        shouldGenerate = !propertiesCopy.equals(persistedProperties);
                    }
                    catch (CannotReadFileException ex) {
                        this.log.info("Cannot read properties file [{}] (for module {})...", (Object)gitPropsFile.getAbsolutePath(), (Object)this.project.getName());
                        shouldGenerate = true;
                    }
                }
                if (shouldGenerate) {
                    boolean threw;
                    OutputStreamWriter outputWriter;
                    block16: {
                        Files.createParentDirs((File)gitPropsFile);
                        outputWriter = null;
                        FileOutputStream outputStream = null;
                        threw = true;
                        try {
                            outputStream = new FileOutputStream(gitPropsFile);
                            SortedProperties sortedLocalProperties = new SortedProperties();
                            sortedLocalProperties.putAll((Map<?, ?>)localProperties);
                            if (isJsonFormat) {
                                outputWriter = new OutputStreamWriter((OutputStream)outputStream, this.sourceCharset);
                                this.log.info("Writing json file to [{}] (for module {})...", (Object)gitPropsFile.getAbsolutePath(), (Object)this.project.getName());
                                ObjectMapper mapper = new ObjectMapper();
                                mapper.writerWithDefaultPrettyPrinter().writeValue((Writer)outputWriter, (Object)sortedLocalProperties);
                            } else {
                                this.log.info("Writing properties file to [{}] (for module {})...", (Object)gitPropsFile.getAbsolutePath(), (Object)this.project.getName());
                                sortedLocalProperties.store(outputStream, "Generated by Git-Commit-Id-Plugin");
                            }
                            threw = false;
                            if (outputWriter != null) break block16;
                        }
                        catch (IOException ex) {
                            try {
                                throw new RuntimeException("Cannot create custom git properties file: " + gitPropsFile, ex);
                            }
                            catch (Throwable throwable) {
                                if (outputWriter == null) {
                                    Closeables.close((Closeable)outputStream, (boolean)threw);
                                } else {
                                    Closeables.close(outputWriter, (boolean)threw);
                                }
                                throw throwable;
                            }
                        }
                        Closeables.close((Closeable)outputStream, (boolean)threw);
                        break block17;
                    }
                    Closeables.close((Closeable)outputWriter, (boolean)threw);
                    break block17;
                }
                this.log.info("Properties file [{}] is up-to-date (for module {})...", (Object)gitPropsFile.getAbsolutePath(), (Object)this.project.getName());
            }
            catch (IOException e) {
                throw new GitCommitIdExecutionException(e);
            }
        }
    }

    @VisibleForTesting
    File craftPropertiesOutputFile(File base, String propertiesFilename) {
        File returnPath = new File(base, propertiesFilename);
        File currentPropertiesFilepath = new File(propertiesFilename);
        if (currentPropertiesFilepath.isAbsolute()) {
            returnPath = currentPropertiesFilepath;
        }
        return returnPath;
    }

    boolean isPomProject(@NotNull MavenProject project) {
        return project.getPackaging().equalsIgnoreCase("pom");
    }

    private void put(@NotNull Properties properties, String key, String value) {
        String keyWithPrefix = this.prefixDot + key;
        this.log.info(keyWithPrefix + " " + value);
        PropertyManager.putWithoutPrefix(properties, keyWithPrefix, value);
    }

    private boolean directoryExists(@Nullable File fileLocation) {
        return fileLocation != null && fileLocation.exists() && fileLocation.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readJsonProperties(@NotNull File jsonFile) throws CannotReadFileException {
        HashMap propertiesMap;
        Closeable closeable = null;
        try {
            boolean threw = true;
            try {
                FileInputStream fis;
                closeable = fis = new FileInputStream(jsonFile);
                InputStreamReader reader = new InputStreamReader((InputStream)fis, this.sourceCharset);
                closeable = reader;
                ObjectMapper mapper = new ObjectMapper();
                TypeReference<HashMap<String, Object>> mapTypeRef = new TypeReference<HashMap<String, Object>>(){};
                propertiesMap = (HashMap)mapper.readValue((Reader)reader, (TypeReference)mapTypeRef);
                threw = false;
            }
            catch (Throwable throwable) {
                Closeables.close(closeable, (boolean)threw);
                throw throwable;
            }
            Closeables.close((Closeable)closeable, (boolean)threw);
        }
        catch (Exception ex) {
            throw new CannotReadFileException(ex);
        }
        Properties retVal = new Properties();
        for (Map.Entry entry : propertiesMap.entrySet()) {
            retVal.setProperty((String)entry.getKey(), String.valueOf(entry.getValue()));
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readProperties(@NotNull File propertiesFile) throws CannotReadFileException {
        Properties properties;
        Closeable closeable = null;
        boolean threw = true;
        try {
            FileInputStream fis;
            closeable = fis = new FileInputStream(propertiesFile);
            InputStreamReader reader = new InputStreamReader((InputStream)fis, this.sourceCharset);
            closeable = reader;
            Properties retVal = new Properties();
            retVal.load(reader);
            threw = false;
            properties = retVal;
        }
        catch (Throwable throwable) {
            try {
                Closeables.close(closeable, (boolean)threw);
                throw throwable;
            }
            catch (Exception ex) {
                throw new CannotReadFileException(ex);
            }
        }
        Closeables.close((Closeable)closeable, (boolean)threw);
        return properties;
    }

    @VisibleForTesting
    void setFormat(String format) {
        this.format = format;
    }

    @VisibleForTesting
    void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @VisibleForTesting
    void setProject(MavenProject project) {
        this.project = project;
    }

    @VisibleForTesting
    void setDotGitDirectory(File dotGitDirectory) {
        this.dotGitDirectory = dotGitDirectory;
    }

    @VisibleForTesting
    void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @VisibleForTesting
    void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    @VisibleForTesting
    Properties getProperties() {
        return this.properties;
    }

    @VisibleForTesting
    void setGitDescribe(GitDescribeConfig gitDescribe) {
        this.gitDescribe = gitDescribe;
    }

    @VisibleForTesting
    void setAbbrevLength(int abbrevLength) {
        this.abbrevLength = abbrevLength;
    }

    @VisibleForTesting
    void setExcludeProperties(List<String> excludeProperties) {
        this.excludeProperties = excludeProperties;
    }

    @VisibleForTesting
    void setIncludeOnlyProperties(List<String> includeOnlyProperties) {
        this.includeOnlyProperties = includeOnlyProperties;
    }

    @VisibleForTesting
    void setUseNativeGit(boolean useNativeGit) {
        this.useNativeGit = useNativeGit;
    }

    @VisibleForTesting
    void setCommitIdGenerationMode(String commitIdGenerationMode) {
        this.commitIdGenerationMode = commitIdGenerationMode;
    }

    @VisibleForTesting
    void setSkip(boolean skip) {
        this.skip = skip;
    }

    @VisibleForTesting
    void setSkipPoms(boolean skipPoms) {
        this.skipPoms = skipPoms;
    }

    @VisibleForTesting
    void setGenerateGitPropertiesFile(boolean generateGitPropertiesFile) {
        this.generateGitPropertiesFile = generateGitPropertiesFile;
    }

    @VisibleForTesting
    void setGenerateGitPropertiesFilename(String generateGitPropertiesFilename) {
        this.generateGitPropertiesFilename = generateGitPropertiesFilename;
    }

    @VisibleForTesting
    void setDateFormatTimeZone(String dateFormatTimeZone) {
        this.dateFormatTimeZone = dateFormatTimeZone;
    }

    @VisibleForTesting
    void setFailOnNoGitDirectory(boolean failOnNoGitDirectory) {
        this.failOnNoGitDirectory = failOnNoGitDirectory;
    }

    @VisibleForTesting
    void setFailOnUnableToExtractRepoInfo(boolean failOnUnableToExtractRepoInfo) {
        this.failOnUnableToExtractRepoInfo = failOnUnableToExtractRepoInfo;
    }

    @VisibleForTesting
    String getEvaluateOnCommit() {
        return this.evaluateOnCommit;
    }

    @VisibleForTesting
    void setEvaluateOnCommit(String evaluateOnCommit) {
        this.evaluateOnCommit = evaluateOnCommit;
    }

    static class CannotReadFileException
    extends Exception {
        private static final long serialVersionUID = -6290782570018307756L;

        CannotReadFileException(Throwable cause) {
            super(cause);
        }
    }
}

