/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.api;

import it.unimi.dsi.fastutil.ints.IntComparator;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.function.DoublePredicate;
import tech.tablesaw.api.ColumnType;
import tech.tablesaw.api.NumericColumn;
import tech.tablesaw.columns.AbstractColumn;
import tech.tablesaw.columns.AbstractColumnParser;
import tech.tablesaw.columns.numbers.DoubleColumnType;
import tech.tablesaw.columns.numbers.NumberColumnFormatter;

public abstract class NumberColumn<C extends NumberColumn<C, T>, T extends Number>
extends AbstractColumn<C, T>
implements NumericColumn<T> {
    private NumberColumnFormatter printFormatter = new NumberColumnFormatter();
    protected Locale locale;
    protected final IntComparator comparator = (r1, r2) -> {
        double f1 = this.getDouble(r1);
        double f2 = this.getDouble(r2);
        return Double.compare(f1, f2);
    };

    protected NumberColumn(ColumnType type, String name, AbstractColumnParser<T> parser) {
        super(type, name, parser);
    }

    protected abstract C createCol(String var1, int var2);

    protected abstract C createCol(String var1);

    public NumberColumn<C, T> set(DoublePredicate condition, NumberColumn<C, T> other) {
        for (int row = 0; row < this.size(); ++row) {
            if (!condition.test(this.getDouble(row))) continue;
            this.set(row, (Number)other.get(row));
        }
        return this;
    }

    public NumberColumn<C, T> set(DoublePredicate condition, T newValue) {
        for (int row = 0; row < this.size(); ++row) {
            if (!condition.test(this.getDouble(row))) continue;
            this.set(row, newValue);
        }
        return this;
    }

    @Override
    public void setPrintFormatter(NumberFormat format, String missingValueString) {
        this.printFormatter = new NumberColumnFormatter(format, missingValueString);
    }

    @Override
    public void setPrintFormatter(NumberColumnFormatter formatter) {
        this.printFormatter = formatter;
    }

    protected NumberColumnFormatter getPrintFormatter() {
        return this.printFormatter;
    }

    public abstract NumericColumn<T> top(int var1);

    public abstract NumericColumn<T> bottom(int var1);

    @Override
    public String getString(int row) {
        double value = this.getDouble(row);
        if (DoubleColumnType.valueIsMissing(value)) {
            return "";
        }
        return String.valueOf(this.printFormatter.format(value));
    }

    public C emptyCopy() {
        C column = this.createCol(this.name());
        ((NumberColumn)column).setPrintFormatter(this.printFormatter);
        ((NumberColumn)column).locale = this.locale;
        return column;
    }

    public C emptyCopy(int rowSize) {
        C column = this.createCol(this.name(), rowSize);
        ((NumberColumn)column).setPrintFormatter(this.printFormatter);
        ((NumberColumn)column).locale = this.locale;
        return column;
    }

    public abstract C copy();

    @Override
    public IntComparator rowComparator() {
        return this.comparator;
    }

    @Override
    public int byteSize() {
        return this.type().byteSize();
    }

    @Override
    public abstract byte[] asBytes(int var1);

    public abstract C appendMissing();

    @Override
    public int countMissing() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (!this.isMissing(i)) continue;
            ++count;
        }
        return count;
    }
}

