/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.columns.datetimes;

import com.google.common.base.Strings;
import com.google.common.primitives.Ints;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.chrono.IsoChronology;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.Locale;
import tech.tablesaw.columns.dates.PackedLocalDate;
import tech.tablesaw.columns.datetimes.DateTimeColumnType;
import tech.tablesaw.columns.instant.PackedInstant;
import tech.tablesaw.columns.times.PackedLocalTime;

public class PackedLocalDateTime
extends PackedInstant {
    private PackedLocalDateTime() {
    }

    public static byte getDayOfMonth(long date) {
        return (byte)PackedLocalDateTime.date(date);
    }

    public static short getYear(long dateTime) {
        return PackedLocalDate.getYear(PackedLocalDateTime.date(dateTime));
    }

    public static LocalDateTime asLocalDateTime(long dateTime) {
        if (dateTime == DateTimeColumnType.missingValueIndicator()) {
            return null;
        }
        int date = PackedLocalDateTime.date(dateTime);
        int time = PackedLocalDateTime.time(dateTime);
        LocalDate d = PackedLocalDate.asLocalDate(date);
        LocalTime t = PackedLocalTime.asLocalTime(time);
        if (d == null || t == null) {
            return null;
        }
        return LocalDateTime.of(d, t);
    }

    public static byte getMonthValue(long dateTime) {
        int date = PackedLocalDateTime.date(dateTime);
        return (byte)(date >> 8);
    }

    public static long pack(LocalDate date, LocalTime time) {
        if (date == null || time == null) {
            return DateTimeColumnType.missingValueIndicator();
        }
        int d = PackedLocalDate.pack(date);
        int t = PackedLocalTime.pack(time);
        return (long)d << 32 | (long)t & 0xFFFFFFFFL;
    }

    public static long pack(LocalDateTime dateTime) {
        if (dateTime == null) {
            return DateTimeColumnType.missingValueIndicator();
        }
        LocalDate date = dateTime.toLocalDate();
        LocalTime time = dateTime.toLocalTime();
        return PackedLocalDateTime.pack(date, time);
    }

    public static long pack(short yr, byte m, byte d, byte hr, byte min, byte s, byte n) {
        int date = PackedLocalDate.pack(yr, m, d);
        int time = Ints.fromBytes((byte)hr, (byte)min, (byte)s, (byte)n);
        return (long)date << 32 | (long)time & 0xFFFFFFFFL;
    }

    public static int date(long packedDateTIme) {
        return (int)(packedDateTIme >> 32);
    }

    public static int time(long packedDateTIme) {
        return (int)packedDateTIme;
    }

    public static String toString(long dateTime) {
        if (dateTime == Long.MIN_VALUE) {
            return "";
        }
        int date = PackedLocalDateTime.date(dateTime);
        int time = PackedLocalDateTime.time(dateTime);
        return "" + PackedLocalDate.getYear(date) + "-" + Strings.padStart((String)Byte.toString(PackedLocalDate.getMonthValue(date)), (int)2, (char)'0') + "-" + Strings.padStart((String)Byte.toString(PackedLocalDate.getDayOfMonth(date)), (int)2, (char)'0') + "T" + Strings.padStart((String)Byte.toString(PackedLocalTime.getHour(time)), (int)2, (char)'0') + ":" + Strings.padStart((String)Byte.toString(PackedLocalTime.getMinute(time)), (int)2, (char)'0') + ":" + Strings.padStart((String)Byte.toString(PackedLocalTime.getSecond(time)), (int)2, (char)'0') + "." + Strings.padStart((String)String.valueOf(PackedLocalTime.getMilliseconds(time)), (int)3, (char)'0');
    }

    public static int getDayOfYear(long packedDateTime) {
        return PackedLocalDateTime.getMonth(packedDateTime).firstDayOfYear(PackedLocalDateTime.isLeapYear(packedDateTime)) + PackedLocalDateTime.getDayOfMonth(packedDateTime) - 1;
    }

    public static int getWeekOfYear(long packedDateTime) {
        LocalDateTime date = PackedLocalDateTime.asLocalDateTime(packedDateTime);
        if (date == null) {
            throw new IllegalArgumentException("Cannot get week of year for missing value");
        }
        TemporalField woy = WeekFields.of(Locale.getDefault()).weekOfWeekBasedYear();
        return date.get(woy);
    }

    public static boolean isLeapYear(long packedDateTime) {
        if (packedDateTime == DateTimeColumnType.missingValueIndicator()) {
            return false;
        }
        return IsoChronology.INSTANCE.isLeapYear(PackedLocalDateTime.getYear(packedDateTime));
    }

    public static Month getMonth(long packedDateTime) {
        return Month.of(PackedLocalDateTime.getMonthValue(packedDateTime));
    }

    public static int lengthOfMonth(long packedDateTime) {
        switch (PackedLocalDateTime.getMonthValue(packedDateTime)) {
            case 2: {
                return PackedLocalDateTime.isLeapYear(packedDateTime) ? 29 : 28;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
        }
        return 31;
    }

    public static DayOfWeek getDayOfWeek(long packedDateTime) {
        int date = PackedLocalDateTime.date(packedDateTime);
        return PackedLocalDate.getDayOfWeek(date);
    }

    public static int getQuarter(long packedDate) {
        if (packedDate == DateTimeColumnType.missingValueIndicator()) {
            return -1;
        }
        return PackedLocalDate.getQuarter(PackedLocalDateTime.date(packedDate));
    }

    public static boolean isInQ1(long packedDateTime) {
        if (packedDateTime == DateTimeColumnType.missingValueIndicator()) {
            return false;
        }
        Month month = PackedLocalDateTime.getMonth(packedDateTime);
        return month == Month.JANUARY || month == Month.FEBRUARY || month == Month.MARCH;
    }

    public static boolean isInQ2(long packedDateTime) {
        if (packedDateTime == DateTimeColumnType.missingValueIndicator()) {
            return false;
        }
        Month month = PackedLocalDateTime.getMonth(packedDateTime);
        return month == Month.APRIL || month == Month.MAY || month == Month.JUNE;
    }

    public static boolean isInQ3(long packedDateTime) {
        if (packedDateTime == DateTimeColumnType.missingValueIndicator()) {
            return false;
        }
        Month month = PackedLocalDateTime.getMonth(packedDateTime);
        return month == Month.JULY || month == Month.AUGUST || month == Month.SEPTEMBER;
    }

    public static boolean isInQ4(long packedDateTime) {
        if (packedDateTime == DateTimeColumnType.missingValueIndicator()) {
            return false;
        }
        Month month = PackedLocalDateTime.getMonth(packedDateTime);
        return month == Month.OCTOBER || month == Month.NOVEMBER || month == Month.DECEMBER;
    }

    public static boolean isAfter(long packedDateTime, long value) {
        return packedDateTime != DateTimeColumnType.missingValueIndicator() && packedDateTime > value;
    }

    public static boolean isBefore(long packedDateTime, long value) {
        return packedDateTime != DateTimeColumnType.missingValueIndicator() && packedDateTime < value;
    }

    public static boolean isSunday(long packedDateTime) {
        if (packedDateTime == DateTimeColumnType.missingValueIndicator()) {
            return false;
        }
        DayOfWeek dayOfWeek = PackedLocalDateTime.getDayOfWeek(packedDateTime);
        return dayOfWeek == DayOfWeek.SUNDAY;
    }

    public static boolean isMonday(long packedDateTime) {
        if (packedDateTime == DateTimeColumnType.missingValueIndicator()) {
            return false;
        }
        DayOfWeek dayOfWeek = PackedLocalDateTime.getDayOfWeek(packedDateTime);
        return dayOfWeek == DayOfWeek.MONDAY;
    }

    public static boolean isTuesday(long packedDateTime) {
        if (packedDateTime == DateTimeColumnType.missingValueIndicator()) {
            return false;
        }
        DayOfWeek dayOfWeek = PackedLocalDateTime.getDayOfWeek(packedDateTime);
        return dayOfWeek == DayOfWeek.TUESDAY;
    }

    public static boolean isWednesday(long packedDateTime) {
        if (packedDateTime == DateTimeColumnType.missingValueIndicator()) {
            return false;
        }
        DayOfWeek dayOfWeek = PackedLocalDateTime.getDayOfWeek(packedDateTime);
        return dayOfWeek == DayOfWeek.WEDNESDAY;
    }

    public static boolean isThursday(long packedDateTime) {
        if (packedDateTime == DateTimeColumnType.missingValueIndicator()) {
            return false;
        }
        DayOfWeek dayOfWeek = PackedLocalDateTime.getDayOfWeek(packedDateTime);
        return dayOfWeek == DayOfWeek.THURSDAY;
    }

    public static boolean isFriday(long packedDateTime) {
        if (packedDateTime == DateTimeColumnType.missingValueIndicator()) {
            return false;
        }
        DayOfWeek dayOfWeek = PackedLocalDateTime.getDayOfWeek(packedDateTime);
        return dayOfWeek == DayOfWeek.FRIDAY;
    }

    public static boolean isSaturday(long packedDateTime) {
        if (packedDateTime == DateTimeColumnType.missingValueIndicator()) {
            return false;
        }
        DayOfWeek dayOfWeek = PackedLocalDateTime.getDayOfWeek(packedDateTime);
        return dayOfWeek == DayOfWeek.SATURDAY;
    }

    public static boolean isFirstDayOfMonth(long packedDateTime) {
        return packedDateTime != DateTimeColumnType.missingValueIndicator() && PackedLocalDateTime.getDayOfMonth(packedDateTime) == 1;
    }

    public static boolean isInJanuary(long packedDateTime) {
        return packedDateTime != DateTimeColumnType.missingValueIndicator() && PackedLocalDateTime.getMonth(packedDateTime) == Month.JANUARY;
    }

    public static boolean isInFebruary(long packedDateTime) {
        return packedDateTime != DateTimeColumnType.missingValueIndicator() && PackedLocalDateTime.getMonth(packedDateTime) == Month.FEBRUARY;
    }

    public static boolean isInMarch(long packedDateTime) {
        return packedDateTime != DateTimeColumnType.missingValueIndicator() && PackedLocalDateTime.getMonth(packedDateTime) == Month.MARCH;
    }

    public static boolean isInApril(long packedDateTime) {
        return packedDateTime != DateTimeColumnType.missingValueIndicator() && PackedLocalDateTime.getMonth(packedDateTime) == Month.APRIL;
    }

    public static boolean isInMay(long packedDateTime) {
        return packedDateTime != DateTimeColumnType.missingValueIndicator() && PackedLocalDateTime.getMonth(packedDateTime) == Month.MAY;
    }

    public static boolean isInJune(long packedDateTime) {
        return packedDateTime != DateTimeColumnType.missingValueIndicator() && PackedLocalDateTime.getMonth(packedDateTime) == Month.JUNE;
    }

    public static boolean isInJuly(long packedDateTime) {
        return packedDateTime != DateTimeColumnType.missingValueIndicator() && PackedLocalDateTime.getMonth(packedDateTime) == Month.JULY;
    }

    public static boolean isInAugust(long packedDateTime) {
        return packedDateTime != DateTimeColumnType.missingValueIndicator() && PackedLocalDateTime.getMonth(packedDateTime) == Month.AUGUST;
    }

    public static boolean isInSeptember(long packedDateTime) {
        return packedDateTime != DateTimeColumnType.missingValueIndicator() && PackedLocalDateTime.getMonth(packedDateTime) == Month.SEPTEMBER;
    }

    public static boolean isInOctober(long packedDateTime) {
        return packedDateTime != DateTimeColumnType.missingValueIndicator() && PackedLocalDateTime.getMonth(packedDateTime) == Month.OCTOBER;
    }

    public static boolean isInNovember(long packedDateTime) {
        return packedDateTime != DateTimeColumnType.missingValueIndicator() && PackedLocalDateTime.getMonth(packedDateTime) == Month.NOVEMBER;
    }

    public static boolean isInDecember(long packedDateTime) {
        return packedDateTime != DateTimeColumnType.missingValueIndicator() && PackedLocalDateTime.getMonth(packedDateTime) == Month.DECEMBER;
    }

    public static boolean isLastDayOfMonth(long packedDateTime) {
        return packedDateTime != DateTimeColumnType.missingValueIndicator() && PackedLocalDateTime.getDayOfMonth(packedDateTime) == PackedLocalDateTime.lengthOfMonth(packedDateTime);
    }

    public static boolean isInYear(long packedDateTime, int year) {
        return packedDateTime != DateTimeColumnType.missingValueIndicator() && PackedLocalDateTime.getYear(packedDateTime) == year;
    }

    public static boolean isMidnight(long packedDateTime) {
        return packedDateTime != DateTimeColumnType.missingValueIndicator() && PackedLocalTime.isMidnight(PackedLocalDateTime.time(packedDateTime));
    }

    public static boolean isNoon(long packedDateTime) {
        return packedDateTime != DateTimeColumnType.missingValueIndicator() && PackedLocalTime.isNoon(PackedLocalDateTime.time(packedDateTime));
    }

    public static boolean AM(long packedDateTime) {
        return packedDateTime != DateTimeColumnType.missingValueIndicator() && PackedLocalTime.AM(PackedLocalDateTime.time(packedDateTime));
    }

    public static boolean PM(long packedDateTime) {
        return packedDateTime != DateTimeColumnType.missingValueIndicator() && PackedLocalTime.PM(PackedLocalDateTime.time(packedDateTime));
    }

    public static int getMinuteOfDay(long packedLocalDateTime) {
        return PackedLocalDateTime.getHour(packedLocalDateTime) * 60 + PackedLocalDateTime.getMinute(packedLocalDateTime);
    }

    public static byte getSecond(int packedLocalDateTime) {
        return (byte)(PackedLocalDateTime.getMillisecondOfMinute(packedLocalDateTime) / 1000);
    }

    public static byte getHour(long packedLocalDateTime) {
        return PackedLocalTime.getHour(PackedLocalDateTime.time(packedLocalDateTime));
    }

    public static byte getMinute(long packedLocalDateTime) {
        return PackedLocalTime.getMinute(PackedLocalDateTime.time(packedLocalDateTime));
    }

    public static byte getSecond(long packedLocalDateTime) {
        return PackedLocalTime.getSecond(PackedLocalDateTime.time(packedLocalDateTime));
    }

    public static int getSecondOfDay(long packedLocalDateTime) {
        return PackedLocalTime.getSecondOfDay(PackedLocalDateTime.time(packedLocalDateTime));
    }

    public static short getMillisecondOfMinute(long packedLocalDateTime) {
        return (short)PackedLocalTime.getMillisecondOfMinute(PackedLocalDateTime.time(packedLocalDateTime));
    }

    public static long getMillisecondOfDay(long packedLocalDateTime) {
        LocalDateTime localDateTime = PackedLocalDateTime.asLocalDateTime(packedLocalDateTime);
        if (localDateTime == null) {
            throw new IllegalArgumentException("Cannot get millisecond of day for missing value");
        }
        long total = localDateTime.get(ChronoField.MILLI_OF_SECOND);
        total += (long)(localDateTime.getSecond() * 1000);
        total += (long)(localDateTime.getMinute() * 60 * 1000);
        return total += (long)(localDateTime.getHour() * 60 * 60 * 1000);
    }

    public static int lengthOfYear(long packedDateTime) {
        return PackedLocalDateTime.isLeapYear(packedDateTime) ? 366 : 365;
    }

    public static int monthsUntil(long packedDateTimeEnd, long packedDateStart) {
        int start = PackedLocalDateTime.getMonthInternal(packedDateStart) * 32 + PackedLocalDateTime.getDayOfMonth(packedDateStart);
        int end = PackedLocalDateTime.getMonthInternal(packedDateTimeEnd) * 32 + PackedLocalDateTime.getDayOfMonth(packedDateTimeEnd);
        return (end - start) / 32;
    }

    public static int yearsUntil(long packedDateEnd, long packedDateStart) {
        return PackedLocalDateTime.monthsUntil(packedDateEnd, packedDateStart) / 12;
    }

    private static int getMonthInternal(long packedDateTime) {
        return PackedLocalDateTime.getYear(packedDateTime) * 12 + PackedLocalDateTime.getMonthValue(packedDateTime) - 1;
    }
}

