/*
 * Decompiled with CFR 0.152.
 */
package tech.tablesaw.io;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import tech.tablesaw.api.Table;
import tech.tablesaw.io.DataReader;
import tech.tablesaw.io.ReadOptions;
import tech.tablesaw.io.ReaderRegistry;
import tech.tablesaw.io.Source;
import tech.tablesaw.io.csv.CsvReadOptions;
import tech.tablesaw.io.csv.CsvReader;
import tech.tablesaw.io.jdbc.SqlResultSetReader;

public class DataFrameReader {
    private final ReaderRegistry registry;

    public DataFrameReader(ReaderRegistry registry) {
        this.registry = registry;
    }

    public Table url(String url) throws IOException {
        return this.url(new URL(url));
    }

    public Table url(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        String contentType = connection.getContentType();
        return this.url(url, this.getCharset(contentType), this.getMimeType(contentType));
    }

    private Table url(URL url, Charset charset, String mimeType) throws IOException {
        Optional<DataReader<?>> reader = this.registry.getReaderForMimeType(mimeType);
        if (reader.isPresent()) {
            return this.readUrl(url, charset, reader.get());
        }
        reader = this.registry.getReaderForExtension(this.getExtension(url));
        if (reader.isPresent()) {
            return this.readUrl(url, charset, reader.get());
        }
        throw new IllegalArgumentException("No reader registered for mime-type " + mimeType);
    }

    private Table readUrl(URL url, Charset charset, DataReader<?> reader) throws IOException {
        return reader.read(new Source(url.openConnection().getInputStream(), charset));
    }

    private String getMimeType(String contentType) {
        String[] pair = contentType.split(";");
        return pair[0].trim();
    }

    private Charset getCharset(String contentType) {
        String[] pair = contentType.split(";");
        return pair.length == 1 ? Charset.defaultCharset() : Charset.forName(pair[1].split("=")[1].trim());
    }

    private String getExtension(URL url) {
        return Files.getFileExtension((String)url.getPath());
    }

    public Table string(String s, String fileExtension) {
        Optional<DataReader<?>> reader = this.registry.getReaderForExtension(fileExtension);
        if (!reader.isPresent()) {
            throw new IllegalArgumentException("No reader registered for extension " + fileExtension);
        }
        try {
            return reader.get().read(Source.fromString(s));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Table file(String file) throws IOException {
        return this.file(new File(file));
    }

    public Table file(File file) throws IOException {
        String extension = Files.getFileExtension((String)file.getCanonicalPath());
        Optional<DataReader<?>> reader = this.registry.getReaderForExtension(extension);
        if (reader.isPresent()) {
            return reader.get().read(new Source(file));
        }
        throw new IllegalArgumentException("No reader registered for extension " + extension);
    }

    public <T extends ReadOptions> Table usingOptions(T options) throws IOException {
        DataReader<T> reader = this.registry.getReaderForOptions(options);
        return reader.read(options);
    }

    public Table usingOptions(ReadOptions.Builder builder) throws IOException {
        return this.usingOptions(builder.build());
    }

    public Table db(ResultSet resultSet) throws SQLException {
        return SqlResultSetReader.read(resultSet);
    }

    public Table db(ResultSet resultSet, String tableName) throws SQLException {
        Table table = SqlResultSetReader.read(resultSet);
        table.setName(tableName);
        return table;
    }

    public Table csv(String file) throws IOException {
        return this.csv(CsvReadOptions.builder(file));
    }

    public Table csv(String contents, String tableName) {
        try {
            return this.csv(CsvReadOptions.builder(new StringReader(contents)).tableName(tableName));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public Table csv(File file) throws IOException {
        return this.csv(CsvReadOptions.builder(file));
    }

    public Table csv(InputStream stream) throws IOException {
        return this.csv(CsvReadOptions.builder(stream));
    }

    public Table csv(URL url) throws IOException {
        return this.readUrl(url, this.getCharset(url.openConnection().getContentType()), new CsvReader());
    }

    public Table csv(InputStream stream, String name) throws IOException {
        return this.csv(CsvReadOptions.builder(stream).tableName(name));
    }

    public Table csv(Reader reader) throws IOException {
        return this.csv(CsvReadOptions.builder(reader));
    }

    public Table csv(CsvReadOptions.Builder options) throws IOException {
        return this.csv(options.build());
    }

    public Table csv(CsvReadOptions options) throws IOException {
        return new CsvReader().read(options);
    }
}

