/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.request;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.TaobaoObject;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.AlibabaAscpLogisticsConsignModifyResponse;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlibabaAscpLogisticsConsignModifyRequest
extends BaseTaobaoRequest<AlibabaAscpLogisticsConsignModifyResponse> {
    private String feature;
    private String goods;
    private String newCompanyCode;
    private String newOutSid;
    private String oldCompanyCode;
    private String oldOutSid;
    private String tid;

    public void setFeature(String feature) {
        this.feature = feature;
    }

    public String getFeature() {
        return this.feature;
    }

    public void setGoods(String goods) {
        this.goods = goods;
    }

    public void setGoods(List<TopConsignGoodsRequest> goods) {
        this.goods = new JSONWriter(false, true).write(goods);
    }

    public String getGoods() {
        return this.goods;
    }

    public void setNewCompanyCode(String newCompanyCode) {
        this.newCompanyCode = newCompanyCode;
    }

    public String getNewCompanyCode() {
        return this.newCompanyCode;
    }

    public void setNewOutSid(String newOutSid) {
        this.newOutSid = newOutSid;
    }

    public String getNewOutSid() {
        return this.newOutSid;
    }

    public void setOldCompanyCode(String oldCompanyCode) {
        this.oldCompanyCode = oldCompanyCode;
    }

    public String getOldCompanyCode() {
        return this.oldCompanyCode;
    }

    public void setOldOutSid(String oldOutSid) {
        this.oldOutSid = oldOutSid;
    }

    public String getOldOutSid() {
        return this.oldOutSid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getTid() {
        return this.tid;
    }

    @Override
    public String getApiMethodName() {
        return "alibaba.ascp.logistics.consign.modify";
    }

    @Override
    public Map<String, String> getTextParams() {
        TaobaoHashMap txtParams = new TaobaoHashMap();
        txtParams.put("feature", this.feature);
        txtParams.put("goods", this.goods);
        txtParams.put("new_company_code", this.newCompanyCode);
        txtParams.put("new_out_sid", this.newOutSid);
        txtParams.put("old_company_code", this.oldCompanyCode);
        txtParams.put("old_out_sid", this.oldOutSid);
        txtParams.put("tid", this.tid);
        if (this.udfParams != null) {
            txtParams.putAll(this.udfParams);
        }
        return txtParams;
    }

    @Override
    public Class<AlibabaAscpLogisticsConsignModifyResponse> getResponseClass() {
        return AlibabaAscpLogisticsConsignModifyResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.newOutSid, "newOutSid");
        RequestCheckUtils.checkNotEmpty(this.oldOutSid, "oldOutSid");
        RequestCheckUtils.checkNotEmpty(this.tid, "tid");
    }

    public static class TopConsignGoodsRequest
    extends TaobaoObject {
        private static final long serialVersionUID = 7738839261472779882L;
        @ApiField(value="comp_item_id")
        private String compItemId;
        @ApiField(value="comp_sku_id")
        private String compSkuId;
        @ApiField(value="item_type")
        private Long itemType;
        @ApiField(value="sub_tid")
        private String subTid;

        public String getCompItemId() {
            return this.compItemId;
        }

        public void setCompItemId(String compItemId) {
            this.compItemId = compItemId;
        }

        public String getCompSkuId() {
            return this.compSkuId;
        }

        public void setCompSkuId(String compSkuId) {
            this.compSkuId = compSkuId;
        }

        public Long getItemType() {
            return this.itemType;
        }

        public void setItemType(Long itemType) {
            this.itemType = itemType;
        }

        public String getSubTid() {
            return this.subTid;
        }

        public void setSubTid(String subTid) {
            this.subTid = subTid;
        }
    }
}

