package cc.lechun.balance.dto;

import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description:
 * @Author hans
 * @Date 2019/7/24 10:35
 * @Version 1.0
 */
public class UserBalanceDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /*用户主键*/
    private String customerId;

    /*可用总余额*/
    private BigDecimal usableTotalBalance;

    /*可用储值余额*/
    private BigDecimal usableStoreBalance;

    /*可用赠送余额*/
    private BigDecimal usableFreeBalance;

    /*可用礼品卡余额*/
    private BigDecimal usableGifBalance;

    /*状态 0:删除;1:正常;2:停用*/
    private Integer balanceState;

    /*创建时间*/
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    public String getCustomerId() {
        return customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public BigDecimal getUsableTotalBalance() {
        return usableTotalBalance;
    }

    public void setUsableTotalBalance(BigDecimal usableTotalBalance) {
        this.usableTotalBalance = usableTotalBalance;
    }

    public BigDecimal getUsableStoreBalance() {
        return usableStoreBalance;
    }

    public void setUsableStoreBalance(BigDecimal usableStoreBalance) {
        this.usableStoreBalance = usableStoreBalance;
    }

    public BigDecimal getUsableFreeBalance() {
        return usableFreeBalance;
    }

    public void setUsableFreeBalance(BigDecimal usableFreeBalance) {
        this.usableFreeBalance = usableFreeBalance;
    }

    public BigDecimal getUsableGifBalance() {
        return usableGifBalance;
    }

    public void setUsableGifBalance(BigDecimal usableGifBalance) {
        this.usableGifBalance = usableGifBalance;
    }

    public Integer getBalanceState() {
        return balanceState;
    }

    public void setBalanceState(Integer balanceState) {
        this.balanceState = balanceState;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }
}
