/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.balance.api;

import cc.lechun.balance.api.GiftCardManagerApi;
import cc.lechun.balance.dto.GiftCardBatchDTO;
import cc.lechun.balance.dto.GiftCardDTO;
import cc.lechun.balance.entity.gift.GiftCardBatchEntity;
import cc.lechun.balance.entity.gift.GiftCardEntity;
import cc.lechun.balance.iservice.gift.GiftCardBatchInterface;
import cc.lechun.balance.iservice.gift.GiftCardInterface;
import cc.lechun.balance.tools.RandomUtils;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.vo.BaseJsonVo;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GiftCardBatchApiService
implements GiftCardManagerApi {
    @Autowired
    private GiftCardBatchInterface giftCardBatchInterface;
    @Autowired
    private GiftCardInterface giftCardInterface;

    public BaseJsonVo<List<GiftCardBatchDTO>> findGiftCardBatches(PageForm pageForm, GiftCardBatchDTO giftCardBatchDTO) {
        JSONObject jsonObject = new JSONObject();
        String batchDtoStr = JSONObject.toJSONString((Object)giftCardBatchDTO);
        GiftCardBatchEntity giftCardBatchEntity = (GiftCardBatchEntity)JSONObject.parseObject((String)batchDtoStr, GiftCardBatchEntity.class);
        PageInfo pageInfo = this.giftCardBatchInterface.queryGiftCardBatchInfo(pageForm.getCurrentPage(), pageForm.getPageSize(), giftCardBatchEntity);
        return BaseJsonVo.success((Object)pageInfo);
    }

    public BaseJsonVo<List<GiftCardDTO>> findGiftCards(PageForm pageForm, GiftCardDTO giftCardDTO) {
        JSONObject jsonObject = new JSONObject();
        String cardDtoStr = JSONObject.toJSONString((Object)giftCardDTO);
        GiftCardEntity giftCardEntity = (GiftCardEntity)JSONObject.parseObject((String)cardDtoStr, GiftCardEntity.class);
        PageInfo pageInfo = this.giftCardInterface.queryGiftCardByBatchId(pageForm.getCurrentPage(), pageForm.getPageSize(), giftCardEntity);
        return BaseJsonVo.success((Object)pageInfo);
    }

    public BaseJsonVo<List<GiftCardDTO>> exportGiftCards(String batchId) {
        return null;
    }

    @Transactional
    public BaseJsonVo<GiftCardBatchDTO> generateGiftCardBatch(GiftCardBatchDTO batchDto) {
        JSONObject jsonObject = new JSONObject();
        String batchDtoStr = JSONObject.toJSONString((Object)batchDto);
        GiftCardBatchEntity giftCardBatchEntity = (GiftCardBatchEntity)JSONObject.parseObject((String)batchDtoStr, GiftCardBatchEntity.class);
        String batchNo = RandomUtils.generateNumber((int)12);
        giftCardBatchEntity.setBatchNo(batchNo);
        Date nowDate = DateUtils.now();
        giftCardBatchEntity.setCreateTime(nowDate);
        this.giftCardBatchInterface.savaGiftCardBatchInfo(giftCardBatchEntity);
        ArrayList<GiftCardEntity> giftCardEntityList = new ArrayList<GiftCardEntity>();
        for (int i = 1; i <= giftCardBatchEntity.getBatchNum(); ++i) {
            GiftCardEntity giftCardEntity = new GiftCardEntity();
            giftCardEntity.setCardNo(RandomUtils.generateNumber((int)12));
            giftCardEntity.setCardCash(giftCardBatchEntity.getBatchMoney());
            giftCardEntity.setCardValidity(giftCardBatchEntity.getCardValidity());
            giftCardEntity.setCardStartTime(giftCardBatchEntity.getCardStartTime());
            giftCardEntity.setCardEndTime(giftCardBatchEntity.getCardEndTime());
            giftCardEntity.setCardState(Integer.valueOf(0));
            giftCardEntity.setBatchNo(batchNo);
            giftCardEntity.setCreateBy(batchDto.getCreateBy());
            giftCardEntity.setCreateTime(nowDate);
            giftCardEntityList.add(giftCardEntity);
        }
        this.giftCardInterface.saveGiftCardByBatchId(giftCardEntityList);
        return BaseJsonVo.success((Object)"\u751f\u6210\u6210\u529f");
    }

    @Transactional
    public BaseJsonVo<GiftCardBatchDTO> updateGiftCardBatch(GiftCardBatchDTO batchDto) {
        JSONObject jsonObject = new JSONObject();
        String batchDtoStr = JSONObject.toJSONString((Object)batchDto);
        GiftCardBatchEntity giftCardBatchEntity = (GiftCardBatchEntity)JSONObject.parseObject((String)batchDtoStr, GiftCardBatchEntity.class);
        GiftCardBatchEntity oldGiftCardBatchEntity = (GiftCardBatchEntity)this.giftCardBatchInterface.selectByPrimaryKey((Serializable)((Object)giftCardBatchEntity.getBatchNo()));
        giftCardBatchEntity.setCreateTime(oldGiftCardBatchEntity.getCreateTime());
        giftCardBatchEntity.setCreateBy(oldGiftCardBatchEntity.getCreateBy());
        Date nowDate = DateUtils.now();
        giftCardBatchEntity.setUpdateTime(nowDate);
        giftCardBatchEntity.setUpdateBy(null);
        this.giftCardBatchInterface.updateByPrimaryKey((Object)giftCardBatchEntity);
        List giftCardEntityList = this.giftCardInterface.queryCardInfo(giftCardBatchEntity.getBatchNo());
        return BaseJsonVo.success((Object)"\u751f\u6210\u6210\u529f");
    }

    public BaseJsonVo delGiftCardBatch(String batchId) {
        List giftCardEntityList = this.giftCardInterface.queryCardInfoByBatchNo(batchId, 1);
        if (giftCardEntityList != null && giftCardEntityList.size() > 0) {
            return BaseJsonVo.error((String)"\u5b58\u5728\u5df2\u6fc0\u6d3b\u7684\u5361\u53f7");
        }
        this.giftCardInterface.batchDeleteCardInfoByBatchNo(batchId);
        this.giftCardBatchInterface.deleteCardBatchInfoByBatchNo(batchId);
        return BaseJsonVo.success((Object)"\u5220\u9664\u6210\u529f");
    }

    public BaseJsonVo cancelGiftCardBatch(String batchId) {
        List giftCardEntityList = this.giftCardInterface.queryCardInfoByBatchNoOne(batchId, 1);
        if (giftCardEntityList != null && giftCardEntityList.size() > 0) {
            ArrayList<String> cardNoList = new ArrayList<String>(giftCardEntityList.size());
            for (GiftCardEntity giftCardEntity : giftCardEntityList) {
                cardNoList.add(giftCardEntity.getCardNo());
            }
            this.giftCardInterface.batchCancel(cardNoList.toArray(new String[0]));
        }
        return BaseJsonVo.success((Object)"\u53d6\u6d88\u6210\u529f");
    }

    public BaseJsonVo invalidCard(String cardNo, int cardState) {
        GiftCardEntity giftCardEntity = new GiftCardEntity();
        giftCardEntity.setCardNo(cardNo);
        List giftCardEntityList = this.giftCardInterface.queryGiftCardInfo(giftCardEntity);
        if (giftCardEntityList != null && giftCardEntityList.size() > 0) {
            giftCardEntity = (GiftCardEntity)giftCardEntityList.get(0);
        }
        if (cardState == -1 && giftCardEntity != null && giftCardEntity.getCardState() == 0) {
            giftCardEntity.setCardState(Integer.valueOf(cardState));
            this.giftCardInterface.updateCardState(giftCardEntity);
        }
        if (cardState == 0 && giftCardEntity != null && giftCardEntity.getCardState() == -1) {
            giftCardEntity.setCardState(Integer.valueOf(cardState));
            this.giftCardInterface.updateCardState(giftCardEntity);
        }
        return BaseJsonVo.success((Object)"\u53d6\u6d88\u6210\u529f");
    }
}

