/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.balance.common.aspects;

import cc.lechun.balance.common.annotations.BusinessLog;
import com.netflix.hystrix.contrib.javanica.utils.AopUtils;
import java.lang.reflect.Method;
import org.apache.commons.lang3.Validate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class BusinessLogAspect {
    private Logger logger = LoggerFactory.getLogger(BusinessLogAspect.class);

    @Pointcut(value="@annotation(cc.lechun.balance.common.annotations.BusinessLog)")
    public void businessLogAnnotationPointcut() {
    }

    @Around(value="businessLogAnnotationPointcut()")
    public Object methodsAnnotatedWithBusinessLog(ProceedingJoinPoint joinPoint) throws Throwable {
        Method method = AopUtils.getMethodFromTarget((JoinPoint)joinPoint);
        Validate.notNull((Object)method, (String)"failed to get method from joinPoint: %s", (Object[])new Object[]{joinPoint});
        BusinessLog p = method.getAnnotation(BusinessLog.class);
        Method m = p.getClass().getDeclaredMethod("logInfo", new Class[0]);
        String values = (String)m.invoke((Object)p, new Object[0]);
        String name = joinPoint.getSignature().getName();
        String clazz = joinPoint.getTarget().getClass().toString();
        clazz = clazz.substring(5);
        this.logger.info("\u8017\u65f6\u7edf\u8ba1\uff1a" + clazz + "." + name + "()" + values + " \u5f00\u59cb\u5904\u7406...");
        long startTime = System.currentTimeMillis();
        Object obj = joinPoint.proceed();
        long endTime = System.currentTimeMillis();
        this.logger.info("\u8017\u65f6\u7edf\u8ba1\uff1a" + clazz + "." + name + "()" + values + " -> \u8017\u65f6" + (endTime - startTime) + "ms");
        return obj;
    }
}

