/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.balance.common.aspects;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.netflix.hystrix.contrib.javanica.utils.AopUtils;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class PrintParamAspect {
    private static final Logger log = LoggerFactory.getLogger(PrintParamAspect.class);

    @Around(value="@annotation(cc.lechun.balance.common.annotations.PrintParam)")
    public Object printParam(ProceedingJoinPoint joinPoint) throws Throwable {
        Method methodFromTarget = AopUtils.getMethodFromTarget((JoinPoint)joinPoint);
        String methodName = methodFromTarget.getName();
        Object[] args = joinPoint.getArgs();
        String dateFormat = "yyyy-MM-dd HH:mm:ss";
        log.info("\u65b9\u6cd5\u8c03\u7528\u5f00\u59cb: \u65b9\u6cd5\u540d: {}, \u5165\u53c2: {}", (Object)methodName, (Object)JSONObject.toJSONStringWithDateFormat((Object)args, (String)dateFormat, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        Object result = joinPoint.proceed();
        log.info("\u65b9\u6cd5\u8c03\u7528\u7ed3\u675f: \u65b9\u6cd5\u540d: {}, \u56de\u53c2: {}", (Object)methodName, (Object)JSONObject.toJSONStringWithDateFormat((Object)result, (String)dateFormat, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return result;
    }
}

