/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.wechat.cache;

import cc.lechun.wechat.cache.RedisService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Component
@Primary
public class RedisLock {
    private static final Logger log = LoggerFactory.getLogger(RedisLock.class);
    public static final String WECHAT_ACCESSTOKEN_LOCK = "wechat_accesstoken_lock";
    public static final String MALL_SHOPPING_CART_ENTITY = "mall_shopping_cart_entity";
    public static final String MALL_PRODUCT_ID = "mall_product_id";
    @Autowired
    private RedisService redisService;

    public boolean lock(String key, String value, long timeout, TimeUnit unit) {
        try {
            if (this.redisService.setnx(key, value).booleanValue()) {
                this.redisService.setExpire(key, timeout, unit);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.error("redisLock : [" + key + "]\u52a0\u9501\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public boolean unlock(String key) {
        try {
            this.redisService.delete(key);
            return true;
        }
        catch (Exception e) {
            log.error("redisLock : [" + key + "]\u89e3\u9501\u5f02\u5e38", (Throwable)e);
            return false;
        }
    }

    public boolean tryLock(String key, long timeout) {
        try {
            long nowTime = System.nanoTime();
            do {
                if (this.redisService.setnx(key, key).booleanValue()) {
                    this.redisService.setExpire(key, timeout, TimeUnit.MILLISECONDS);
                    log.info("get lock key :" + key + " expire in ");
                    return Boolean.TRUE;
                }
                String string = (String)this.redisService.get(key);
            } while (System.nanoTime() - nowTime < TimeUnit.MILLISECONDS.toNanos(timeout));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u83b7\u53d6\u9501\u5f02\u5e38--------get---lock===" + key + "---exception=====");
        }
        return Boolean.FALSE;
    }
}

