/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.wechat.domain;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.wechat.cache.RedisLock;
import cc.lechun.wechat.cache.RedisService;
import cc.lechun.wechat.dao.WechatBaseMapper;
import cc.lechun.wechat.entity.WechatBaseEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WechatBase
extends BaseService<WechatBaseEntity, Integer> {
    @Autowired
    private RedisService redisService;
    @Autowired
    private WechatBaseMapper wechatBaseMapper;
    @Autowired
    private RedisLock redisLock;

    public WechatBaseEntity getAccessTokenByPlatformId(Integer platformId) {
        Object object = this.redisService.get("WECHAT_ACCESSTOKEN" + String.valueOf(platformId));
        if (object != null) {
            return (WechatBaseEntity)object;
        }
        WechatBaseEntity query = new WechatBaseEntity();
        query.setPlatformId(platformId);
        WechatBaseEntity weiXinBase = (WechatBaseEntity)this.wechatBaseMapper.getSingle(query);
        if (weiXinBase != null && weiXinBase.getExpired().after(DateUtils.now())) {
            return weiXinBase;
        }
        return null;
    }

    public String getAccessTokenValueByPlatformId(Integer platformId) {
        WechatBaseEntity weiXinBaseEntity = this.getAccessTokenByPlatformId(platformId);
        if (weiXinBaseEntity != null) {
            return weiXinBaseEntity.getAccessToken();
        }
        return "";
    }

    public String reflashAccessToken(WechatBaseEntity weiXinBaseEntity) {
        return "";
    }
}

