/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.accountBalance;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.active.iservice.active.ActiveQrcodeInterface;
import cc.lechun.apiinvoke.balance.BalanceAccountInvoke;
import cc.lechun.balance.dto.BalanceChangeDTO;
import cc.lechun.balance.dto.UserBalanceDTO;
import cc.lechun.balance.dto.UserBalanceDetailDTO;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.database.util.SpringContextUtil;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.pay.PayInputEntity;
import cc.lechun.mall.iservice.accountBalance.AccountBalanceInterface;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AccountBalanceService
extends BaseService
implements AccountBalanceInterface {
    @Value(value="${lechun.oldwealth.domain}")
    private String balanceHost;
    @Value(value="${lechun.oldwealth.domain1}")
    private String balanceHost1;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private ActiveQrcodeInterface qrcodeService;
    @Autowired
    private ActiveInterface activeService;
    @Autowired
    private BalanceAccountInvoke balanceApi;

    @Override
    public BigDecimal getGiftBalanceById(String customerId) {
        BaseJsonVo<UserBalanceDTO> userBalance = this.balanceApi.getUserBalance(customerId);
        this.logger.info(JsonUtils.toJson(userBalance, (boolean)true));
        this.customerInterface.removeCache(customerId);
        if (userBalance != null && userBalance.isSuccess()) {
            return ((UserBalanceDTO)userBalance.getValue()).getUsableTotalBalance();
        }
        this.logger.error("\u83b7\u53d6\u7528\u6237\u4f59\u989d\u5931\u8d25\uff0c\u8fd4\u56de0[" + customerId + "]:" + userBalance.getMessage());
        return new BigDecimal(0);
    }

    @Override
    public BigDecimal getGiftBalanceBySign(String sign) {
        CustomerEntity customer = this.customerInterface.getCustomerBySign(sign);
        return this.getGiftBalanceById(customer.getCustomerId());
    }

    @Override
    public BaseJsonVo useGiftBalance(String customerId, String orderMainNo, BigDecimal amount) {
        BaseJsonVo result = BaseJsonVo.success((Object)"");
        if (this.getGiftBalanceById(customerId).doubleValue() < amount.doubleValue()) {
            result.setError("\u4f59\u989d\u5c0f\u4e8e\u652f\u4ed8\u91d1\u989d\uff0c\u65e0\u6cd5\u652f\u4ed8");
            return result;
        }
        BaseJsonVo<BalanceChangeDTO> balanceChange = this.balanceApi.payOrder(customerId, orderMainNo, amount);
        this.customerInterface.removeCache(customerId);
        if (!balanceChange.isSuccess()) {
            throw new RuntimeException(balanceChange.getMessage());
        }
        HashMap<String, Object> wealth = new HashMap<String, Object>();
        wealth.put("wealth", ((BalanceChangeDTO)balanceChange.getValue()).getUserBalanceDetail().getUserBalance().getUsableTotalBalance().multiply(new BigDecimal(100)).intValue());
        wealth.put("store", ((BalanceChangeDTO)balanceChange.getValue()).getStoreBalanceChange().multiply(new BigDecimal(100)).intValue());
        wealth.put("present", ((BalanceChangeDTO)balanceChange.getValue()).getFreeBalanceChange().multiply(new BigDecimal(100)).intValue());
        wealth.put("card", ((BalanceChangeDTO)balanceChange.getValue()).getGiftBalanceChange().multiply(new BigDecimal(100)).intValue());
        wealth.put("thirdTradeNo", ((BalanceChangeDTO)balanceChange.getValue()).getDetailId());
        result.setValue(wealth);
        return result;
    }

    @Override
    public BaseJsonVo cancelGiftBalance(String customerId, String orderMainNo, BigDecimal amount) {
        this.logger.info("[\u53d6\u6d88\u8ba2\u5355\u9000\u4f59\u989d][" + orderMainNo + "][" + amount);
        BaseJsonVo<BalanceChangeDTO> balanceChange = this.balanceApi.cancleOrder(customerId, orderMainNo);
        this.customerInterface.removeCache(customerId);
        if (!balanceChange.isSuccess()) {
            throw new RuntimeException(balanceChange.getMessage());
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo refundOrder(PayInputEntity inputEntity, String opName) {
        this.logger.info("\u8ba2\u5355\u9000\u6b3e\u9000\u4f59\u989d|" + inputEntity.getOrderMainNo());
        try {
            BaseJsonVo<BalanceChangeDTO> balanceChange = this.balanceApi.refundOrder(inputEntity.getCustomerId(), inputEntity.getOrderMainNo(), inputEntity.getRefundAmount(), opName);
            this.customerInterface.removeCache(inputEntity.getCustomerId());
            if (!balanceChange.isSuccess()) {
                throw new RuntimeException(balanceChange.getMessage());
            }
        }
        catch (RuntimeException e) {
            this.logger.error("\u8ba2\u5355|" + inputEntity.getOrderMainNo() + "|\u9000\u6b3e\u5931\u8d25", (Throwable)e);
            throw e;
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo recharge(String customerId, int amount, String changeType, String remark, boolean isSendMsg) {
        return null;
    }

    @Override
    public BaseJsonVo rechargeByEvaluate(String customerId, String orderMainNo, Integer changeWealth) throws IOException {
        return ((AccountBalanceService)SpringContextUtil.getBean(this.getClass())).activeCharge(customerId, new BigDecimal(changeWealth).divide(new BigDecimal(100)), "\u8bc4\u4ef7\u8d60\u9001", true, "\u8bc4\u4ef7\u6210\u529f\uff0c\u8d60\u9001", orderMainNo);
    }

    @Override
    public BaseJsonVo mergeAccount(String sourceId, String targetId) throws IOException {
        BaseJsonVo result = new BaseJsonVo();
        result.setError("\u5408\u5e76\u5931\u8d25");
        return result;
    }

    @Override
    public BaseJsonVo activeCharge(String customerId, String bindCode) {
        BaseJsonVo sr = new BaseJsonVo();
        sr.setError("\u65b9\u6cd5\u4e3a\u5b9e\u73b0");
        return sr;
    }

    @Override
    public BaseJsonVo activeCharge(String customerId, String bindCode, int amountOfFen) {
        ActiveEntity activeEntity = this.activeService.getActiveEntityByQrcode(bindCode);
        return ((AccountBalanceService)SpringContextUtil.getBean(this.getClass())).activeCharge(customerId, new BigDecimal(amountOfFen).divide(new BigDecimal(100)), activeEntity != null ? activeEntity.getActiveName() : "", activeEntity != null, activeEntity != null ? activeEntity.getActiveName() + "\u8d60\u9001" : "", bindCode);
    }

    @Override
    public BaseJsonVo activeCharge(String customerId, BigDecimal increaseAmount, String detailSubTypeDesc, Boolean notice, String noticeText, String remark) {
        BaseJsonVo<BalanceChangeDTO> balanceChange = this.balanceApi.activeCharge(customerId, increaseAmount, detailSubTypeDesc, true, noticeText, remark);
        this.customerInterface.removeCache(customerId);
        if (!balanceChange.isSuccess()) {
            throw new RuntimeException(balanceChange.getMessage());
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public BaseJsonVo getUserBalanceDetail(String customerId) {
        BaseJsonVo sr = new BaseJsonVo();
        BaseJsonVo<UserBalanceDetailDTO> userBalanceDetail = this.balanceApi.getUserBalanceDetail(customerId);
        this.customerInterface.removeCache(customerId);
        if (!userBalanceDetail.isSuccess()) {
            throw new RuntimeException(userBalanceDetail.getMessage());
        }
        sr.setValue(userBalanceDetail.getValue());
        return sr;
    }

    @Override
    public BaseJsonVo<BalanceChangeDTO> refundCharge(String customerId, String orderMainNo, String operator) {
        BaseJsonVo<BalanceChangeDTO> balanceChange = this.balanceApi.refundCharge(customerId, orderMainNo, operator);
        this.customerInterface.removeCache(customerId);
        if (!balanceChange.isSuccess()) {
            throw new RuntimeException(balanceChange.getMessage());
        }
        return balanceChange;
    }

    @Override
    public BaseJsonVo increaseManual(String customerId, BigDecimal increaseAmount, String operator, String detailSubTypeDesc) {
        BaseJsonVo sr = new BaseJsonVo();
        BaseJsonVo<BalanceChangeDTO> balanceChange = this.balanceApi.increaseManual(customerId, increaseAmount, operator, detailSubTypeDesc);
        this.customerInterface.removeCache(customerId);
        if (!balanceChange.isSuccess()) {
            throw new RuntimeException(balanceChange.getMessage());
        }
        sr.setValue(balanceChange.getValue());
        return sr;
    }

    @Override
    public BaseJsonVo reduceManual(String customerId, BigDecimal reduceAmount, String operator, String detailSubTypeDesc) {
        BaseJsonVo sr = new BaseJsonVo();
        BaseJsonVo<BalanceChangeDTO> balanceChange = this.balanceApi.reduceManual(customerId, reduceAmount, operator, detailSubTypeDesc);
        this.customerInterface.removeCache(customerId);
        if (!balanceChange.isSuccess()) {
            throw new RuntimeException(balanceChange.getMessage());
        }
        sr.setValue(balanceChange.getValue());
        return sr;
    }
}

