/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.cashticket;

import cc.lechun.common.constants.message.MessageActionConstants;
import cc.lechun.common.enums.cashticket.CashBathStatusEnum;
import cc.lechun.common.enums.cashticket.CashDiscountModeEnum;
import cc.lechun.common.enums.cashticket.CashPeriodTypeEnum;
import cc.lechun.common.enums.cashticket.CashRuleStatusEnum;
import cc.lechun.common.enums.cashticket.CashRuleTypeEnum;
import cc.lechun.common.enums.cashticket.CashStatusEnum;
import cc.lechun.common.enums.cashticket.MallCashUseStatusEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.framework.common.enums.jms.MessageQueueTagEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.math.MathUtils;
import cc.lechun.framework.common.utils.object.CollectionUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.common.vo.jms.MessageParam;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.framework.core.jms.MessageQueueService;
import cc.lechun.mall.dao.cashticket.CashticketCustomerMapper;
import cc.lechun.mall.dao.cashticket.CashticketSendLogMapper;
import cc.lechun.mall.entity.cashticket.CashSendVo;
import cc.lechun.mall.entity.cashticket.CashticketActivTionVo;
import cc.lechun.mall.entity.cashticket.CashticketBatchEntity;
import cc.lechun.mall.entity.cashticket.CashticketBatchNewRuleVo;
import cc.lechun.mall.entity.cashticket.CashticketCustomerEntity;
import cc.lechun.mall.entity.cashticket.CashticketEntity;
import cc.lechun.mall.entity.cashticket.CashticketSendLogEntity;
import cc.lechun.mall.entity.cashticket.CashticketSimpleVo;
import cc.lechun.mall.entity.cashticket.CashticketVo;
import cc.lechun.mall.entity.customer.CustomerDetailVo;
import cc.lechun.mall.entity.platform.PlatFormEntity;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.iservice.cashticket.CashticketCustomerInterface;
import cc.lechun.mall.service.cashticket.CashticketBatchService;
import cc.lechun.mall.service.cashticket.CashticketService;
import cc.lechun.mall.service.cashticket.cashticketBatchNewRuleService;
import cc.lechun.mall.service.customer.CustomerService;
import cc.lechun.mall.service.platform.PlatFormService;
import cc.lechun.mall.service.weixin.MessageService;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CashticketCustomerService
extends BaseService
implements CashticketCustomerInterface {
    @Autowired
    private CashticketBatchService cashticketBatchService;
    @Autowired
    private CashticketSendLogMapper cashticketSendLogMapper;
    @Autowired
    private CashticketCustomerMapper cashticketCustomerMapper;
    @Autowired
    private cashticketBatchNewRuleService cashticketBatchNewRuleService;
    @Autowired
    private MessageQueueService messageQueueService;
    @Autowired
    private CashticketService cashticketService;
    @Autowired
    private CustomerService customerService;
    @Autowired
    @Lazy
    private MessageService messageService;
    @Autowired
    private PlatFormService platformService;

    @Override
    public Page<CashticketCustomerEntity> getCustomerCashticketList(String customerId, Integer pageSize, Integer pageCount) {
        Page page = PageHelper.startPage((int)pageCount, (int)pageSize);
        page.setOrderBy("TICKET_CUSTOMER_ID desc");
        CashticketCustomerEntity cashticketCustomerEntity = new CashticketCustomerEntity();
        cashticketCustomerEntity.setCustomerId(customerId);
        this.cashticketCustomerMapper.getList(cashticketCustomerEntity);
        return page;
    }

    @Override
    public int getCashticketTicketId(String bindCode, String customerId) {
        return this.cashticketCustomerMapper.getCashticketTicketId(customerId, bindCode);
    }

    @Override
    public boolean insertCashticketCustomer(CashticketBatchEntity cashticketBatchEntity, CashticketCustomerEntity cashticketCustomerEntity, Integer platformId, String openId, boolean sendMessage) {
        return this.insertCashticketCustomer(cashticketBatchEntity, cashticketCustomerEntity, 0.0, platformId, openId, sendMessage);
    }

    @Override
    @Transactional
    public boolean insertCashticketCustomer(CashticketBatchEntity cashticketBatchEntity, CashticketCustomerEntity cashticketCustomerEntity, double amount, Integer platformId, String openId, boolean sendMessage) {
        String message = "";
        CashticketEntity cash = this.cashticketService.addCashTicketNos(cashticketBatchEntity);
        if (cash == null) {
            this.logger.error("\u751f\u6210\u4f18\u60e0\u5238\u5931\u8d25,{}", (Object)cashticketCustomerEntity.toString());
            message = "\u751f\u6210\u4f18\u60e0\u5238\u5931\u8d25";
            throw new RuntimeException(message);
        }
        cash = this.cashticketService.getCashticket4No(cash.getTicketNo());
        cashticketCustomerEntity.setTicketId(cash.getTicketId());
        this.logger.info("\u751f\u6210\u4f18\u60e0\u5238\u8bb0\u5f55:{}", (Object)cash.toString());
        if (this.cashticketCustomerMapper.insertSelective(cashticketCustomerEntity) == 0) {
            this.logger.error("\u4f18\u60e0\u5238\u9886\u53d6\u5931\u8d25,{}", (Object)cashticketCustomerEntity.toString());
            message = "\u9886\u53d6\u4f18\u60e0\u5238\u5931\u8d25";
            throw new RuntimeException(message);
        }
        this.logger.info("\u4f18\u60e0\u5238\u9886\u53d6\u6210\u529f,{}", (Object)cashticketCustomerEntity.toString());
        if (amount != 0.0) {
            if (!this.cashticketService.updateCashticketAmount(cash.getTicketId(), amount)) {
                message = "\u4f18\u60e0\u52b5\u9886\u53d6\u5931\u8d25,\u66f4\u65b0\u91d1\u989d\u5931\u8d25";
                throw new RuntimeException(message);
            }
            cashticketBatchEntity.setAmount(new BigDecimal(amount));
        }
        if (sendMessage) {
            PlatFormEntity platFormEntity = this.platformService.getPlatForm(platformId);
            HashMap map = this.getMssageCashSendSuccess(cashticketBatchEntity, cashticketCustomerEntity.getEndTime(), platFormEntity.getDomainPage());
            this.messageService.sendWechatMessage((int)platformId, MessageActionConstants.cashSendSuccess, openId, (Map<String, String>)map);
        }
        return true;
    }

    @Override
    public CashticketCustomerEntity getCashticketCustomer(int ticketCustomerId) {
        return (CashticketCustomerEntity)this.cashticketCustomerMapper.selectByPrimaryKey(Integer.valueOf(ticketCustomerId));
    }

    @Override
    @Transactional
    public BaseJsonVo useCashTicketCustomer(String customerId, int ticketCustomerId, String orderMainNo, BigDecimal realyDeduction) {
        CashticketCustomerEntity cashticketCustomerEntity = this.getCashticketCustomer(ticketCustomerId);
        if (cashticketCustomerEntity == null) {
            return BaseJsonVo.error((String)"\u4f18\u60e0\u52b5\u4e0d\u5b58\u5728");
        }
        if (!cashticketCustomerEntity.getCustomerId().equals(customerId)) {
            return BaseJsonVo.error((String)"\u65e0\u6548\u4f18\u60e0\u52b5");
        }
        CashticketBatchEntity cashticketBatchEntity = this.cashticketBatchService.getCashticketBatch(cashticketCustomerEntity.getTicketBatchId());
        if (cashticketBatchEntity == null) {
            return BaseJsonVo.error((String)"\u4f18\u60e0\u52b5\u4e0d\u5b58\u5728");
        }
        List<CashticketSimpleVo> ls = this.cashticketCustomerMapper.getCashticketList4Status(cashticketBatchEntity.getPlatformGroupId(), customerId, ticketCustomerId, 1);
        if (ls == null || ls.size() == 0) {
            return BaseJsonVo.error((String)"\u4f18\u60e0\u52b5\u5df2\u5931\u6548");
        }
        if (this.cashticketCustomerMapper.updateCustomerCashStasusUse(customerId, orderMainNo, realyDeduction, ticketCustomerId) <= 0) {
            return BaseJsonVo.paramError((String)"\u4f18\u60e0\u52b5\u65e0\u6cd5\u4f7f\u7528");
        }
        this.cashticketService.updateCashticketStatus(cashticketCustomerEntity.getTicketId(), CashStatusEnum.yishiyong);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @Transactional
    public BaseJsonVo returnCashTicketCustomer(int ticketCustomerId, String orderMainNo) {
        CashticketCustomerEntity cashticketCustomerEntity = this.getCashticketCustomer(ticketCustomerId);
        if (cashticketCustomerEntity == null) {
            CashticketCustomerEntity query = new CashticketCustomerEntity();
            query.setTicketId(ticketCustomerId);
            query.setOrderMainNo(orderMainNo);
            query.setStatus(CashStatusEnum.yishiyong.getValue());
            cashticketCustomerEntity = (CashticketCustomerEntity)CollectionUtils.listToEntiy((List)this.cashticketCustomerMapper.getList(query));
        }
        cashticketCustomerEntity.setOrderMainNo("");
        cashticketCustomerEntity.setStatus(CashStatusEnum.yijihuo.getValue());
        this.cashticketCustomerMapper.updateByPrimaryKeySelective(cashticketCustomerEntity);
        this.cashticketService.updateCashticketStatus(cashticketCustomerEntity.getTicketId(), CashStatusEnum.yijihuo);
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public List<CashticketCustomerEntity> getCashticketCustomerList(String customerId, String ticketBatchId) {
        CashticketCustomerEntity param = new CashticketCustomerEntity();
        param.setCustomerId(customerId);
        param.setTicketBatchId(ticketBatchId);
        return this.cashticketCustomerMapper.getList(param);
    }

    @Override
    public BaseJsonVo sendTicket4Code(String customerId, CashticketBatchEntity cashticketBatchEntity, int count, int ticketId, int platformId, boolean isSendMessage) {
        return this.sendTicket(customerId, cashticketBatchEntity, count, "", "", "", ticketId, platformId, isSendMessage, 0.0);
    }

    @Override
    public BaseJsonVo sendTicket4Base(String customerId, String ticketBatchId, int count, String activeNo, String bindCode, String versionDetailId, int platformId, boolean isSendMessage) {
        return this.sendChangeAmountTicket(customerId, ticketBatchId, count, activeNo, bindCode, versionDetailId, 0.0, platformId, isSendMessage);
    }

    @Override
    public BaseJsonVo sendTicket4Base(String customerId, String ticketBatchId, int count, String activeNo, String bindCode, double amount, String versionDetailId, int platformId, boolean isSendMessage) {
        return this.sendChangeAmountTicket(customerId, ticketBatchId, count, activeNo, bindCode, versionDetailId, amount, platformId, isSendMessage);
    }

    @Override
    public BaseJsonVo sendChangeAmountTicket(String customerId, String ticketBatchId, int count, String activeNo, String bindCode, String versionDetailId, double amount, int platformId, boolean isSendMessage) {
        CashticketBatchEntity cashticketBatchEntity = this.cashticketBatchService.getCashticketBatch(ticketBatchId);
        BaseJsonVo vo = this.sendTicket(customerId, cashticketBatchEntity, count, activeNo, bindCode, versionDetailId, 0, platformId, isSendMessage, amount);
        return vo;
    }

    @Override
    public void sendTicket4BaseMessageQueue(String customerId, String ticketBatchId, int count, String activeNo, String bindCode, String versionDetailId, int platformId, boolean isSendMessage) {
        CashSendVo vo = new CashSendVo(customerId, ticketBatchId, count, activeNo, bindCode, versionDetailId, isSendMessage);
        vo.setPlatformId(platformId);
        this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.sendCashTicket, MessageParam.messageParam((String)vo.getOpenId(), (Object)vo));
    }

    @Transactional
    public BaseJsonVo sendTicket(String customerId, CashticketBatchEntity cashticketBatchEntity, int count, String activeNo, String bindCode, String versionDetailId, int ticketId, int platformId, boolean isSendMessage, double amount) {
        CustomerDetailVo customerEntity = this.customerService.getCustomerDetail(customerId, platformId);
        CashticketActivTionVo cashticketEntity = null;
        String message = "";
        boolean isActivite = ticketId == 0;
        boolean isSuccess = false;
        if (customerEntity == null) {
            message = "\u65e0\u6548\u7684\u7528\u6237";
            throw new RuntimeException(message);
        }
        if (!customerEntity.getPlatformGroupId().equals(cashticketBatchEntity.getPlatformGroupId())) {
            message = "\u65e0\u6548\u7684\u4f18\u60e0\u52b5\u6240\u5c5e\u516c\u53f8";
            throw new RuntimeException(message);
        }
        if (cashticketBatchEntity == null) {
            message = "\u65e0\u6548\u7684\u4f18\u60e0\u52b5\u6279\u6b21";
            throw new RuntimeException(message);
        }
        if (count < 1) {
            message = "\u53d1\u9001\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e1";
            throw new RuntimeException(message);
        }
        if (cashticketBatchEntity.getStatus() == 0) {
            message = "\u4f18\u60e0\u52b5\u5df2\u5931\u6548";
            throw new RuntimeException(message);
        }
        if (cashticketBatchEntity.getQuantity() > 0 && cashticketBatchEntity.getAlreadyQuantity() >= cashticketBatchEntity.getQuantity()) {
            message = "\u53ef\u7528\u4f18\u60e0\u52b5\u4e0d\u8db3";
            this.logger.info(cashticketBatchEntity.getTicketBatchName() + message);
            throw new RuntimeException(message);
        }
        if (amount > 0.0 && cashticketBatchEntity.getDiscountMode().shortValue() == CashDiscountModeEnum.manjian.getValue() && new BigDecimal(amount).compareTo(cashticketBatchEntity.getAmount()) == 1) {
            message = "\u5151\u6362\u91d1\u989d\u8d85\u8fc7\u5141\u8bb8\u5151\u6362\u6700\u5927\u91d1\u989d";
            throw new RuntimeException(message);
        }
        int j = 0;
        for (int i = 0; i < count; ++i) {
            while (!isSuccess) {
                if (j > 10) {
                    message = "\u4f18\u60e0\u52b5\u53d1\u653e\u5f02\u5e38";
                    throw new RuntimeException(message);
                }
                List<CashticketCustomerEntity> ls = this.getCashticketCustomerList(customerId, cashticketBatchEntity.getTicketBatchId());
                if (ls != null && cashticketBatchEntity.getUserTackCount() > 0 && ls.size() >= cashticketBatchEntity.getUserTackCount()) {
                    message = cashticketBatchEntity.getTicketBatchName() + "\u5df2\u9886\u53d6,\u4e0d\u53ef\u4ee5\u91cd\u590d\u9886\u53d6";
                    this.logger.info("\u4f18\u60e0\u5238:{},{}", (Object)cashticketBatchEntity.getTicketBatchName(), (Object)message);
                    this.messageService.sendCustomerTextMessage4CustmoerId(customerId, platformId, message, 0);
                    throw new RuntimeException(message);
                }
                CashticketCustomerEntity cashticketCustomerEntity = new CashticketCustomerEntity();
                cashticketCustomerEntity.setTicketId(ticketId);
                cashticketCustomerEntity.setTicketBatchId(cashticketBatchEntity.getTicketBatchId());
                cashticketCustomerEntity.setCustomerId(customerId);
                cashticketCustomerEntity.setSourceActiveNo(activeNo);
                cashticketCustomerEntity.setStatus(CashStatusEnum.yijihuo.getValue());
                cashticketCustomerEntity.setBindCode(bindCode);
                cashticketCustomerEntity.setVersionDetailId(versionDetailId);
                if (cashticketBatchEntity.getPeriodType().intValue() == CashPeriodTypeEnum.tianshu.getValue()) {
                    cashticketCustomerEntity.setBeginTime(DateUtils.currentDate());
                    cashticketCustomerEntity.setEndTime(DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)(cashticketBatchEntity.getDays() + 1)));
                } else {
                    cashticketCustomerEntity.setBeginTime(cashticketBatchEntity.getBeginTime());
                    cashticketCustomerEntity.setEndTime(DateUtils.getAddDateByDay((Date)cashticketBatchEntity.getEndTime(), (int)1));
                }
                cashticketCustomerEntity.setCreateTime(DateUtils.now());
                if (this.cashticketBatchService.updateCashticketBatchAlreadyQuantity(cashticketBatchEntity.getTicketBatchId(), 1)) {
                    this.logger.info("\u67e5\u770b\u4f18\u60e0\u5238\u53d1\u653e\u6765\u6e90:{}", (Object)isActivite);
                    if (isActivite) {
                        HashMap<String, Object> messageBody = new HashMap<String, Object>();
                        messageBody.put("cashticketBatch", cashticketBatchEntity);
                        messageBody.put("cashticketCustomer", cashticketCustomerEntity);
                        messageBody.put("amount", amount);
                        messageBody.put("platformId", platformId);
                        messageBody.put("openId", customerEntity.getOpenId());
                        messageBody.put("sendMessage", isSendMessage);
                        this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.takedCash, MessageParam.messageParam((String)customerId, messageBody));
                        isSendMessage = false;
                        isSuccess = true;
                    } else if (this.cashticketService.updateCashticketStatus(ticketId, CashStatusEnum.yijihuo, cashticketBatchEntity)) {
                        if (this.cashticketCustomerMapper.insertSelective(cashticketCustomerEntity) == 0) {
                            message = "\u4f18\u60e0\u52b5\u9886\u53d6\u5931\u8d25";
                            throw new RuntimeException(message);
                        }
                        cashticketBatchEntity.setAlreadyQuantity(cashticketBatchEntity.getAlreadyQuantity() + 1);
                        if (amount != 0.0 && !this.cashticketService.updateCashticketAmount(ticketId, amount)) {
                            message = "\u4f18\u60e0\u52b5\u9886\u53d6\u5931\u8d25,\u66f4\u65b0\u91d1\u989d\u5931\u8d25";
                            throw new RuntimeException(message);
                        }
                        isSuccess = true;
                    }
                } else {
                    message = "\u53ef\u7528\u4f18\u60e0\u52b5\u4e0d\u8db3";
                    throw new RuntimeException(message);
                }
                if (isSuccess && isSendMessage) {
                    PlatFormEntity platFormEntity = this.platformService.getPlatForm(platformId);
                    if (amount > 0.0) {
                        cashticketBatchEntity.setAmount(new BigDecimal(amount));
                    }
                    HashMap map = this.getMssageCashSendSuccess(cashticketBatchEntity, cashticketCustomerEntity.getEndTime(), platFormEntity.getDomainPage());
                    this.messageService.sendWechatMessage((int)customerEntity.getPlatformId(), MessageActionConstants.cashSendSuccess, customerEntity.getOpenId(), (Map<String, String>)map);
                }
                ++j;
            }
        }
        HashMap<String, String> messageBody = new HashMap<String, String>();
        messageBody.put("userId", customerId);
        messageBody.put("ticketNo", cashticketEntity == null ? "" : cashticketEntity.getTicketNo());
        messageBody.put("bindCode", bindCode);
        this.messageQueueService.sendBaseMessage(MessageQueueTagEnum.receiveTicket, MessageParam.messageParam((String)customerId, messageBody));
        return BaseJsonVo.success((Object)"\u5151\u6362\u6210\u529f");
    }

    private HashMap getMssageCashSendSuccess(CashticketBatchEntity cashticketBatchEntity, Date endTime, String domin_page) {
        HashMap<String, String> map = new HashMap<String, String>();
        String pre = "";
        pre = cashticketBatchEntity.getMinUseamount().doubleValue() == 0.0 ? "\u65e0\u95e8\u69db" : "\u6ee1" + cashticketBatchEntity.getMinUseamount().doubleValue();
        if (cashticketBatchEntity.getDiscountMode().shortValue() == CashDiscountModeEnum.manjian.getValue()) {
            pre = pre + "\u51cf" + cashticketBatchEntity.getAmount();
        } else if (cashticketBatchEntity.getDiscountMode().shortValue() == CashDiscountModeEnum.zhekou.getValue()) {
            pre = pre + "\u4eab" + MathUtils.divBigDecimal((Number)cashticketBatchEntity.getDiscountAmount(), (Number)10, (Integer)2) + "\u6298";
        }
        map.put("cashTitle", pre);
        map.put("cashName", cashticketBatchEntity.getTicketBatchName());
        map.put("cashdDomin", domin_page);
        map.put("cashEndTime", DateUtils.formatDate((Date)endTime, (String)"yyyy\u5e74MM\u6708dd\u65e5"));
        return map;
    }

    @Override
    public void saveSendLog(String customerId, CashticketBatchEntity cashticketBatchEntity, String ticketBatchId, String bindCode, String versionDetailId, BaseJsonVo vo, int ticketId, String ticketNo, int count) {
        try {
            vo.setMessage(count + ":" + vo.getMessage());
            CashticketSendLogEntity cashticketSendLogEntity = new CashticketSendLogEntity();
            if (cashticketBatchEntity != null) {
                cashticketSendLogEntity.setAmount(cashticketBatchEntity.getAmount());
                cashticketSendLogEntity.setTicketBatchName(cashticketBatchEntity.getTicketBatchName());
                cashticketSendLogEntity.setTicketBatchId(cashticketBatchEntity.getTicketBatchId());
            } else {
                cashticketSendLogEntity.setTicketBatchId(ticketBatchId);
            }
            cashticketSendLogEntity.setTicketNo(ticketNo);
            cashticketSendLogEntity.setTicketId(ticketId);
            cashticketSendLogEntity.setBindCode(bindCode);
            cashticketSendLogEntity.setCustomerId(customerId);
            cashticketSendLogEntity.setCreateTime(DateUtils.now());
            cashticketSendLogEntity.setMessage(JSON.toJSONString((Object)vo));
            cashticketSendLogEntity.setVersionDetailId(versionDetailId);
            cashticketSendLogEntity.setStatus(vo.isSuccess() ? 1 : 0);
            this.cashticketSendLogMapper.insertSelective(cashticketSendLogEntity);
        }
        catch (Exception e) {
            this.logger.error("", (Throwable)e);
        }
    }

    @Override
    public void saveSendLog(String customerId, String ticketBatchId, String status, String bindCode, String versionDetailId, String message, String count) {
        CashticketBatchEntity cashticketBatchEntity = this.cashticketBatchService.getCashticketBatch(ticketBatchId);
        CashticketSendLogEntity cashticketSendLogEntity = new CashticketSendLogEntity();
        if (cashticketBatchEntity != null) {
            cashticketSendLogEntity.setAmount(cashticketBatchEntity.getAmount());
            cashticketSendLogEntity.setTicketBatchName(cashticketBatchEntity.getTicketBatchName());
            cashticketSendLogEntity.setTicketBatchId(cashticketBatchEntity.getTicketBatchId());
        }
        cashticketSendLogEntity.setTicketNo("");
        cashticketSendLogEntity.setTicketId(0);
        cashticketSendLogEntity.setBindCode(bindCode);
        cashticketSendLogEntity.setCustomerId(customerId);
        cashticketSendLogEntity.setCreateTime(DateUtils.now());
        cashticketSendLogEntity.setMessage(message + ",\u4f18\u60e0\u5238\u6570\u91cf:" + count);
        cashticketSendLogEntity.setVersionDetailId(versionDetailId);
        cashticketSendLogEntity.setStatus(Integer.valueOf(status));
        this.cashticketSendLogMapper.insertSelective(cashticketSendLogEntity);
    }

    @Override
    public List<CashticketVo> getValidCashticketList(int platformGroupId, String customerId) {
        ArrayList<CashticketVo> rs = new ArrayList<CashticketVo>();
        List<CashticketSimpleVo> ls = this.cashticketCustomerMapper.getCashticketList4Status(platformGroupId, customerId, 0, 1);
        if (ls != null && ls.size() > 0) {
            for (CashticketSimpleVo simpleVo : ls) {
                rs.add(this.getCashticketVo(simpleVo, true, new BigDecimal(0)));
            }
        }
        return rs;
    }

    @Override
    public List<CashticketVo> getUseCashticketList(int platformGroupId, String customerId) {
        ArrayList<CashticketVo> rs = new ArrayList<CashticketVo>();
        List<CashticketSimpleVo> ls = this.cashticketCustomerMapper.getCashticketList4Status(platformGroupId, customerId, 0, 3);
        ls.forEach(cashticketSimpleVo -> rs.add(this.getCashticketVo((CashticketSimpleVo)cashticketSimpleVo, false, new BigDecimal(0))));
        return rs;
    }

    @Override
    public List<CashticketVo> getInvalidCashticketList(int platformGroupId, String customerId) {
        ArrayList<CashticketVo> rs = new ArrayList<CashticketVo>();
        List<CashticketSimpleVo> ls = this.cashticketCustomerMapper.getCashticketList4Status(platformGroupId, customerId, 0, 2);
        if (ls != null && ls.size() > 0) {
            for (CashticketSimpleVo simpleVo : ls) {
                rs.add(this.getCashticketVo(simpleVo, false, new BigDecimal(0)));
            }
        }
        return rs;
    }

    @Override
    public List<CashticketVo> getEnabledCashticketList(int platformGroupId, int ticketCustomerId, String customerId, MallOrderVo orderVo) {
        ArrayList<MallOrderVo> orderVos = new ArrayList<MallOrderVo>();
        if (orderVo != null) {
            orderVos.add(orderVo);
        }
        return this.getEnabledCashticketList(platformGroupId, ticketCustomerId, customerId, orderVos);
    }

    @Override
    public List<CashticketVo> getEnabledCashticketList(int platformGroupId, int ticketCustomerId, String customerId, List<MallOrderVo> orderVos) {
        if (orderVos == null || orderVos.size() == 0) {
            return this.getValidCashticketList(platformGroupId, customerId);
        }
        ArrayList<CashticketVo> rs = new ArrayList<CashticketVo>();
        List<CashticketSimpleVo> ls = this.cashticketCustomerMapper.getCashticketList4Status(platformGroupId, customerId, ticketCustomerId, 1);
        this.logger.info("\u8fd4\u56de\u4f18\u60e0\u5238\u884c\u6570\uff1a" + ls.size() + ",platformGroupId:" + platformGroupId + ",customerId" + customerId + ",ticketCustomerId" + ticketCustomerId + ",select_status_valid" + 1);
        if (ls == null || ls.size() == 0) {
            return rs;
        }
        boolean jxbdz_fk = true;
        if (orderVos.get(0).getOrderSource() == OrderSourceEnum.COLLAGE.getValue()) {
            return null;
        }
        block0: for (CashticketSimpleVo simpleVo : ls) {
            List<CashticketBatchNewRuleVo> rule_ls = this.cashticketBatchNewRuleService.getCashRule(simpleVo.getTicketBatchId());
            Map<Integer, CashticketBatchNewRuleVo> rule_map = rule_ls == null || rule_ls.size() == 0 ? null : rule_ls.stream().collect(Collectors.toMap(o -> o.getRuleType(), o -> o));
            BigDecimal total_use_cash_amonut = new BigDecimal(0);
            for (MallOrderVo mallOrderVo : orderVos) {
                if (mallOrderVo.getProducts() != null) {
                    for (MallProductVO mallProductVO : mallOrderVo.getProducts()) {
                        if (mallProductVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
                        if (this.getCashUseStatus(rule_map, mallProductVO.getProId(), CashRuleTypeEnum.danpin.getValue(), mallOrderVo.getPlatFormId(), mallOrderVo.getBindCode())) {
                            total_use_cash_amonut = total_use_cash_amonut.add(MathUtils.mulBigDecimal((Number)mallProductVO.getCount(), (Number)mallOrderVo.getDeliverCount()).multiply(mallProductVO.getFactPrice()));
                        } else if (ticketCustomerId != 0) {
                            mallProductVO.setUseCoupon(MallCashUseStatusEnum.no_use.getValue());
                        }
                        jxbdz_fk = false;
                    }
                }
                if (mallOrderVo.getGroups() != null) {
                    for (MallGroupVO mallGroupVO : mallOrderVo.getGroups()) {
                        if (mallGroupVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
                        if (this.getCashUseStatus(rule_map, mallGroupVO.getGroupId(), CashRuleTypeEnum.taozhuang.getValue(), mallOrderVo.getPlatFormId(), mallOrderVo.getBindCode())) {
                            total_use_cash_amonut = total_use_cash_amonut.add(MathUtils.mulBigDecimal((Number)mallGroupVO.getCount(), (Number)mallOrderVo.getDeliverCount()).multiply(mallGroupVO.getFactPrice()));
                        } else if (ticketCustomerId != 0) {
                            mallGroupVO.setUseCoupon(MallCashUseStatusEnum.no_use.getValue());
                        }
                        jxbdz_fk = false;
                    }
                }
                if (mallOrderVo.getPromotions() == null) continue;
                for (MallPromotionVO mallPromotionVO : mallOrderVo.getPromotions()) {
                    if (mallPromotionVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
                    if (this.getCashUseStatus(rule_map, mallPromotionVO.getPromotionId(), CashRuleTypeEnum.cuxiao.getValue(), mallOrderVo.getPlatFormId(), mallOrderVo.getBindCode())) {
                        total_use_cash_amonut = total_use_cash_amonut.add(MathUtils.mulBigDecimal((Number)mallPromotionVO.getCount(), (Number)mallOrderVo.getDeliverCount()).multiply(mallPromotionVO.getFactPrice()));
                    } else if (ticketCustomerId != 0) {
                        mallPromotionVO.setUseCoupon(MallCashUseStatusEnum.no_use.getValue());
                    }
                    jxbdz_fk = false;
                }
            }
            this.logger.info("total_use_cash_amonut.doubleValue() >= simpleVo.getMinUseamount().doubleValue()," + total_use_cash_amonut.doubleValue() + "," + simpleVo.getMinUseamount().doubleValue());
            if (!(total_use_cash_amonut.doubleValue() >= simpleVo.getMinUseamount().doubleValue())) continue;
            BigDecimal enableCashticketAmount = null;
            if (simpleVo.getDiscountMode().shortValue() == CashDiscountModeEnum.manjian.getValue()) {
                enableCashticketAmount = total_use_cash_amonut.doubleValue() > simpleVo.getAmount().doubleValue() ? simpleVo.getAmount() : total_use_cash_amonut;
            } else if (simpleVo.getDiscountMode().shortValue() == CashDiscountModeEnum.zhekou.getValue()) {
                enableCashticketAmount = MathUtils.divBigDecimal((Double)MathUtils.mulBigDecimal((Number)total_use_cash_amonut, (Number)(100 - simpleVo.getDiscountAmount())).doubleValue(), (Double)100.0, (Integer)2);
            }
            this.logger.info("\u4f18\u60e0\u5238\u91d1\u989d\uff1a" + enableCashticketAmount);
            if (enableCashticketAmount != null && enableCashticketAmount.doubleValue() != 0.0) {
                rs.add(this.getCashticketVo(simpleVo, true, enableCashticketAmount));
                this.logger.info("\u4f18\u60e0\u5238rs\uff1a" + rs.size());
            }
            if (ticketCustomerId == 0) continue;
            for (MallOrderVo mallOrderVo3 : orderVos) {
                BigDecimal single_amount;
                BigDecimal couponAmount = new BigDecimal(0);
                boolean order_use_cash = false;
                if (mallOrderVo3.getProducts() != null) {
                    for (MallProductVO mallProductVO : mallOrderVo3.getProducts()) {
                        if (mallProductVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
                        order_use_cash = true;
                        single_amount = enableCashticketAmount.multiply(mallProductVO.getFactPrice()).divide(total_use_cash_amonut, 6, 4);
                        mallProductVO.setCouponAmount(single_amount);
                        couponAmount = couponAmount.add(MathUtils.mulBigDecimal((Number)single_amount, (Number)mallProductVO.getCount()));
                    }
                }
                if (mallOrderVo3.getGroups() != null) {
                    for (MallGroupVO mallGroupVO : mallOrderVo3.getGroups()) {
                        if (mallGroupVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
                        order_use_cash = true;
                        single_amount = enableCashticketAmount.multiply(mallGroupVO.getFactPrice()).divide(total_use_cash_amonut, 6, 4);
                        mallGroupVO.setCouponAmount(single_amount);
                        couponAmount = couponAmount.add(MathUtils.mulBigDecimal((Number)single_amount, (Number)mallGroupVO.getCount()));
                    }
                }
                if (mallOrderVo3.getPromotions() != null) {
                    for (MallPromotionVO mallPromotionVO : mallOrderVo3.getPromotions()) {
                        if (mallPromotionVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
                        order_use_cash = true;
                        single_amount = enableCashticketAmount.multiply(mallPromotionVO.getFactPrice()).divide(total_use_cash_amonut, 6, 4);
                        mallPromotionVO.setCouponAmount(single_amount);
                        couponAmount = couponAmount.add(MathUtils.mulBigDecimal((Number)single_amount, (Number)mallPromotionVO.getCount()));
                    }
                }
                mallOrderVo3.setUseCoupon(order_use_cash);
                mallOrderVo3.setCouponAmount(couponAmount);
            }
            BigDecimal bigDecimal = BigDecimal.valueOf(orderVos.stream().mapToDouble(c -> MathUtils.mulBigDecimal((Number)c.getCouponAmount(), (Number)c.getDeliverCount()).doubleValue()).sum());
            BigDecimal diff_amount = enableCashticketAmount.subtract(bigDecimal);
            if (diff_amount.doubleValue() == 0.0) continue;
            MallOrderVo mallOrderVo4 = orderVos.get(0);
            mallOrderVo4.setCouponAmount(mallOrderVo4.getCouponAmount().add(diff_amount));
            if (mallOrderVo4.getProducts() != null) {
                for (MallProductVO mallProductVO : mallOrderVo4.getProducts()) {
                    if (mallProductVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
                    mallProductVO.setCouponAmount(mallProductVO.getCouponAmount().add(diff_amount));
                    continue block0;
                }
                continue;
            }
            if (mallOrderVo4.getGroups() != null) {
                for (MallGroupVO mallGroupVO : mallOrderVo4.getGroups()) {
                    if (mallGroupVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
                    mallGroupVO.setCouponAmount(mallGroupVO.getCouponAmount().add(diff_amount));
                    continue block0;
                }
                continue;
            }
            if (mallOrderVo4.getPromotions() == null) continue;
            for (MallPromotionVO mallPromotionVO : mallOrderVo4.getPromotions()) {
                if (mallPromotionVO.getUseCoupon().intValue() != MallCashUseStatusEnum.use.getValue()) continue;
                mallPromotionVO.setCouponAmount(mallPromotionVO.getCouponAmount().add(diff_amount));
                continue block0;
            }
        }
        this.logger.info(JSON.toJSONString(orderVos));
        if (rs.size() > 0) {
            Collections.sort(rs);
        } else if (jxbdz_fk) {
            rs = null;
        }
        return rs;
    }

    @Override
    public PageInfo getCashticketGetList(PageForm pageForm, String ticketBatchId, String ticketNo, Integer status) {
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        this.cashticketCustomerMapper.getCashticketGetList(ticketBatchId, ticketNo, status);
        PageInfo pg = page.toPageInfo();
        if (pg.getList() != null && pg.getList().size() > 0) {
            pg.getList().forEach(o -> {
                o.setCodeStatusName(CashStatusEnum.getName(o.getCodeStatus()));
                o.setCashStatusName(CashStatusEnum.getName(o.getCashStatus()));
            });
        }
        return pg;
    }

    @Override
    public boolean getCustomerBathStatus(String customerId, String ticketBatchId) {
        return true;
    }

    @Override
    public Boolean getCustomerHasTicket(String customerId, String ticketBatchId) {
        Integer hasAndUsedTicket = this.getCustomerHasAndUsedTicket(customerId, ticketBatchId);
        if (hasAndUsedTicket == 0) {
            return false;
        }
        return true;
    }

    @Override
    public Integer getCustomerHasAndUsedTicket(String customerId, String ticketBatchId) {
        CashticketCustomerEntity entity = new CashticketCustomerEntity();
        entity.setCustomerId(customerId);
        entity.setTicketBatchId(ticketBatchId);
        List entities = this.cashticketCustomerMapper.getList(entity);
        if (entities != null && entities.size() > 0) {
            if (((CashticketCustomerEntity)entities.get(0)).getStatus() == 1) {
                Date now = DateUtils.now();
                if (now.after(((CashticketCustomerEntity)entities.get(0)).getBeginTime()) && now.before(((CashticketCustomerEntity)entities.get(0)).getEndTime())) {
                    return 1;
                }
                return 3;
            }
            if (((CashticketCustomerEntity)entities.get(0)).getStatus() == 2) {
                return 2;
            }
        }
        return 0;
    }

    private CashticketVo getCashticketVo(CashticketSimpleVo simpleVo, boolean status, BigDecimal enableCashticketAmount) {
        CashticketVo vo = new CashticketVo();
        vo.setTicketCustomerId(simpleVo.getTicketCustomerId());
        vo.setTicketBatchName(simpleVo.getTicketBatchName());
        vo.setTimes(DateUtils.formatDate((Date)simpleVo.getBeginTime(), (String)"yyyy.MM.dd") + "-" + DateUtils.formatDate((Date)simpleVo.getEndTime(), (String)"yyyy.MM.dd"));
        vo.setEnable(this.getCashStatus(simpleVo, status));
        vo.setTicketAmount(simpleVo.getAmount());
        vo.setDiscountMode(simpleVo.getDiscountMode().shortValue());
        vo.setDiscountAmount(MathUtils.divBigDecimal((Number)simpleVo.getDiscountAmount(), (Number)10, (Integer)2));
        vo.setRemark(simpleVo.getRemark());
        vo.setEnableCashticketAmount(enableCashticketAmount);
        if (simpleVo.getDiscountMode().shortValue() == CashDiscountModeEnum.zhekou.getValue()) {
            vo.setTicketAmount(enableCashticketAmount);
        }
        return vo;
    }

    private int getCashStatus(CashticketSimpleVo simpleVo, boolean status) {
        if (status) {
            return CashStatusEnum.yijihuo.getValue();
        }
        if (simpleVo.getBatchStatus().intValue() == CashBathStatusEnum.jinyong.getValue()) {
            return CashStatusEnum.jinyong.getValue();
        }
        if (simpleVo.getTicketStatus().intValue() == CashStatusEnum.yishiyong.getValue()) {
            return CashStatusEnum.yishiyong.getValue();
        }
        return CashStatusEnum.guoqi.getValue();
    }

    private boolean getCashUseStatus(Map<Integer, CashticketBatchNewRuleVo> rule_map, String detail_id, int cash_rule_type, int platFormId, String bindCode) {
        if (rule_map != null && rule_map.size() > 0) {
            CashticketBatchNewRuleVo rule_vo;
            boolean flag = false;
            CashticketBatchNewRuleVo rule_plat_vo = rule_map.get(CashRuleTypeEnum.pingtai.getValue());
            if (rule_plat_vo != null) {
                if (rule_map.keySet().size() == 1) {
                    flag = true;
                }
                if (rule_plat_vo.getStats().intValue() != CashRuleStatusEnum.quanbu.getValue()) {
                    if (StringUtils.isEmpty((String)rule_plat_vo.getDetailIds())) {
                        return false;
                    }
                    List<String> rule_detail_list = Arrays.asList(rule_plat_vo.getDetailIds().split(","));
                    if (!rule_detail_list.contains(platFormId + "")) {
                        return false;
                    }
                }
            }
            if ((rule_vo = rule_map.get(cash_rule_type)) == null) {
                return flag;
            }
            if (rule_vo.getStats().intValue() != CashRuleStatusEnum.quanbu.getValue()) {
                if (StringUtils.isEmpty((String)rule_vo.getDetailIds())) {
                    return false;
                }
                List<String> rule_detail_list = Arrays.asList(rule_vo.getDetailIds().split(","));
                if (!rule_detail_list.contains(detail_id)) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public Integer getCashticketCount(String customerId, Integer enable) {
        return this.cashticketCustomerMapper.getCashticketCount(customerId, enable);
    }
}

