/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.cashticket;

import cc.lechun.common.enums.cashticket.CashRuleTypeEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.page.PageForm;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.cashticket.CashticketBatchNewRuleDetailMapper;
import cc.lechun.mall.dao.cashticket.CashticketBatchNewRuleMapper;
import cc.lechun.mall.entity.cashticket.CashticketBatchNewRuleDetailEntity;
import cc.lechun.mall.entity.cashticket.CashticketBatchNewRuleEntity;
import cc.lechun.mall.entity.cashticket.CashticketBatchNewRuleVo;
import cc.lechun.mall.entity.platform.PlatFormEntity;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductGroupEntity;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.form.cashticket.CashUseRuleForm;
import cc.lechun.mall.iservice.cashticket.cashticketBatchNewRuleInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.service.platform.PlatFormService;
import cc.lechun.mall.service.sales.MallGroupService;
import cc.lechun.mall.service.sales.MallPromotionService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class cashticketBatchNewRuleService
extends BaseService
implements cashticketBatchNewRuleInterface {
    @Autowired
    private CashticketBatchNewRuleDetailMapper cashticketBatchNewRuleDetailMapper;
    @Autowired
    private CashticketBatchNewRuleMapper cashticketBatchNewRuleMapper;
    @Autowired
    private MemcachedService memcachedService;
    @Autowired
    MallProductInterface productService;
    @Autowired
    private MallPromotionService mallPromotionService;
    @Autowired
    private MallGroupService mallGroupService;
    @Autowired
    private PlatFormService platFormService;

    @Override
    @ReadThroughSingleCache(namespace="getCashRule", expiration=7200)
    public List<CashticketBatchNewRuleVo> getCashRule(@ParameterValueKeyProvider String ticketBatchId) {
        return this.cashticketBatchNewRuleDetailMapper.getCashRuleList(ticketBatchId);
    }

    @Override
    public PageInfo getCashticketBatchUseRuleList(PageForm pageForm, String ticketBatchId) {
        Page page = PageHelper.startPage((int)pageForm.getCurrentPage(), (int)pageForm.getPageSize());
        this.cashticketBatchNewRuleDetailMapper.getCashRuleList(ticketBatchId);
        PageInfo pg = page.toPageInfo();
        if (pg.getList() != null && pg.getList().size() > 0) {
            pg.getList().forEach(cashticketBatchNewRuleVo -> {
                cashticketBatchNewRuleVo.setRuleTypeName(CashRuleTypeEnum.getName(cashticketBatchNewRuleVo.getRuleType()));
                cashticketBatchNewRuleVo.setDetailIdNames(this.getName(cashticketBatchNewRuleVo.getRuleType(), cashticketBatchNewRuleVo.getDetailIds()));
            });
        }
        return pg;
    }

    private String getName(Integer ruleType, String detailIds) {
        String detailIdNames;
        block6: {
            String[] detailIdss;
            block8: {
                block7: {
                    block5: {
                        if (StringUtils.isEmpty((String)detailIds)) {
                            return "";
                        }
                        detailIdss = detailIds.split(",");
                        detailIdNames = "";
                        if (ruleType.intValue() != CashRuleTypeEnum.danpin.getValue()) break block5;
                        MallProductEntity detail = null;
                        for (String str : detailIdss) {
                            detail = this.productService.getProduct(str);
                            if (detail == null) continue;
                            detailIdNames = detailIdNames + detail.getProName() + ",";
                        }
                        break block6;
                    }
                    if (ruleType.intValue() != CashRuleTypeEnum.cuxiao.getValue()) break block7;
                    MallPromotionEntity detail = null;
                    for (String str : detailIdss) {
                        detail = this.mallPromotionService.getPromotion(str);
                        if (detail == null) continue;
                        detailIdNames = detailIdNames + detail.getPromotionName() + ",";
                    }
                    break block6;
                }
                if (ruleType.intValue() != CashRuleTypeEnum.taozhuang.getValue()) break block8;
                MallProductGroupEntity detail = null;
                for (String str : detailIdss) {
                    detail = this.mallGroupService.getGroup(str);
                    if (detail == null) continue;
                    detailIdNames = detailIdNames + detail.getGroupName() + ",";
                }
                break block6;
            }
            if (ruleType.intValue() != CashRuleTypeEnum.pingtai.getValue()) break block6;
            PlatFormEntity detail = null;
            for (String str : detailIdss) {
                detail = this.platFormService.getPlatForm(Integer.parseInt(str));
                if (detail == null) continue;
                detailIdNames = detailIdNames + detail.getPlatformName() + ",";
            }
        }
        return detailIdNames;
    }

    @Override
    @Transactional
    public BaseJsonVo saveCashRule(CashUseRuleForm cashUseRuleForm) {
        CashticketBatchNewRuleEntity qpq = new CashticketBatchNewRuleEntity();
        qpq.setTicketBatchId(cashUseRuleForm.getTicketBatchId());
        qpq.setRuleType(cashUseRuleForm.getRuleType());
        List ls1 = this.cashticketBatchNewRuleMapper.getList(qpq);
        if (ls1 != null && ls1.size() > 0) {
            ls1.forEach(cashticketBatchNewRuleEntity -> this.deleteCashRule(cashticketBatchNewRuleEntity.getRuleId()));
        }
        CashticketBatchNewRuleEntity cashticketBatchNewRuleEntity2 = new CashticketBatchNewRuleEntity();
        cashticketBatchNewRuleEntity2.setCreateTime(DateUtils.now());
        cashticketBatchNewRuleEntity2.setRuleType(cashUseRuleForm.getRuleType());
        cashticketBatchNewRuleEntity2.setStats(cashUseRuleForm.getStats());
        cashticketBatchNewRuleEntity2.setTicketBatchId(cashUseRuleForm.getTicketBatchId());
        this.cashticketBatchNewRuleMapper.saveCashticketBatchNewRule(cashticketBatchNewRuleEntity2);
        if (cashUseRuleForm.getDetailIds() != null && cashUseRuleForm.getDetailIds().size() > 0) {
            cashUseRuleForm.getDetailIds().forEach(s -> {
                CashticketBatchNewRuleDetailEntity m = new CashticketBatchNewRuleDetailEntity();
                m.setCreateTime(DateUtils.now());
                m.setRuleId(cashticketBatchNewRuleEntity2.getRuleId());
                m.setDetailId((String)s);
                this.cashticketBatchNewRuleDetailMapper.insertSelective(m);
            });
        }
        this.removeCache(cashUseRuleForm.getTicketBatchId());
        return BaseJsonVo.success((Object)"");
    }

    @Override
    @Transactional
    public BaseJsonVo deleteCashRule(Long ruleId) {
        CashticketBatchNewRuleEntity cashticketBatchNewRuleEntity = (CashticketBatchNewRuleEntity)this.cashticketBatchNewRuleMapper.selectByPrimaryKey(ruleId);
        if (cashticketBatchNewRuleEntity != null) {
            this.removeCache(cashticketBatchNewRuleEntity.getTicketBatchId());
            this.cashticketBatchNewRuleMapper.deleteByPrimaryKey(ruleId);
            CashticketBatchNewRuleDetailEntity qpc = new CashticketBatchNewRuleDetailEntity();
            qpc.setRuleId(cashticketBatchNewRuleEntity.getRuleId());
            List ls = this.cashticketBatchNewRuleDetailMapper.getList(qpc);
            if (ls != null && ls.size() > 0) {
                ls.forEach(cashticketBatchNewRuleDetailEntity -> this.cashticketBatchNewRuleDetailMapper.deleteByPrimaryKey(cashticketBatchNewRuleDetailEntity.getId()));
            }
        }
        return BaseJsonVo.success((Object)"");
    }

    private void removeCache(String ticketBatchId) {
        this.memcachedService.delete("getCashRule", ticketBatchId);
    }
}

