/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.jms;

import cc.lechun.active.iservice.active.ActiveCommonInterface;
import cc.lechun.active.service.sales.ActiveSaleContext;
import cc.lechun.active.service.sales.ActiveSaleHandle;
import cc.lechun.common.cache.RedisService;
import cc.lechun.common.enums.sync.DataSyncTypeEnum;
import cc.lechun.common.enums.trade.OrderClassEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.mall.entity.customer.CustomerEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.iservice.customer.CustomerInterface;
import cc.lechun.mall.iservice.jms.MessageQueueInterface;
import cc.lechun.mall.iservice.sync.MallDataSyncInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderMessageInterface;
import com.aliyun.openservices.ons.api.ConsumeContext;
import com.aliyun.openservices.ons.api.Message;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="orderPay")
public class OrderPayListener
implements MessageQueueInterface {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MallOrderMainInterface orderMainInterface;
    @Autowired
    private CustomerInterface customerInterface;
    @Autowired
    private ActiveCommonInterface activeCommonService;
    @Autowired
    private ActiveSaleContext activeContext;
    @Autowired
    private MallDataSyncInterface syncInterface;
    @Autowired
    private RedisService redisService;
    @Autowired
    private MallOrderMessageInterface orderMessageInterface;

    @Override
    public boolean receive(Message message, ConsumeContext context) {
        try {
            Map param = (Map)ObjectConvert.toObject((byte[])message.getBody());
            String orderMainNo = param.get("orderMainNo").toString();
            this.log.info("\u63a5\u6536\u8ba2\u5355\u6d88\u606f...." + orderMainNo);
            MallOrderMainEntity orderMainEntity = this.orderMainInterface.selectByPrimaryKey(orderMainNo);
            boolean setResult = this.redisService.sadd(DateUtils.date().toString() + ":ActiveOrder", orderMainEntity.getOrderMainNo());
            if (setResult) {
                ActiveSaleHandle activeHandle;
                Integer activeType = Integer.valueOf(param.get("activeType").toString());
                if (activeType != null && activeType >= 1 && (activeHandle = this.activeContext.getActiveHanle(String.valueOf(activeType))) != null) {
                    activeHandle.afterPay(orderMainEntity);
                }
                this.activeCommonService.pushActiveMessage(orderMainEntity);
            }
            if (orderMainEntity.getOrderClass().intValue() == OrderClassEnum.MALL_ORDER.getValue() || orderMainEntity.getOrderClass().intValue() == OrderClassEnum.GIFTCARD_ORDER.getValue()) {
                CustomerEntity customerEntity = new CustomerEntity();
                customerEntity.setIsNew(0);
                if (customerEntity.getFirstOrderTime() == null) {
                    customerEntity.setFirstOrderTime(orderMainEntity.getCreateTime());
                }
                customerEntity.setCustomerId(param.get("userId").toString());
                this.customerInterface.updateCustomerEntitySelective(customerEntity);
            }
            this.syncInterface.producerData(orderMainNo, DataSyncTypeEnum.BI_MAIN_ORDER, "orderPay");
            this.orderMessageInterface.sendOrderPaySuccessTextMessage(orderMainEntity);
            this.log.info("\u6d88\u8d39\u5b8c\u8ba2\u5355\u6d88\u606f....\u8ba2\u5355\u53f7:" + orderMainEntity.getOrderMainNo());
        }
        catch (Exception e) {
            this.log.error("\u8ba2\u5355\u6d88\u606f\u5904\u7406\u5931\u8d25" + message.getMsgID(), (Throwable)e);
        }
        return true;
    }
}

