/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.pay.bankpay;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.math.PriceUtils;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.sign.MD5;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.mall.entity.pay.PayInputEntity;
import cc.lechun.mall.service.pay.bankpay.entity.BankPayInfo;
import cc.lechun.mall.service.pay.wechatpay.WechatPayCommon;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class CMBBankPayComon {
    public static final String UTF8 = "UTF-8";

    public static Map<String, Object> createBankPayInfo(PayInputEntity inputEntity) {
        HashMap<String, Object> bankPayMap = new HashMap<String, Object>();
        try {
            bankPayMap.put("appId", inputEntity.getPayKey());
            bankPayMap.put("funcode", "WP001");
            bankPayMap.put("version", "1.0.0");
            bankPayMap.put("mhtOrderNo", inputEntity.getTradeNo());
            bankPayMap.put("mhtOrderName", inputEntity.getBody());
            bankPayMap.put("mhtOrderType", "05");
            bankPayMap.put("mhtCurrencyType", "156");
            bankPayMap.put("mhtOrderAmt", PriceUtils.multiply((BigDecimal)inputEntity.getPayAmount(), (Integer)100).intValue());
            bankPayMap.put("mhtOrderDetail", inputEntity.getBody());
            bankPayMap.put("mhtOrderTimeOut", inputEntity.getTimeOut());
            bankPayMap.put("mhtOrderStartTime", DateUtils.formatDate((Date)inputEntity.getOrderCreateTime(), (String)"yyyyMMddHHmmss"));
            bankPayMap.put("notifyUrl", inputEntity.getNotifyUrl());
            if ("JSAPI".equals(inputEntity.getTradeType())) {
                bankPayMap.put("deviceType", "0600");
            }
            bankPayMap.put("mhtCharset", inputEntity.getCharset());
            bankPayMap.put("payChannelType", "13");
            bankPayMap.put("outputType", "1");
            bankPayMap.put("mhtSubAppId", inputEntity.getAppId());
            bankPayMap.put("consumerId", inputEntity.getOpenId());
            bankPayMap.put("mhtLimitPay", "0");
            bankPayMap.put("mhtSignType", inputEntity.getSignType());
            String mhtSignature = CMBBankPayComon.getFormDataParamMD5(bankPayMap, inputEntity.getPublicKey(), UTF8);
            bankPayMap.put("appId", URLEncoder.encode(inputEntity.getPayKey(), UTF8));
            bankPayMap.put("funcode", URLEncoder.encode("WP001", UTF8));
            bankPayMap.put("version", URLEncoder.encode("1.0.0", UTF8));
            bankPayMap.put("mhtOrderNo", URLEncoder.encode(inputEntity.getTradeNo(), UTF8));
            bankPayMap.put("mhtOrderName", URLEncoder.encode(inputEntity.getBody(), UTF8));
            bankPayMap.put("mhtOrderType", URLEncoder.encode("05", UTF8));
            bankPayMap.put("mhtCurrencyType", URLEncoder.encode("156", UTF8));
            bankPayMap.put("mhtOrderAmt", URLEncoder.encode(String.valueOf(PriceUtils.multiply((BigDecimal)inputEntity.getPayAmount(), (Integer)100).intValue()), UTF8));
            bankPayMap.put("mhtOrderDetail", URLEncoder.encode(inputEntity.getBody(), UTF8));
            bankPayMap.put("mhtOrderTimeOut", URLEncoder.encode(String.valueOf(inputEntity.getTimeOut()), UTF8));
            bankPayMap.put("mhtOrderStartTime", URLEncoder.encode(DateUtils.formatDate((Date)inputEntity.getOrderCreateTime(), (String)"yyyyMMddHHmmss"), UTF8));
            bankPayMap.put("notifyUrl", URLEncoder.encode(inputEntity.getNotifyUrl(), UTF8));
            if ("JSAPI".equals(inputEntity.getTradeType())) {
                bankPayMap.put("deviceType", URLEncoder.encode("0600", UTF8));
            }
            bankPayMap.put("mhtCharset", URLEncoder.encode(inputEntity.getCharset(), UTF8));
            bankPayMap.put("payChannelType", URLEncoder.encode("13", UTF8));
            bankPayMap.put("outputType", URLEncoder.encode("1", UTF8));
            bankPayMap.put("mhtSubAppId", URLEncoder.encode(inputEntity.getAppId(), UTF8));
            bankPayMap.put("consumerId", URLEncoder.encode(inputEntity.getOpenId(), UTF8));
            bankPayMap.put("mhtLimitPay", URLEncoder.encode("0", UTF8));
            bankPayMap.put("mhtSignType", URLEncoder.encode(inputEntity.getSignType(), UTF8));
            bankPayMap.put("mhtSignature", URLEncoder.encode(mhtSignature, UTF8));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bankPayMap;
    }

    public static Map<String, Object> bankPaySearch(PayInputEntity inputEntity) {
        HashMap<String, Object> bankPaySearchMap = new HashMap<String, Object>();
        try {
            bankPaySearchMap.put("funcode", "MQ002");
            bankPaySearchMap.put("version", "1.0.0");
            if ("JSAPI".equals(inputEntity.getTradeType())) {
                bankPaySearchMap.put("deviceType", "0600");
            }
            bankPaySearchMap.put("appId", inputEntity.getPayKey());
            bankPaySearchMap.put("mhtOrderNo", inputEntity.getTradeNo());
            bankPaySearchMap.put("mhtCharset", inputEntity.getCharset());
            bankPaySearchMap.put("mhtSignType", inputEntity.getSignType());
            String mhtSignature = CMBBankPayComon.getFormDataParamMD5(bankPaySearchMap, inputEntity.getPublicKey(), UTF8);
            bankPaySearchMap.put("funcode", URLEncoder.encode("MQ002", UTF8));
            bankPaySearchMap.put("version", URLEncoder.encode("1.0.0", UTF8));
            if ("JSAPI".equals(inputEntity.getTradeType())) {
                bankPaySearchMap.put("deviceType", URLEncoder.encode("0600", UTF8));
            }
            bankPaySearchMap.put("appId", URLEncoder.encode(inputEntity.getPayKey(), UTF8));
            bankPaySearchMap.put("mhtOrderNo", URLEncoder.encode(inputEntity.getTradeNo(), UTF8));
            bankPaySearchMap.put("mhtCharset", URLEncoder.encode(inputEntity.getCharset(), UTF8));
            bankPaySearchMap.put("mhtSignType", URLEncoder.encode(inputEntity.getSignType(), UTF8));
            bankPaySearchMap.put("mhtSignature", URLEncoder.encode(mhtSignature, UTF8));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bankPaySearchMap;
    }

    public static Map<String, Object> createBankRefundInfo(PayInputEntity inputEntity) {
        HashMap<String, Object> bankRefundMap = new HashMap<String, Object>();
        try {
            bankRefundMap.put("amount", PriceUtils.multiply((BigDecimal)inputEntity.getRefundAmount(), (Integer)100).intValue());
            bankRefundMap.put("appId", inputEntity.getPayKey());
            bankRefundMap.put("funcode", "R001");
            bankRefundMap.put("mhtCharset", inputEntity.getCharset());
            bankRefundMap.put("mhtOrderNo", inputEntity.getTradeNo());
            bankRefundMap.put("mhtRefundNo", inputEntity.getRefundBillNo());
            String mhtSignature = CMBBankPayComon.getFormDataParamMD5(bankRefundMap, inputEntity.getPublicKey(), UTF8);
            bankRefundMap.put("amount", URLEncoder.encode(String.valueOf(PriceUtils.multiply((BigDecimal)inputEntity.getRefundAmount(), (Integer)100).intValue()), UTF8));
            bankRefundMap.put("appId", URLEncoder.encode(inputEntity.getPayKey(), UTF8));
            bankRefundMap.put("funcode", URLEncoder.encode("R001", UTF8));
            bankRefundMap.put("mhtCharset", URLEncoder.encode(inputEntity.getCharset(), UTF8));
            bankRefundMap.put("mhtOrderNo", URLEncoder.encode(inputEntity.getTradeNo(), UTF8));
            bankRefundMap.put("mhtRefundNo", URLEncoder.encode(inputEntity.getRefundBillNo(), UTF8));
            bankRefundMap.put("signType", URLEncoder.encode(inputEntity.getSignType(), UTF8));
            bankRefundMap.put("mhtSignature", URLEncoder.encode(mhtSignature, UTF8));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bankRefundMap;
    }

    public static Map<String, Object> bankRefundQuery(PayInputEntity inputEntity) {
        HashMap<String, Object> bankRefundQueryMap = new HashMap<String, Object>();
        try {
            bankRefundQueryMap.put("funcode", "Q001");
            bankRefundQueryMap.put("appId", inputEntity.getPayKey());
            bankRefundQueryMap.put("mhtRefundNo", inputEntity.getRefundBillNo());
            bankRefundQueryMap.put("mhtCharset", inputEntity.getCharset());
            String mhtSignature = CMBBankPayComon.getFormDataParamMD5(bankRefundQueryMap, inputEntity.getPublicKey(), UTF8);
            bankRefundQueryMap.put("funcode", URLEncoder.encode("Q001", UTF8));
            bankRefundQueryMap.put("appId", URLEncoder.encode(inputEntity.getPayKey(), UTF8));
            bankRefundQueryMap.put("mhtRefundNo", URLEncoder.encode(inputEntity.getRefundBillNo(), UTF8));
            bankRefundQueryMap.put("mhtCharset", URLEncoder.encode(inputEntity.getCharset(), UTF8));
            bankRefundQueryMap.put("signType", URLEncoder.encode(inputEntity.getSignType(), UTF8));
            bankRefundQueryMap.put("mhtSignature", URLEncoder.encode(mhtSignature, UTF8));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bankRefundQueryMap;
    }

    public static Map<String, Object> createBankRefundOrder(PayInputEntity inputEntity) {
        HashMap<String, Object> bankRefundOrderMap = new HashMap<String, Object>();
        try {
            bankRefundOrderMap.put("funcode", "R002");
            bankRefundOrderMap.put("appId", inputEntity.getPayKey());
            bankRefundOrderMap.put("reason", "\u8ba2\u5355\u53d6\u6d88");
            bankRefundOrderMap.put("mhtCharset", inputEntity.getCharset());
            bankRefundOrderMap.put("mhtOrderNo", inputEntity.getTradeNo());
            bankRefundOrderMap.put("mhtRefundNo", inputEntity.getRefundBillNo());
            String mhtSignature = CMBBankPayComon.getFormDataParamMD5(bankRefundOrderMap, inputEntity.getPublicKey(), UTF8);
            bankRefundOrderMap.put("appId", URLEncoder.encode(inputEntity.getPayKey(), UTF8));
            bankRefundOrderMap.put("funcode", URLEncoder.encode("R002", UTF8));
            bankRefundOrderMap.put("mhtCharset", URLEncoder.encode(inputEntity.getCharset(), UTF8));
            bankRefundOrderMap.put("reason", URLEncoder.encode("\u8ba2\u5355\u53d6\u6d88", UTF8));
            bankRefundOrderMap.put("mhtOrderNo", URLEncoder.encode(inputEntity.getTradeNo(), UTF8));
            bankRefundOrderMap.put("mhtRefundNo", URLEncoder.encode(inputEntity.getRefundBillNo(), UTF8));
            bankRefundOrderMap.put("signType", URLEncoder.encode(inputEntity.getSignType(), UTF8));
            bankRefundOrderMap.put("mhtSignature", URLEncoder.encode(mhtSignature, UTF8));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bankRefundOrderMap;
    }

    public static Map<String, Object> refundQuery(PayInputEntity inputEntity) {
        HashMap<String, Object> refundQueryMap = new HashMap<String, Object>();
        try {
            refundQueryMap.put("funcode", "Q002");
            refundQueryMap.put("appId", inputEntity.getPayKey());
            refundQueryMap.put("mhtRefundNo", inputEntity.getRefundBillNo());
            refundQueryMap.put("mhtCharset", inputEntity.getCharset());
            String mhtSignature = CMBBankPayComon.getFormDataParamMD5(refundQueryMap, inputEntity.getPublicKey(), UTF8);
            refundQueryMap.put("funcode", URLEncoder.encode("Q002", UTF8));
            refundQueryMap.put("appId", URLEncoder.encode(inputEntity.getPayKey(), UTF8));
            refundQueryMap.put("mhtRefundNo", URLEncoder.encode(inputEntity.getRefundBillNo(), UTF8));
            refundQueryMap.put("mhtCharset", URLEncoder.encode(inputEntity.getCharset(), UTF8));
            refundQueryMap.put("signType", URLEncoder.encode(inputEntity.getSignType(), UTF8));
            refundQueryMap.put("mhtSignature", URLEncoder.encode(mhtSignature, UTF8));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return refundQueryMap;
    }

    public static Map<String, String> getBillToken(PayInputEntity inputEntity) {
        HashMap<String, Object> billTokenMap = new HashMap<String, Object>();
        HashMap<String, String> billTokenRetrunMap = new HashMap<String, String>();
        try {
            billTokenMap.put("version", "1.0.0");
            billTokenMap.put("mhtAcc", inputEntity.getSellerEmail());
            billTokenMap.put("mchId", inputEntity.getMchId());
            billTokenMap.put("tokenTime", "3600");
            billTokenMap.put("timestamp", Long.toString(System.currentTimeMillis() / 1000L));
            billTokenMap.put("mhtCharset", inputEntity.getCharset());
            String mhtSignature = CMBBankPayComon.getFormDataParamMD5(billTokenMap, "MFMvceCEBp76iEXYf3jFwlqnZblVRo4n", UTF8);
            billTokenRetrunMap.put("version", "1.0.0");
            billTokenRetrunMap.put("mhtAcc", inputEntity.getSellerEmail());
            billTokenRetrunMap.put("mchId", inputEntity.getMchId());
            billTokenRetrunMap.put("tokenTime", "3600");
            billTokenRetrunMap.put("timestamp", Long.toString(System.currentTimeMillis() / 1000L));
            billTokenRetrunMap.put("mhtCharset", inputEntity.getCharset());
            billTokenRetrunMap.put("mhtSignType", inputEntity.getSignType());
            billTokenRetrunMap.put("mhtSignature", mhtSignature);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return billTokenRetrunMap;
    }

    public static Map<String, String> getBillInfo(PayInputEntity inputEntity, String accessToken, String billType) {
        HashMap<String, Object> billInfoMap = new HashMap<String, Object>();
        HashMap<String, String> billInfoReturnMap = new HashMap<String, String>();
        try {
            billInfoMap.put("version", "1.0.0");
            billInfoMap.put("mchId", inputEntity.getMchId());
            billInfoMap.put("billType", billType);
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
            Date date = DateUtils.getAddDateByDay((Date)new Date(), (int)-1);
            if (inputEntity.getOrderCreateTime() != null) {
                date = DateUtils.getAddDateByDay((Date)inputEntity.getOrderCreateTime(), (int)0);
            }
            String dateStr = format.format(date);
            billInfoMap.put("billDate", dateStr);
            billInfoMap.put("accessToken", accessToken);
            billInfoMap.put("timestamp", Long.toString(System.currentTimeMillis() / 1000L));
            billInfoMap.put("mhtCharset", inputEntity.getCharset());
            String mhtSignature = CMBBankPayComon.getFormDataParamMD5(billInfoMap, "MFMvceCEBp76iEXYf3jFwlqnZblVRo4n", UTF8);
            billInfoReturnMap.put("version", "1.0.0");
            billInfoReturnMap.put("mchId", inputEntity.getMchId());
            billInfoReturnMap.put("billType", billType);
            billInfoReturnMap.put("billDate", dateStr);
            billInfoReturnMap.put("accessToken", accessToken);
            billInfoReturnMap.put("timestamp", Long.toString(System.currentTimeMillis() / 1000L));
            billInfoReturnMap.put("mhtCharset", inputEntity.getCharset());
            billInfoReturnMap.put("mhtSignType", inputEntity.getSignType());
            billInfoReturnMap.put("mhtSignature", mhtSignature);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return billInfoReturnMap;
    }

    public static Map<String, String> downloadBill(PayInputEntity inputEntity, BaseJsonVo result) {
        Map resultMap = (Map)result.getValue();
        HashMap<String, Object> downloadBillMap = new HashMap<String, Object>();
        HashMap<String, String> downloadBillReturnMap = new HashMap<String, String>();
        try {
            downloadBillMap.put("version", "1.0.0");
            downloadBillMap.put("mchId", inputEntity.getMchId());
            downloadBillMap.put("magzineId", resultMap.get("magzineId").toString());
            downloadBillMap.put("accessToken", resultMap.get("accessToken").toString());
            downloadBillMap.put("timestamp", Long.toString(System.currentTimeMillis() / 1000L));
            downloadBillMap.put("mhtCharset", inputEntity.getCharset());
            String mhtSignature = CMBBankPayComon.getFormDataParamMD5(downloadBillMap, "MFMvceCEBp76iEXYf3jFwlqnZblVRo4n", UTF8);
            downloadBillReturnMap.put("version", "1.0.0");
            downloadBillReturnMap.put("mchId", inputEntity.getMchId());
            downloadBillReturnMap.put("magzineId", resultMap.get("magzineId").toString());
            downloadBillReturnMap.put("accessToken", resultMap.get("accessToken").toString());
            downloadBillReturnMap.put("timestamp", Long.toString(System.currentTimeMillis() / 1000L));
            downloadBillReturnMap.put("mhtCharset", inputEntity.getCharset());
            downloadBillReturnMap.put("mhtSignType", inputEntity.getSignType());
            downloadBillReturnMap.put("mhtSignature", mhtSignature);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return downloadBillReturnMap;
    }

    public static String getFormDataParamMD5(Map<String, Object> dataMap, String securityKey, String charset) {
        if (dataMap == null) {
            return null;
        }
        Set<String> keySet = dataMap.keySet();
        ArrayList<String> keyList = new ArrayList<String>(keySet);
        Collections.sort(keyList);
        StringBuilder sbByMD5 = new StringBuilder();
        for (String key : keyList) {
            Object value = dataMap.get(key);
            if (value == null) continue;
            sbByMD5.append(key + "=" + value + "&");
        }
        try {
            String securityKeyMD5 = MD5.md5((String)securityKey, (String)charset);
            sbByMD5.append(securityKeyMD5);
            String sbByMD5Str = sbByMD5.toString();
            System.out.println("\u5f85MD5\u7b7e\u540d\u5b57\u7b26\u4e32\uff1a" + sbByMD5Str);
            String lastMD5Result = MD5.md5((String)sbByMD5Str, (String)charset);
            System.out.println("MD5\u7b7e\u540d\u540e\u5b57\u7b26\u4e32:" + lastMD5Result);
            return lastMD5Result;
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static String getNamValStr(Map<String, Object> map) {
        StringBuilder str = new StringBuilder();
        Set<String> set = map.keySet();
        for (String key : set) {
            str.append(key).append("=").append(map.get(key).toString()).append("&");
        }
        return str.toString().substring(0, str.lastIndexOf("&"));
    }

    public static String getCreateSign(BankPayInfo bankPayInfo) {
        SortedMap map = ObjectConvert.objectConvertToSortedMap((Object)bankPayInfo);
        return WechatPayCommon.createSign(map, bankPayInfo.getPayKey());
    }
}

