/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.pay.bill.bankBill;

import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.bill.MallBillInfoMapper;
import cc.lechun.mall.dao.bill.MallBillResultMapper;
import cc.lechun.mall.dao.trade.MallOrderPayMapper;
import cc.lechun.mall.dao.trade.MallRefundRecordMapper;
import cc.lechun.mall.entity.bill.MallBillInfoEntity;
import cc.lechun.mall.entity.bill.MallBillInfoVo;
import cc.lechun.mall.entity.bill.MallBillResultEntity;
import cc.lechun.mall.entity.bill.MallBillResultVo;
import cc.lechun.mall.entity.pay.PayInputEntity;
import cc.lechun.mall.entity.trade.MallOrderPayVo;
import cc.lechun.mall.entity.trade.MallPayTypeEntity;
import cc.lechun.mall.entity.trade.MallPlatformPayTypeEntity;
import cc.lechun.mall.entity.trade.MallRefundPayDetailVo;
import cc.lechun.mall.iservice.bill.MallBillResultInterface;
import cc.lechun.mall.iservice.trade.MallPayTypeInterface;
import cc.lechun.mall.iservice.trade.MallPlatformPayTypeInterface;
import cc.lechun.mall.service.pay.bankpay.CMBBankPayComon;
import cc.lechun.utils.HttpClientUtil;
import com.alibaba.fastjson.JSON;
import com.csvreader.CsvReader;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.ListUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CMBBankBillService
extends BaseService {
    @Value(value="${file.pathUrl}")
    private String filePathUrl;
    @Autowired
    private MallBillInfoMapper mallBillInfoMapper;
    @Autowired
    private MallOrderPayMapper mallOrderPayMapper;
    @Autowired
    private MallBillResultMapper mallBillResultMapper;
    @Autowired
    private MallRefundRecordMapper mallRefundRecordMapper;
    @Autowired
    private MallPayTypeInterface payTypeInterface;
    @Autowired
    private MallPlatformPayTypeInterface mallPlatformPayTypeInterface;
    @Autowired
    private MallBillResultInterface mallBillResultInterface;

    public PageInfo getOrderBillInfo(int currentPage, int pageSize, MallBillResultVo mallBillResultVo) {
        Page page = PageHelper.startPage((int)currentPage, (int)pageSize);
        List<MallBillResultEntity> mallBillResultEntityList = this.mallBillResultMapper.getBillResultByParma(mallBillResultVo);
        PageInfo pg = page.toPageInfo();
        pg.setList(mallBillResultEntityList);
        return pg;
    }

    public BaseJsonVo getBillToken(PayInputEntity inputEntity) {
        BaseJsonVo result = new BaseJsonVo();
        String billTokenUrl = "https://mch.aggreg.cmbchina.com/clond_bill/service/bill01.do";
        Map<String, String> resultMap = CMBBankPayComon.getBillToken(inputEntity);
        this.logger.info("------cc.lechun.mall.service.pay.bill.bankBill.getBillToken-------resultMap={}", resultMap);
        try {
            String billTokenResult = HttpClientUtil.sendHttp(billTokenUrl, resultMap, "UTF-8");
            this.logger.info("=========cc.lechun.mall.service.pay.bill.bankBill.getBillToken=======billTokenResult={}", (Object)URLDecoder.decode(billTokenResult, "UTF-8"));
            String[] billTokenList = billTokenResult.split("&");
            HashMap<String, String> map = new HashMap<String, String>();
            for (String s : billTokenList) {
                int index = s.indexOf("=");
                String key = s.substring(0, index);
                String value = s.substring(index + 1);
                map.put(key, value);
            }
            this.logger.info("-=-=-=-=-=-=-=-cc.lechun.mall.service.pay.bill.bankBill.getBillToken.map-=-=-=-=-=-=-=map={}", (Object)URLDecoder.decode(JSON.toJSONString(map), "UTF-8"));
            if (map != null) {
                if ("A001".equals(map.get("responseCode").toString())) {
                    result.setValue(map);
                    return result;
                }
                result.setError("\u83b7\u53d6Token\u5931\u8d25");
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public BaseJsonVo getBillInfo(PayInputEntity inputEntity, String billType) {
        BaseJsonVo result = new BaseJsonVo();
        String billInfoUrl = "https://mch.aggreg.cmbchina.com/clond_bill/service/bill02.do";
        result = this.getBillToken(inputEntity);
        if (result.isSuccess()) {
            Map resultMap = (Map)result.getValue();
            String accessToken = resultMap.get("accessToken").toString();
            Map<String, String> billInfoResultMap = CMBBankPayComon.getBillInfo(inputEntity, accessToken, billType);
            this.logger.info("------cc.lechun.mall.service.pay.bill.bankBill.getBillInfo-------billInfoResultMap={}", billInfoResultMap);
            try {
                String billInfoResult = HttpClientUtil.sendHttp(billInfoUrl, billInfoResultMap, "UTF-8");
                this.logger.info("=========cc.lechun.mall.service.pay.bill.bankBill.getBillInfo=======billInfoResult={}", (Object)URLDecoder.decode(billInfoResult, "UTF-8"));
                String[] billInfoList = billInfoResult.split("&");
                HashMap<String, String> map = new HashMap<String, String>();
                for (String s : billInfoList) {
                    int index = s.indexOf("=");
                    String key = s.substring(0, index);
                    String value = s.substring(index + 1);
                    map.put(key, value);
                }
                this.logger.info("-=-=-=-=-=-=-=-cc.lechun.mall.service.pay.bill.bankBill.getBillInfo.map-=-=-=-=-=-=-=map={}", (Object)URLDecoder.decode(JSON.toJSONString(map), "UTF-8"));
                if (map != null) {
                    if ("A001".equals(map.get("responseCode").toString())) {
                        result.setValue(map);
                        return result;
                    }
                    result.setError("\u83b7\u53d6\u8d26\u5355\u6458\u8981\u4fe1\u606f\u5931\u8d25");
                    return result;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return result;
        }
        return result;
    }

    public BaseJsonVo downloadBill(PayInputEntity inputEntity, String billType) {
        BaseJsonVo result = new BaseJsonVo();
        String downloadBillUrl = "https://mch.aggreg.cmbchina.com/clond_bill/service/bill03.do";
        result = this.getBillInfo(inputEntity, billType);
        if (result.isSuccess()) {
            Map resultMap = (Map)result.getValue();
            Map<String, String> downloadBillResultMap = CMBBankPayComon.downloadBill(inputEntity, result);
            this.logger.info("------cc.lechun.mall.service.pay.bill.bankBill.downloadBill-------downloadBillResultMap={}", downloadBillResultMap);
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
                Date date = DateUtils.getAddDateByDay((Date)new Date(), (int)-1);
                if (inputEntity.getOrderCreateTime() != null) {
                    date = DateUtils.getAddDateByDay((Date)inputEntity.getOrderCreateTime(), (int)0);
                }
                String dateStr = format.format(date);
                String fileName = "\u62db\u5546\u5bf9\u8d26\u5355" + dateStr + ".zip";
                String response = HttpClientUtil.sendHttp(downloadBillUrl, downloadBillResultMap, "UTF-8", fileName);
                this.logger.info("------cc.lechun.mall.service.pay.bill.bankBill.downloadBill-------response={}", (Object)URLDecoder.decode(response), (Object)"UTF-8");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return result;
        }
        return result;
    }

    public int downloadUnzip(String billType, MallBillResultVo mallBillResultVo) {
        int i = 0;
        int payTypeSubId = 0;
        MallPayTypeEntity mallPayTypeEntity = this.payTypeInterface.getDefaultPayType();
        if (mallPayTypeEntity != null) {
            payTypeSubId = mallPayTypeEntity.getPaytypeId();
        }
        MallPlatformPayTypeEntity platformPayTypeEntity = this.mallPlatformPayTypeInterface.getEntityByPlatIdAndPayTypeSubId(1, payTypeSubId);
        PayInputEntity pe = new PayInputEntity();
        if (platformPayTypeEntity != null) {
            BaseJsonVo baseJsonVo = new BaseJsonVo();
            pe.setPayKey(platformPayTypeEntity.getPayKey());
            pe.setAppId(platformPayTypeEntity.getAppid());
            pe.setBody(platformPayTypeEntity.getBody());
            pe.setMchId(platformPayTypeEntity.getMchId());
            pe.setTradeType(platformPayTypeEntity.getTradeType());
            pe.setDomain(platformPayTypeEntity.getDomain());
            pe.setAppName(platformPayTypeEntity.getAppName());
            pe.setPublicKey(platformPayTypeEntity.getPublicKey());
            pe.setRequestDomain(platformPayTypeEntity.getRequestDomain());
            pe.setCharset(platformPayTypeEntity.getCharset());
            pe.setSignType(platformPayTypeEntity.getSignType());
            pe.setReturnUrl(platformPayTypeEntity.getReturnUrl());
            pe.setNotifyUrl(platformPayTypeEntity.getNotifyUrl());
            pe.setSellerEmail(platformPayTypeEntity.getSellerEmail());
            pe.setDataFormat(platformPayTypeEntity.getDataFormat());
            pe.setTimeOut(platformPayTypeEntity.getTimeout());
            pe.setRefundCertFile(platformPayTypeEntity.getRefundCertFile());
            if (mallBillResultVo != null && mallBillResultVo.getCreateTime() != null) {
                pe.setOrderCreateTime(mallBillResultVo.getCreateTime());
            }
            if (!(baseJsonVo = this.downloadBill(pe, billType)).isSuccess()) {
                return i;
            }
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
            Date date = DateUtils.getAddDateByDay((Date)new Date(), (int)-1);
            if (pe.getOrderCreateTime() != null) {
                date = DateUtils.getAddDateByDay((Date)pe.getOrderCreateTime(), (int)0);
            }
            String dateStr = format.format(date);
            String fileName = "\u62db\u5546\u5bf9\u8d26\u5355" + dateStr + ".zip";
            String pathName = this.filePathUrl + fileName;
            File storeFile = new File(pathName);
            i = this.unZip(storeFile, this.filePathUrl, pe.getOrderCreateTime());
        }
        return i;
    }

    public int unZip(File srcFile, String destDirPath, Date date) throws RuntimeException {
        int i = 0;
        long start = System.currentTimeMillis();
        if (!srcFile.exists()) {
            throw new RuntimeException(srcFile.getPath() + "\u6240\u6307\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(srcFile, "GBK");
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                int len;
                ZipEntry entry = (ZipEntry)entries.nextElement();
                System.out.println("\u89e3\u538b" + entry.getName());
                if (entry.isDirectory()) {
                    String dirPath = destDirPath + "/" + entry.getName();
                    File dir = new File(dirPath);
                    dir.mkdirs();
                    continue;
                }
                File targetFile = new File(destDirPath + entry.getName());
                if (!targetFile.getParentFile().exists()) {
                    targetFile.getParentFile().mkdirs();
                }
                targetFile.createNewFile();
                InputStream is = zipFile.getInputStream(entry);
                FileOutputStream fos = new FileOutputStream(targetFile);
                byte[] buf = new byte[1024];
                while ((len = is.read(buf)) != -1) {
                    fos.write(buf, 0, len);
                }
                fos.close();
                is.close();
            }
            i = this.readCsv(date);
            long end = System.currentTimeMillis();
            System.out.println("\u89e3\u538b\u5b8c\u6210\uff0c\u8017\u65f6\uff1a" + (end - start) + " ms");
        }
        catch (Exception e) {
            throw new RuntimeException("unzip error from ZipUtils", e);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return i;
    }

    public int readCsv(Date date) {
        int i = 0;
        SimpleDateFormat sdFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date dateFormat = DateUtils.getAddDateByDay((Date)new Date(), (int)-1);
        if (date != null) {
            dateFormat = date;
        }
        String dateFormatStr = sdFormat.format(dateFormat);
        String srcPath = this.filePathUrl + dateFormatStr + ".csv";
        String charset = "GBK";
        Object file = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(srcPath);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, charset);
            ArrayList<String[]> csvList = new ArrayList<String[]>();
            CsvReader reader = new CsvReader((Reader)inputStreamReader, ',');
            reader.readHeaders();
            while (reader.readRecord()) {
                csvList.add(reader.getValues());
            }
            reader.close();
            ArrayList<MallBillInfoEntity> mallBillInfoEntityList = new ArrayList<MallBillInfoEntity>();
            for (int row = 0; row < csvList.size(); ++row) {
                if (row < 14) continue;
                String[] cell = (String[])csvList.get(row);
                this.logger.info("=================\u8fdb\u5165readCsv-=============cell={}", (Object)JSON.toJSONString((Object)cell));
                MallBillInfoEntity mallBillInfoEntity = new MallBillInfoEntity();
                mallBillInfoEntity.setId(IDGenerate.getUniqueIdStr());
                mallBillInfoEntity.setTradeTime(DateUtils.StrToDate((String)cell[0], null));
                mallBillInfoEntity.setTradeNo(cell[1]);
                mallBillInfoEntity.setThridTradeNo(cell[2]);
                int tradeType = 2;
                String tradeTypeName = cell[4].replaceAll("\t|\n", "").trim();
                mallBillInfoEntity.setTradeTypeName(tradeTypeName);
                if ("\u4ee3\u7406\u6d88\u8d39".contains(tradeTypeName)) {
                    tradeType = 1;
                }
                mallBillInfoEntity.setTradeType(tradeType);
                mallBillInfoEntity.setTradeSource(cell[5]);
                mallBillInfoEntity.setAppId(cell[9]);
                mallBillInfoEntity.setAppName(cell[10]);
                mallBillInfoEntity.setTradeChannel(cell[12]);
                mallBillInfoEntity.setDataSource("cmbpay");
                int tradeStatus = 1;
                String tradeStatusName = cell[13].replaceAll("\t|\n", "").trim();
                if ("\u5931\u8d25".contains(tradeStatusName)) {
                    tradeStatus = 0;
                }
                mallBillInfoEntity.setTradeStatus(tradeStatus);
                mallBillInfoEntity.setTradeStatusName(tradeStatusName);
                String tradeRe = cell[17].replaceAll("\t", "");
                BigDecimal tradeAmountDec = new BigDecimal(tradeRe);
                mallBillInfoEntity.setTradeAmount(tradeAmountDec);
                String serviceAmountRe = cell[18].replaceAll("\t", "");
                BigDecimal serviceAmountDec = new BigDecimal(serviceAmountRe);
                mallBillInfoEntity.setServiceAmount(serviceAmountDec);
                String settleAmountRe = cell[19].replaceAll("\t", "");
                BigDecimal settleAmountDec = new BigDecimal(settleAmountRe);
                mallBillInfoEntity.setSettleAmount(settleAmountDec);
                mallBillInfoEntity.setOriginalTradeNo(cell[20]);
                mallBillInfoEntity.setCreateTime(new Date());
                MallBillInfoVo mallBillInfoVo = new MallBillInfoVo();
                mallBillInfoVo.setTradeTimeStart(DateUtils.StrToDate((String)cell[0], (String)"yyyy-MM-dd"));
                mallBillInfoVo.setTradeTimeEnd(DateUtils.getAddDateByDay((Date)DateUtils.StrToDate((String)cell[0], (String)"yyyy-MM-dd"), (int)1));
                List<MallOrderPayVo> mallOrderPayVoList = this.mallBillInfoMapper.getBillInfoByTradeTime(mallBillInfoVo);
                if (mallOrderPayVoList != null && mallOrderPayVoList.size() > 0) {
                    return -1;
                }
                mallBillInfoEntityList.add(mallBillInfoEntity);
            }
            i = this.mallBillInfoMapper.insertBillBatch(mallBillInfoEntityList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return i;
    }

    public void checkPayBillInfo(MallBillResultVo mallBillResultVo) {
        this.logger.info("==============\u8fdb\u5165checkPayBillInfo++++++++++");
        try {
            MallOrderPayVo mallOrderPayVo = new MallOrderPayVo();
            mallOrderPayVo.setCashType(1);
            mallOrderPayVo.setPaytypeId(7);
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
            Date dateStart = DateUtils.getAddDateByDay((Date)new Date(), (int)-1);
            Date dateEnd = new Date();
            if (mallBillResultVo != null && mallBillResultVo.getCreateTime() != null) {
                dateStart = mallBillResultVo.getCreateTime();
                dateEnd = DateUtils.getAddDateByDay((Date)dateStart, (int)1);
            }
            String dateStartStr = f.format(dateStart) + " 00:00:00";
            String dateEndStr = f.format(dateEnd) + " 00:00:00";
            SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            mallOrderPayVo.setSuccessTimeStart(sd.parse(dateStartStr));
            mallOrderPayVo.setSuccessTimeEnd(sd.parse(dateEndStr));
            List<MallOrderPayVo> localMallOrderPayList = this.mallOrderPayMapper.getOrderPayByParam(mallOrderPayVo);
            MallBillInfoVo mallBillInfoVo = new MallBillInfoVo();
            mallBillInfoVo.setTradeType(1);
            mallBillInfoVo.setAppId("156152599871586");
            mallBillInfoVo.setTradeStatus(1);
            mallBillInfoVo.setTradeTimeStart(sd.parse(dateStartStr));
            mallBillInfoVo.setTradeTimeEnd(sd.parse(dateEndStr));
            List<MallOrderPayVo> otherMallOrderPayList = this.mallBillInfoMapper.getBillInfoByParam(mallBillInfoVo);
            List localErrorTradeNoList = new ArrayList();
            ArrayList<MallBillResultEntity> mallBillResultEntityList = new ArrayList<MallBillResultEntity>();
            localErrorTradeNoList = ListUtils.subtract(localMallOrderPayList, otherMallOrderPayList);
            Date nowDate = new Date();
            if (localErrorTradeNoList != null && localErrorTradeNoList.size() > 0) {
                for (MallOrderPayVo orderTradeNo : localErrorTradeNoList) {
                    MallBillResultEntity mallBillResultEntity = new MallBillResultEntity();
                    mallBillResultEntity.setTradeType(1);
                    mallBillResultEntity.setDataSource("cmbpay");
                    mallBillResultEntity.setId(IDGenerate.getUniqueIdStr());
                    mallBillResultEntity.setTradeNo(orderTradeNo.getTradeNo());
                    mallBillResultEntity.setBillResult(2);
                    mallBillResultEntity.setCreateTime(nowDate);
                    boolean flag = this.mallBillResultInterface.getBillResultByTradeNo(orderTradeNo.getTradeNo());
                    if (!flag) continue;
                    mallBillResultEntityList.add(mallBillResultEntity);
                }
            }
            List otherErrorTradeNoList = new ArrayList();
            otherErrorTradeNoList = ListUtils.subtract(otherMallOrderPayList, localMallOrderPayList);
            if (otherErrorTradeNoList != null && otherErrorTradeNoList.size() > 0) {
                for (MallOrderPayVo orderTradeNo : otherErrorTradeNoList) {
                    MallBillResultEntity mallBillResultEntity = new MallBillResultEntity();
                    mallBillResultEntity.setId(IDGenerate.getUniqueIdStr());
                    mallBillResultEntity.setTradeType(1);
                    mallBillResultEntity.setDataSource("cmbpay");
                    mallBillResultEntity.setTradeNo(orderTradeNo.getTradeNo());
                    mallBillResultEntity.setBillResult(1);
                    mallBillResultEntity.setCreateTime(nowDate);
                    boolean flag = this.mallBillResultInterface.getBillResultByTradeNo(orderTradeNo.getTradeNo());
                    if (!flag) continue;
                    mallBillResultEntityList.add(mallBillResultEntity);
                }
            }
            this.mallBillResultMapper.insertBillResultBatch(mallBillResultEntityList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void checkRefundBillInfo(MallBillResultVo mallBillResultVo) {
        this.logger.info("==============\u8fdb\u5165checkRefundBillInfo++++++++++");
        try {
            MallRefundPayDetailVo mallRefundPayDetailVo = new MallRefundPayDetailVo();
            mallRefundPayDetailVo.setPaytypeId(7);
            mallRefundPayDetailVo.setRefundStatus(1);
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
            Date dateStart = DateUtils.getAddDateByDay((Date)new Date(), (int)-1);
            Date dateEnd = new Date();
            if (mallBillResultVo != null && mallBillResultVo.getCreateTime() != null) {
                dateStart = mallBillResultVo.getCreateTime();
                dateEnd = DateUtils.getAddDateByDay((Date)dateStart, (int)1);
            }
            String dateStartStr = f.format(dateStart) + " 00:00:00";
            String dateEndStr = f.format(dateEnd) + " 00:00:00";
            SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            mallRefundPayDetailVo.setConfirmTimeStart(dateStartStr);
            mallRefundPayDetailVo.setConfirmTimeEnd(dateEndStr);
            List<MallOrderPayVo> localMallOrderPayList = this.mallRefundRecordMapper.selectRefundRecordListByParam(mallRefundPayDetailVo);
            MallBillInfoVo mallBillInfoVo = new MallBillInfoVo();
            mallBillInfoVo.setTradeType(2);
            mallBillInfoVo.setAppId("156152599871586");
            mallBillInfoVo.setTradeStatus(1);
            mallBillInfoVo.setTradeTimeStart(sd.parse(dateStartStr));
            mallBillInfoVo.setTradeTimeEnd(sd.parse(dateEndStr));
            List<MallOrderPayVo> otherMallOrderPayList = this.mallBillInfoMapper.getBillInfoByParam(mallBillInfoVo);
            List localErrorTradeNoList = new ArrayList();
            ArrayList<MallBillResultEntity> mallBillResultEntityList = new ArrayList<MallBillResultEntity>();
            localErrorTradeNoList = ListUtils.subtract(localMallOrderPayList, otherMallOrderPayList);
            Date nowDate = new Date();
            if (localErrorTradeNoList != null && localErrorTradeNoList.size() > 0) {
                for (MallOrderPayVo orderTradeNo : localErrorTradeNoList) {
                    MallBillResultEntity mallBillResultEntity = new MallBillResultEntity();
                    mallBillResultEntity.setTradeType(2);
                    mallBillResultEntity.setDataSource("cmbpay");
                    mallBillResultEntity.setId(IDGenerate.getUniqueIdStr());
                    mallBillResultEntity.setTradeNo(orderTradeNo.getTradeNo());
                    mallBillResultEntity.setBillResult(2);
                    mallBillResultEntity.setCreateTime(nowDate);
                    boolean flag = this.mallBillResultInterface.getBillResultByTradeNo(orderTradeNo.getTradeNo());
                    if (!flag) continue;
                    mallBillResultEntityList.add(mallBillResultEntity);
                }
            }
            List otherErrorTradeNoList = new ArrayList();
            otherErrorTradeNoList = ListUtils.subtract(otherMallOrderPayList, localMallOrderPayList);
            if (otherErrorTradeNoList != null && otherErrorTradeNoList.size() > 0) {
                for (MallOrderPayVo orderTradeNo : otherErrorTradeNoList) {
                    MallBillResultEntity mallBillResultEntity = new MallBillResultEntity();
                    mallBillResultEntity.setId(IDGenerate.getUniqueIdStr());
                    mallBillResultEntity.setTradeType(2);
                    mallBillResultEntity.setDataSource("cmbpay");
                    mallBillResultEntity.setTradeNo(orderTradeNo.getTradeNo());
                    mallBillResultEntity.setBillResult(1);
                    mallBillResultEntity.setCreateTime(nowDate);
                    boolean flag = this.mallBillResultInterface.getBillResultByTradeNo(orderTradeNo.getTradeNo());
                    if (!flag) continue;
                    mallBillResultEntityList.add(mallBillResultEntity);
                }
            }
            this.mallBillResultMapper.insertBillResultBatch(mallBillResultEntityList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int billResult(String billType, MallBillResultVo mallBillResultVo) {
        int i = 0;
        i = this.downloadUnzip(billType, mallBillResultVo);
        if (i > 0) {
            this.checkPayBillInfo(mallBillResultVo);
            this.checkRefundBillInfo(mallBillResultVo);
        }
        return i;
    }
}

