/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.pay.couponpay;

import cc.lechun.framework.common.enums.pay.PayStatusEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.json.JsonUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.entity.pay.PayInputEntity;
import cc.lechun.mall.entity.pay.PayOutputEntity;
import cc.lechun.mall.entity.trade.MallOrderPayEntity;
import cc.lechun.mall.iservice.cashticket.CashticketCustomerInterface;
import cc.lechun.mall.iservice.trade.MallOrderPayInterface;
import cc.lechun.mall.service.pay.PayStrategyInterface;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component(value="couponPay.couponSubPay")
public class CouponPayService
extends BaseService
implements PayStrategyInterface {
    @Autowired
    private CashticketCustomerInterface cashticketCustomerInterface;
    @Autowired
    private MallOrderPayInterface orderPayInterface;

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class}, timeout=10, isolation=Isolation.SERIALIZABLE)
    public BaseJsonVo pay(PayInputEntity inputEntity) {
        BaseJsonVo result = new BaseJsonVo();
        MallOrderPayEntity orderPayEntity = this.orderPayInterface.getSingleOrderPayByTradeNo(inputEntity.getTradeNo());
        if (orderPayEntity == null) {
            result.setError("\u652f\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728");
            return result;
        }
        if (orderPayEntity.getIssuccess().intValue() == PayStatusEnum.PAY_SUCCESS.getValue()) {
            result.setError("\u5df2\u7ecf\u652f\u4ed8\u6210\u529f\uff0c\u4e0d\u80fd\u91cd\u590d\u652f\u4ed8");
            return result;
        }
        BaseJsonVo jsonVo = this.cashticketCustomerInterface.useCashTicketCustomer(inputEntity.getCustomerId(), orderPayEntity.getCashticketId(), inputEntity.getOrderMainNo(), orderPayEntity.getPayamount());
        PayOutputEntity payOutputEntity = new PayOutputEntity();
        payOutputEntity.setSendUrl("service\u8c03\u7528");
        payOutputEntity.setReturnContent(JsonUtils.toJson((Object)jsonVo, (boolean)true));
        payOutputEntity.setSendContent(inputEntity.getCustomerId() + "|" + orderPayEntity.getCashticketId() + "|" + inputEntity.getOrderMainNo() + "|" + orderPayEntity.getPayamount());
        if (!jsonVo.isSuccess()) {
            result.setError(jsonVo.getMessage());
            return result;
        }
        payOutputEntity.setOrderMainNo(orderPayEntity.getOrderMainNo());
        payOutputEntity.setStatus(PayStatusEnum.PAY_SUCCESS.getValue());
        payOutputEntity.setPayTypeId(inputEntity.getPayType());
        payOutputEntity.setPayTypeSubId(inputEntity.getPaySubType());
        payOutputEntity.setPayId(orderPayEntity.getPayId());
        result.setValue((Object)payOutputEntity);
        return result;
    }

    @Override
    public <T> BaseJsonVo payNotify(T notifyInputEntity) {
        BaseJsonVo result = new BaseJsonVo();
        return result;
    }

    @Override
    public <T> BaseJsonVo payNotify(Map<String, Object> map) {
        return null;
    }

    @Override
    public BaseJsonVo paySearch(PayInputEntity inputEntity) {
        BaseJsonVo result = new BaseJsonVo();
        return result;
    }

    @Override
    public BaseJsonVo payClose(PayInputEntity inputEntity) {
        BaseJsonVo result = new BaseJsonVo();
        if (inputEntity == null) {
            result.setError("\u652f\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728");
            return result;
        }
        if (inputEntity.isSuccess()) {
            MallOrderPayEntity orderPayEntity = this.orderPayInterface.getSingleOrderPayByTradeNo(inputEntity.getTradeNo());
            if (orderPayEntity == null) {
                result.setError("\u652f\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728");
                return result;
            }
            if (orderPayEntity.getIssuccess() != 1) {
                result.setError("\u6ca1\u6709\u652f\u4ed8\u6210\u529f\uff0c\u4e0d\u80fd\u9000\u8fd8");
                return result;
            }
            BaseJsonVo baseJsonVo = this.cashticketCustomerInterface.returnCashTicketCustomer(orderPayEntity.getCashticketId(), orderPayEntity.getOrderMainNo());
            if (!baseJsonVo.isSuccess()) {
                result.setError(baseJsonVo.getMessage());
                return result;
            }
            if (result.isSuccess()) {
                MallOrderPayEntity mallOrderPayEntity = new MallOrderPayEntity();
                mallOrderPayEntity.setSuccessTime(DateUtils.now());
                mallOrderPayEntity.setIssuccess(0);
                mallOrderPayEntity.setPayId(inputEntity.getPayId());
                if (this.orderPayInterface.updateByPrimaryKey(mallOrderPayEntity)) {
                    // empty if block
                }
            }
        }
        return result;
    }

    @Override
    public BaseJsonVo payRefund(PayInputEntity inputEntity) {
        BaseJsonVo result = new BaseJsonVo();
        if (inputEntity == null) {
            result.setError("\u652f\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728");
            return result;
        }
        if (inputEntity.isSuccess()) {
            MallOrderPayEntity orderPayEntity = this.orderPayInterface.getSingleOrderPayByTradeNo(inputEntity.getTradeNo());
            if (orderPayEntity == null) {
                result.setError("\u652f\u4ed8\u4fe1\u606f\u4e0d\u5b58\u5728");
                return result;
            }
            if (orderPayEntity.getIssuccess() != 1) {
                result.setError("\u6ca1\u6709\u652f\u4ed8\u6210\u529f\uff0c\u4e0d\u80fd\u9000\u8fd8");
                return result;
            }
            BaseJsonVo baseJsonVo = this.cashticketCustomerInterface.returnCashTicketCustomer(orderPayEntity.getCashticketId(), orderPayEntity.getOrderMainNo());
            if (!baseJsonVo.isSuccess()) {
                result.setError(baseJsonVo.getMessage());
                return result;
            }
            if (result.isSuccess()) {
                MallOrderPayEntity mallOrderPayEntity = new MallOrderPayEntity();
                mallOrderPayEntity.setSuccessTime(DateUtils.now());
                mallOrderPayEntity.setIssuccess(0);
                mallOrderPayEntity.setPayId(inputEntity.getPayId());
                if (this.orderPayInterface.updateByPrimaryKey(mallOrderPayEntity)) {
                    // empty if block
                }
            }
        }
        return result;
    }

    @Override
    public <T> BaseJsonVo refundNotify(T notifyInputEntity) {
        BaseJsonVo result = new BaseJsonVo();
        return result;
    }
}

