/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sales;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.SalesTypeEnum;
import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.ids.IDGenerate;
import cc.lechun.framework.common.utils.object.ObjectConvert;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.sales.MallPromotionMapper;
import cc.lechun.mall.entity.common.MallSelectDataVo;
import cc.lechun.mall.entity.sales.MallGroupVO;
import cc.lechun.mall.entity.sales.MallIndexPromotionVo;
import cc.lechun.mall.entity.sales.MallPriceVO;
import cc.lechun.mall.entity.sales.MallProductEntity;
import cc.lechun.mall.entity.sales.MallProductGroupEntity;
import cc.lechun.mall.entity.sales.MallProductVO;
import cc.lechun.mall.entity.sales.MallPromotionBuyEntity;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.entity.sales.MallPromotionProductEntity;
import cc.lechun.mall.entity.sales.MallPromotionTimeEntity;
import cc.lechun.mall.entity.sales.MallPromotionVO;
import cc.lechun.mall.entity.sales.MallSaleRecommendEntity;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.iservice.sales.MallGroupInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallProductPicInterface;
import cc.lechun.mall.iservice.sales.MallPromotionBuyInterface;
import cc.lechun.mall.iservice.sales.MallPromotionInterface;
import cc.lechun.mall.iservice.sales.MallPromotionProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionTimeInterface;
import cc.lechun.mall.iservice.sales.MallSaleRecommendInterface;
import cc.lechun.mall.iservice.shoppingcart.MallPriceCalcInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import cc.lechun.mall.iservice.vip.MallVipInterface;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class MallPromotionService
extends BaseService
implements MallPromotionInterface {
    @Autowired
    ActiveInterface activeInterface;
    @Autowired
    MallPromotionMapper promotionMapper;
    @Autowired
    MallProductInterface productService;
    @Autowired
    MallGroupInterface groupService;
    @Autowired
    MallProductPicInterface picService;
    @Autowired
    MallVipInterface vipInterface;
    @Autowired
    MallPromotionBuyInterface promotionBuyInterface;
    @Autowired
    MallPromotionProductInterface promotionProductInterface;
    @Autowired
    MallSaleRecommendInterface saleRecommendInterface;
    @Autowired
    MallPriceCalcInterface priceCalcInterface;
    @Autowired
    MallPromotionTimeInterface promotionTimeService;
    @Autowired
    MemcachedService memcachedService;
    @Autowired
    @Lazy
    MallOrderProductInterface mallOrderProductInterface;
    @Autowired
    private MallOrderMainInterface mallOrderMainInterface;
    @Autowired
    private MallPromotionInterface promotionInterface;

    @Override
    public PageInfo getPromotionList(int pageNum, int length, MallPromotionEntity mallPromotionEntity, Integer platformGroupId) {
        Page page = PageHelper.startPage((int)pageNum, (int)length);
        String promotionName = mallPromotionEntity.getPromotionName();
        Integer status = mallPromotionEntity.getStatus();
        Date beginTime = mallPromotionEntity.getBeginTime();
        Date endTime = mallPromotionEntity.getEndTime();
        List<MallPromotionEntity> pros = this.promotionMapper.getCmsList(promotionName, status, beginTime, endTime, platformGroupId);
        ArrayList list = new ArrayList();
        pros.forEach(promotion -> {
            MallPromotionProductEntity promotionProductEntity;
            Map map = ObjectConvert.beanToMap((Object)promotion);
            MallPromotionTimeEntity timeEntity = this.promotionTimeService.getSingleEntityByTime(promotion.getPromotionId(), DateUtils.date());
            if (timeEntity != null) {
                Date beginTimeType = timeEntity.getBeginTime();
                Date endTimeType = timeEntity.getEndTime();
                if (promotion.getPromotionType() == 2) {
                    beginTimeType = DateUtils.currentDate();
                    endTimeType = DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)1);
                }
                int buyCount = this.promotionBuyInterface.getPromotionBuyCount(promotion.getPromotionId(), beginTimeType, endTimeType);
                map.put("limitCount", String.valueOf(timeEntity.getLimitCount()));
                map.put("usedCount", String.valueOf(buyCount));
                map.put("balanceCount", String.valueOf(timeEntity.getLimitCount() - buyCount));
            }
            if ((promotionProductEntity = this.promotionProductInterface.getPromotionProductEntity(promotion.getPromotionId())) != null) {
                map.put("promotionProductId", promotionProductEntity.getPromotionProductId());
            } else {
                map.put("promotionProductId", "");
            }
            list.add(map);
        });
        PageInfo pg = page.toPageInfo();
        pg.setList(list);
        return pg;
    }

    public List<MallPromotionEntity> getCmsList(String promotionName, Integer status, Date beginTime, Date endTime) {
        return this.promotionMapper.getCmsList(promotionName, status, beginTime, endTime, null);
    }

    @Override
    @ReadThroughSingleCache(namespace="promotionEntity", expiration=3600)
    public MallPromotionEntity getPromotion(@ParameterValueKeyProvider String promotionId) {
        return (MallPromotionEntity)this.promotionMapper.selectByPrimaryKey((Serializable)((Object)promotionId));
    }

    @Override
    public BaseJsonVo addPromotion(MallPromotionEntity mallPromotionEntity, int limitCount) {
        BaseJsonVo sr = new BaseJsonVo();
        if (mallPromotionEntity == null) {
            sr.setError("\u53c2\u6570\u9519\u8bef");
            return sr;
        }
        if (StringUtils.isEmpty((String)mallPromotionEntity.getPromotionId())) {
            mallPromotionEntity.setPromotionId(IDGenerate.getUniqueIdStr());
            mallPromotionEntity.setCreateTime(DateUtils.now());
            this.promotionMapper.insert(mallPromotionEntity);
        } else {
            this.promotionMapper.updateByPrimaryKeySelective(mallPromotionEntity);
            this.removeCache(mallPromotionEntity.getPromotionId());
        }
        this.promotionTimeService.addPromotionTime(mallPromotionEntity, limitCount);
        return sr;
    }

    @Override
    public BaseJsonVo updatePromotion(MallPromotionEntity mallPromotionEntity) {
        BaseJsonVo sr = new BaseJsonVo();
        if (mallPromotionEntity == null) {
            sr.setError("\u53c2\u6570\u9519\u8bef");
            return sr;
        }
        if (StringUtils.isEmpty((String)mallPromotionEntity.getPromotionId())) {
            mallPromotionEntity.setPromotionId(IDGenerate.getUniqueIdStr());
            mallPromotionEntity.setCreateTime(DateUtils.now());
            this.promotionMapper.insert(mallPromotionEntity);
        } else {
            this.promotionMapper.updateByPrimaryKeySelective(mallPromotionEntity);
            this.removeCache(mallPromotionEntity.getPromotionId());
        }
        return sr;
    }

    @Override
    public BaseJsonVo delPromotion(String promotionId) {
        if (StringUtils.isNotEmpty((String)promotionId)) {
            this.promotionMapper.deleteByPrimaryKey((Serializable)((Object)promotionId));
            this.removeCache(promotionId);
            return new BaseJsonVo();
        }
        BaseJsonVo sr = new BaseJsonVo();
        sr.setError("\u5185\u90e8\u9519\u8bef");
        return sr;
    }

    @Override
    public BaseJsonVo changePromotion(String promotionId) {
        MallPromotionEntity entity = this.promotionInterface.getPromotion(promotionId);
        if (entity.getStatus() == 1) {
            entity.setStatus(2);
        } else {
            entity.setStatus(1);
        }
        this.removeCache(promotionId);
        return this.updatePromotion(entity);
    }

    @Override
    public BaseJsonVo addPromotionProduct(MallPromotionProductEntity mallPromotionProductEntity) {
        BaseJsonVo sr = new BaseJsonVo();
        if (mallPromotionProductEntity == null) {
            sr.setError("\u53c2\u6570\u9519\u8bef");
            return sr;
        }
        if (StringUtils.isEmpty((String)mallPromotionProductEntity.getPromotionProductId())) {
            mallPromotionProductEntity.setPromotionProductId(IDGenerate.getUniqueIdStr());
            this.promotionProductInterface.addPromotionProduct(mallPromotionProductEntity);
        } else {
            this.promotionProductInterface.updatePromotionProduct(mallPromotionProductEntity);
        }
        this.removeCache(mallPromotionProductEntity.getPromotionId());
        return sr;
    }

    private void removeCache(String promotionId) {
        this.memcachedService.delete("promotionEntity", promotionId);
    }

    @Override
    public BaseJsonVo buildPromotionVOFromProIDs(List<String> promotionIDs) {
        return null;
    }

    @Override
    public BaseJsonVo findCurrentPromotion(Integer platformGroupId) {
        BaseJsonVo result = new BaseJsonVo();
        ArrayList vos = new ArrayList();
        List<MallPromotionEntity> promotionEntities = this.promotionMapper.findCurrentPromotions(platformGroupId);
        promotionEntities.forEach(promotionEntity -> {
            BaseJsonVo sr = this.buildPromotionVO(promotionEntity.getPromotionId(), 1, true);
            if (sr.isSuccess()) {
                vos.add((MallPromotionVO)sr.getValue());
            }
        });
        result.setValue(vos);
        return result;
    }

    @Override
    @ReadThroughSingleCache(namespace="MallPromotionService.getCurrentPromotionList", expiration=300)
    public List<MallPromotionVO> getCurrentPromotionList(@ParameterValueKeyProvider Integer platformGroupId) {
        return this.getCurrentPromotionList(platformGroupId, true);
    }

    @Override
    public List<MallPromotionVO> getCurrentPromotionList(Integer platformGroupId, boolean check) {
        ArrayList<MallPromotionVO> vos = new ArrayList<MallPromotionVO>();
        List<MallPromotionEntity> promotionEntities = this.promotionMapper.findCurrentPromotions(platformGroupId);
        if (check) {
            promotionEntities.forEach(promotionEntity -> {
                BaseJsonVo sr = this.buildPromotionVO(promotionEntity.getPromotionId(), 1, check);
                if (sr.isSuccess()) {
                    vos.add((MallPromotionVO)sr.getValue());
                }
            });
        } else {
            for (MallPromotionEntity promotionEntity2 : promotionEntities) {
                MallPromotionVO promotionVO = new MallPromotionVO();
                promotionVO.setPromotionName(promotionEntity2.getPromotionName());
                promotionVO.setPromotionId(promotionEntity2.getPromotionId());
                vos.add(promotionVO);
            }
        }
        return vos;
    }

    @Override
    public BaseJsonVo findCustomerCurrentPromotion(Integer platformGroupId, String customerId) {
        return null;
    }

    @Override
    public BaseJsonVo findActiveCurrentPromotion(Integer platformGroupId, String activeNo) {
        return null;
    }

    @Override
    public BaseJsonVo buildPromotionVO(String promotionId, Integer quantity, Boolean checked) {
        BaseJsonVo sr = new BaseJsonVo();
        MallPromotionVO vo = new MallPromotionVO();
        MallPromotionEntity entity = this.promotionInterface.getPromotion(promotionId);
        if (entity == null) {
            sr.setError("\u4fc3\u9500\u4e0d\u5b58\u5728");
            vo.setValid(false);
            vo.setInvalidReason(sr.getError_msg());
            vo.setShoppingcartCheck(false);
            sr.setValue((Object)vo);
            return sr;
        }
        try {
            ObjectConvert.fatherConvertToChild((Object)entity, (Object)vo);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            sr.setError("\u5546\u54c1\u4fe1\u606f\u9519\u8bef");
            return sr;
        }
        vo.setCount(quantity);
        vo.setShort(false);
        vo.setSoldOut(false);
        vo.setPromotionId(promotionId);
        vo.setShoppingcartCheck(checked);
        ArrayList proList = new ArrayList();
        ArrayList groupList = new ArrayList();
        MallPromotionProductEntity promotionProduct = this.promotionProductInterface.getPromotionProductEntity(promotionId);
        if (promotionProduct == null) {
            sr.setError("\u4fc3\u9500\u672a\u5173\u8054\u5546\u54c1");
            vo.setValid(false);
            vo.setInvalidReason(sr.getError_msg());
            vo.setShoppingcartCheck(false);
            sr.setValue((Object)vo);
            return sr;
        }
        vo.setProductType(promotionProduct.getProductType());
        vo.setOriginPrice(promotionProduct.getOriginPrice());
        vo.setPromotionPrice(promotionProduct.getPromotionPrice());
        vo.setLimitCount(promotionProduct.getLimitCount());
        vo.setPromotionProductId(promotionProduct.getPromotionProductId());
        vo.setPromotionPic(this.picService.getProductPicUrlMap(promotionProduct.getPromotionProductId(), SalesTypeEnum.SALES_PROMOTION.getValue()));
        if (SalesTypeEnum.SALES_PRODUCT.getValue() == Integer.valueOf(promotionProduct.getProductType()).intValue()) {
            BaseJsonVo buildProductVOsr = this.productService.buildProductVO(promotionProduct.getProductId(), quantity, null, promotionId, null, null, false, checked, null, null);
            if (buildProductVOsr.isSuccess()) {
                MallProductVO productVO = (MallProductVO)buildProductVOsr.getValue();
                if (productVO.getValid().booleanValue()) {
                    vo.setProduct((MallProductVO)buildProductVOsr.getValue());
                } else {
                    vo.setValid(false);
                    vo.setInvalidReason(productVO.getInvalidReason());
                    vo.setShoppingcartCheck(false);
                }
            } else {
                vo.setValid(false);
                vo.setInvalidReason(buildProductVOsr.getError_msg());
                vo.setShoppingcartCheck(false);
            }
        } else if (SalesTypeEnum.SALES_GROUP.getValue() == Integer.valueOf(promotionProduct.getProductType()).intValue()) {
            BaseJsonVo buildGroupVOsr = this.groupService.buildGroupVO(promotionProduct.getProductId(), quantity, promotionId, checked);
            if (buildGroupVOsr.isSuccess()) {
                MallGroupVO groupVO = (MallGroupVO)buildGroupVOsr.getValue();
                if (groupVO.getValid().booleanValue()) {
                    vo.setGroup((MallGroupVO)buildGroupVOsr.getValue());
                } else {
                    vo.setGroup((MallGroupVO)buildGroupVOsr.getValue());
                    vo.setValid(false);
                    vo.setInvalidReason(groupVO.getInvalidReason());
                    vo.setShoppingcartCheck(false);
                }
            } else {
                vo.setValid(false);
                vo.setInvalidReason(buildGroupVOsr.getError_msg());
                vo.setShoppingcartCheck(false);
            }
        }
        if (!vo.getValid().booleanValue()) {
            sr.setValue((Object)vo);
            return sr;
        }
        ArrayList<MallPromotionVO> tmpVos = new ArrayList<MallPromotionVO>();
        tmpVos.add(0, vo);
        vo.setSelfModeType(this.productService.getPromotionSelfMode(tmpVos));
        BaseJsonVo checkResult = this.checkPromotion(vo);
        if (checkResult.isSuccess()) {
            vo.setValid(true);
        } else {
            vo.setValid(false);
            vo.setInvalidReason(checkResult.getMessage());
            vo.setShoppingcartCheck(false);
        }
        sr.setValue((Object)vo);
        return sr;
    }

    @Override
    public BaseJsonVo checkPromotion(MallPromotionVO promotionVO) {
        MallPromotionTimeEntity promotionTimeEntity = this.promotionTimeService.getSingleEntityByTime(promotionVO.getPromotionId(), DateUtils.date());
        BaseJsonVo baseJsonVo = this.checkBasePromotion(promotionVO.getPromotionType(), promotionTimeEntity, promotionVO.getPromotionId(), promotionVO.getPromotionName(), promotionVO.getActiveNo(), promotionVO.getBeginTime(), promotionVO.getEndTime(), promotionVO.getStatus(), promotionVO.getSaled());
        if (baseJsonVo.isSuccess()) {
            MallPromotionProductEntity promotionProductEntity;
            if (SalesTypeEnum.SALES_PRODUCT.getValue() == Integer.valueOf(promotionVO.getProductType()).intValue()) {
                if (!promotionVO.getProduct().getValid().booleanValue()) {
                    return BaseJsonVo.error((String)(String.format("\u4fc3\u9500%s\u4e2d\uff0c", promotionVO.getPromotionName()).toString() + promotionVO.getProduct().getInvalidReason()));
                }
            } else if (SalesTypeEnum.SALES_GROUP.getValue() == Integer.valueOf(promotionVO.getProductType()).intValue() && !promotionVO.getGroup().getValid().booleanValue()) {
                return BaseJsonVo.error((String)(String.format("\u4fc3\u9500%s\u4e2d\uff0c", promotionVO.getPromotionName()).toString() + promotionVO.getGroup().getInvalidReason()));
            }
            if ((promotionProductEntity = this.promotionProductInterface.getPromotionProductEntity(promotionVO.getPromotionId())) != null && promotionProductEntity.getLimitCount() != 0 && promotionVO.getCount() > promotionProductEntity.getLimitCount()) {
                return BaseJsonVo.error((String)String.format("\u4fc3\u9500%s\uff0c\u8d85\u8fc7\u8d2d\u4e70\u9650\u5236\u6570", promotionVO.getPromotionName()).toString());
            }
        } else {
            return baseJsonVo;
        }
        return BaseJsonVo.success((Object)"");
    }

    private BaseJsonVo checkBasePromotion(int promotionType, MallPromotionTimeEntity promotionTimeEntity, String promotionId, String promotionName, String activeNo, Date beginTime, Date endTime, int status, int saled) {
        if (status != 1) {
            BaseJsonVo baseJsonVo = new BaseJsonVo();
            baseJsonVo.setStatus(40002);
            baseJsonVo.setMessage(String.format("\u4fc3\u9500%s,\u5df2\u7ed3\u675f", promotionName));
            return baseJsonVo;
        }
        if (beginTime.getTime() > DateUtils.now().getTime()) {
            return BaseJsonVo.error((String)String.format("\u4fc3\u9500%s,\u5c1a\u672a\u5f00\u59cb", promotionName).toString());
        }
        if (endTime.getTime() < DateUtils.now().getTime()) {
            return BaseJsonVo.error((String)String.format("\u4fc3\u9500%s,\u5df2\u8fc7\u671f", promotionName).toString());
        }
        if (promotionTimeEntity == null) {
            return BaseJsonVo.error((String)String.format("\u4fc3\u9500%s,\u5c1a\u672a\u5f00\u59cb\u6216\u5df2\u8fc7\u671f", promotionName).toString());
        }
        if (promotionType == 2) {
            beginTime = DateUtils.currentDate();
            endTime = DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)1);
        }
        int buyCount = this.promotionBuyInterface.getPromotionBuyCount(promotionId, beginTime, endTime);
        if (promotionTimeEntity.getLimitCount() - (buyCount += saled) < 0) {
            return BaseJsonVo.error((String)String.format("\u4eb2\u7231\u54d2\uff0c%s\u592a\u706b\u7206\u88ab\u62a2\u8d2d\u7a7a\u5566\uff0c\u522b\u7740\u6025\uff5e\u6211\u4eec\u5546\u57ce\u8fd8\u6709\u66f4\u591a\u5b9a\u5236\u4f18\u60e0\u4f9b\u4f60\u6311\u9009\u54e6\uff01", promotionName).toString());
        }
        if (StringUtils.isNotEmpty((String)activeNo) && !this.activeInterface.checkActiveEnable(activeNo).isSuccess()) {
            return BaseJsonVo.error((String)String.format("\u4fc3\u9500%s\uff0c\u5173\u8054\u6d3b\u52a8\u5df2\u8fc7\u671f", promotionName).toString());
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public boolean updatePromotionLimitCount(String promotionId, String itemId, int quantity, Date d1, String customerId) {
        MallPromotionEntity mallPromotionEntity = this.promotionInterface.getPromotion(promotionId);
        if (d1.compareTo(DateUtils.currentDate()) == 0) {
            d1 = DateUtils.now();
        }
        if (mallPromotionEntity.getBeginTime().after(d1) || mallPromotionEntity.getEndTime().before(d1)) {
            return false;
        }
        MallPromotionTimeEntity promotionTimeEntity = this.promotionTimeService.getSingleEntityByTime(promotionId, DateUtils.date());
        if (promotionTimeEntity != null) {
            Date beginTime = promotionTimeEntity.getBeginTime();
            Date endTime = promotionTimeEntity.getEndTime();
            if (mallPromotionEntity.getPromotionType() == 2) {
                beginTime = DateUtils.currentDate();
                endTime = DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)1);
            }
            int buyCount = this.promotionBuyInterface.getPromotionBuyCount(promotionId, beginTime, endTime);
            int limitCount = promotionTimeEntity.getLimitCount() - mallPromotionEntity.getSaled() - buyCount - quantity;
            if (limitCount < 0) {
                return false;
            }
            MallPromotionBuyEntity promotionBuyEntity = new MallPromotionBuyEntity();
            promotionBuyEntity.setPromotionId(promotionId);
            promotionBuyEntity.setBuyCount(quantity);
            promotionBuyEntity.setCreateTime(d1);
            int i = this.promotionBuyInterface.insertSelectiveEntity(mallPromotionEntity, promotionTimeEntity, promotionBuyEntity);
            if (i > 0) {
                this.removeCache(promotionId);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public BaseJsonVo updatePromotionLimitCount(MallMainOrderVo mainOrderVo, boolean reverse) {
        try {
            int red = 1;
            if (reverse) {
                red = -1;
            }
            for (MallOrderVo orderVo : mainOrderVo.getMallOrderVos()) {
                if (orderVo.getPromotions() == null || orderVo.getPromotions().size() <= 0) continue;
                for (MallPromotionVO promotionVO : orderVo.getPromotions()) {
                    if (promotionVO.getProduct() != null && !this.updatePromotionLimitCount(promotionVO.getPromotionId(), promotionVO.getProduct().getProId(), promotionVO.getProduct().getCount() * red, DateUtils.now(), mainOrderVo.getCustomerId())) {
                        return BaseJsonVo.error((String)String.format("\u4eb2\u7231\u54d2\uff0c%s\u592a\u706b\u7206\u88ab\u62a2\u8d2d\u7a7a\u5566\uff0c\u522b\u7740\u6025\uff5e\u6211\u4eec\u5546\u57ce\u8fd8\u6709\u66f4\u591a\u5b9a\u5236\u4f18\u60e0\u4f9b\u4f60\u6311\u9009\u54e6\uff01", promotionVO.getPromotionName()));
                    }
                    if (promotionVO.getGroup() != null && !this.updatePromotionLimitCount(promotionVO.getPromotionId(), promotionVO.getGroup().getGroupId(), promotionVO.getGroup().getCount() * red, DateUtils.now(), mainOrderVo.getCustomerId())) {
                        return BaseJsonVo.error((String)String.format("\u4eb2\u7231\u54d2\uff0c%s\u592a\u706b\u7206\u88ab\u62a2\u8d2d\u7a7a\u5566\uff0c\u522b\u7740\u6025\uff5e\u6211\u4eec\u5546\u57ce\u8fd8\u6709\u66f4\u591a\u5b9a\u5236\u4f18\u60e0\u4f9b\u4f60\u6311\u9009\u54e6\uff01", promotionVO.getPromotionName()));
                    }
                    this.removeCache(promotionVO.getPromotionId());
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.toString());
            throw new RuntimeException();
        }
        return BaseJsonVo.success((Object)"");
    }

    @Override
    public List<Map> findRecommendPromotions(Integer platformGroupId) {
        ArrayList<Map> rtnList = new ArrayList<Map>();
        MallSaleRecommendEntity searchParam = new MallSaleRecommendEntity();
        searchParam.setPlatformGroupId(platformGroupId);
        searchParam.setStatus(1);
        searchParam.setSaleType(SalesTypeEnum.SALES_PROMOTION.getValue());
        List<MallSaleRecommendEntity> sales = this.saleRecommendInterface.getList(searchParam);
        sales.forEach(entity -> {
            BaseJsonVo result = this.buildPromotionVO(entity.getSaleId(), 1, false);
            if (result.isSuccess() && ((MallPromotionVO)result.getValue()).getValid().booleanValue()) {
                Map promotion = ObjectConvert.objectWithSuperConvertToObjectMap((Object)result.getValue());
                promotion.put("recommendReason", entity.getRecommendReason());
                rtnList.add(promotion);
            }
        });
        return rtnList;
    }

    @Override
    public BaseJsonVo buildIndexPromotionVo(String promotionId, String customerId) {
        Map<Object, Object> listMap;
        MallIndexPromotionVo vo = new MallIndexPromotionVo();
        MallPromotionEntity entity = this.promotionInterface.getPromotion(promotionId);
        if (entity == null) {
            this.logger.info("\u4fc3\u9500\u4e0d\u5b58\u5728,promotionId:" + promotionId + ",customerId:" + customerId);
            return BaseJsonVo.error((String)"\u4fc3\u9500\u4e0d\u5b58\u5728");
        }
        MallPromotionTimeEntity promotionTimeEntity = this.promotionTimeService.getSingleEntityByTime(promotionId, DateUtils.date());
        if (promotionTimeEntity == null) {
            BaseJsonVo baseJsonVo = new BaseJsonVo();
            baseJsonVo.setStatus(40003);
            this.logger.info("\u4fc3\u9500\u65f6\u95f4\u4e0d\u5b58\u5728,promotionId:" + promotionId + ",customerId:" + customerId);
            baseJsonVo.setMessage(String.format("\u4fc3\u9500%s,\u672a\u5f00\u59cb\u6216\u5df2\u7ed3\u675f", entity.getPromotionName()));
            return baseJsonVo;
        }
        MallPromotionProductEntity promotionProduct = this.promotionProductInterface.getPromotionProductEntity(promotionId);
        if (promotionProduct == null) {
            this.logger.info("\u4fc3\u9500\u5546\u54c1\u4e0d\u5b58\u5728,promotionId:" + promotionId + ",customerId:" + customerId);
            return BaseJsonVo.error((String)"\u4fc3\u9500\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        MallProductEntity productEntity = null;
        MallProductGroupEntity groupEntity = null;
        if (promotionProduct.getProductType().equals("4") && (productEntity = this.productService.getProduct(promotionProduct.getProductId())) == null) {
            this.logger.info("\u4fc3\u9500\u4e0d\u5b58\u5728,promotionId:" + promotionId + ",customerId:" + customerId);
            return BaseJsonVo.error((String)"\u5546\u54c1\u4e0d\u5b58\u5728");
        }
        if (promotionProduct.getProductType().equals("2") && (groupEntity = this.groupService.getGroup(promotionProduct.getProductId())) == null) {
            this.logger.info("\u4fc3\u9500\u4e0d\u5b58\u5728,promotionId:" + promotionId + ",customerId:" + customerId);
            return BaseJsonVo.error((String)"\u5957\u88c5\u4e0d\u5b58\u5728");
        }
        BaseJsonVo checkResult = this.checkBasePromotion(entity.getPromotionType(), promotionTimeEntity, entity.getPromotionId(), entity.getPromotionName(), entity.getActiveNo(), promotionTimeEntity.getBeginTime(), promotionTimeEntity.getEndTime(), entity.getStatus(), entity.getSaled());
        if (!checkResult.isSuccess()) {
            return checkResult;
        }
        vo.setLimitBuyCount(promotionProduct.getLimitCount());
        vo.setPromotionId(entity.getPromotionId());
        vo.setBeginTime(entity.getBeginTime());
        vo.setEndTime(entity.getEndTime());
        vo.setStatus(entity.getStatus());
        vo.setPromotionType(entity.getPromotionType());
        vo.setFlag(entity.getFlag());
        vo.setSaled(entity.getSaled());
        int buyCount = this.promotionBuyInterface.getPromotionBuyCount(promotionId, promotionTimeEntity.getBeginTime(), promotionTimeEntity.getEndTime());
        int balance = promotionTimeEntity.getLimitCount() - (buyCount += entity.getSaled().intValue());
        vo.setBalanceCount(balance);
        vo.setGroupType(Integer.parseInt(promotionProduct.getProductType()));
        vo.setItemType(1);
        if (vo.getGroupType() == 4) {
            vo.setIsGift(productEntity.getProTypeId() == 3 ? 1 : 0);
            vo.setProductName(productEntity.getProName());
            vo.setProductTagName(productEntity.getProOtherName());
            vo.setProductUnit(productEntity.getProDw());
        } else {
            vo.setIsGift(0);
            vo.setProductName(groupEntity.getGroupName());
            vo.setProductTagName(groupEntity.getGroupOtherName());
            vo.setProductUnit(groupEntity.getGroupUnit());
        }
        vo.setIsShow(1);
        if (promotionProduct.getIsvip() != null && promotionProduct.getIsvip() == 1 && !this.vipInterface.checkVipRightByType(customerId, promotionProduct.getVipRightType())) {
            vo.setIsShow(0);
        }
        vo.setIsVip(promotionProduct.getIsvip());
        vo.setIsvipday(this.vipInterface.isVipDayNow() != false ? "isvipday" : "notvipday");
        vo.setLimitCount(promotionTimeEntity.getLimitCount());
        HashMap map = this.picService.getProductPicUrlMap(promotionProduct.getPromotionProductId(), SalesTypeEnum.SALES_PROMOTION.getValue());
        if (vo.getGroupType() == SalesTypeEnum.SALES_PRODUCT.getValue()) {
            listMap = this.picService.getProductPicUrlMap(promotionProduct.getProductId(), SalesTypeEnum.SALES_PRODUCT.getValue());
            map.putAll(listMap == null ? new HashMap() : listMap);
        }
        if (vo.getGroupType() == SalesTypeEnum.SALES_GROUP.getValue()) {
            listMap = this.picService.getProductPicUrlMap(promotionProduct.getProductId(), SalesTypeEnum.SALES_GROUP.getValue());
            map.putAll(listMap == null ? new HashMap() : listMap);
        }
        vo.setPicMap(map == null ? new HashMap() : map);
        vo.setPrice(promotionProduct.getOriginPrice());
        vo.setProductId(promotionProduct.getProductId());
        vo.setPromotionProductId(promotionProduct.getPromotionProductId());
        vo.setSalePrice(promotionProduct.getPromotionPrice());
        vo.setVipRightType(promotionProduct.getVipRightType());
        long seconds = DateUtils.getDateDiffSecond((Date)DateUtils.now(), (Date)promotionTimeEntity.getEndTime());
        vo.setSeconds(seconds);
        vo.setSecond((int)(seconds % 3600L % 60L));
        vo.setHour((int)(seconds / 3600L));
        vo.setMinute((int)(seconds % 3600L / 60L));
        MallPriceVO priceVO = this.priceCalcInterface.getPrice(OrderSourceEnum.CART, SalesTypeEnum.SALES_PROMOTION, vo.getPromotionId(), customerId, 0);
        if (priceVO != null && priceVO.getFactPrice() != null) {
            vo.setSalePrice(priceVO.getFactPrice());
            vo.setPrice(priceVO.getOriginPrice());
        }
        vo.setItemType(SalesTypeEnum.SALES_PROMOTION.getValue());
        return BaseJsonVo.success((Object)vo);
    }

    @Override
    public List<MallSelectDataVo> getOptionPromotionList(Integer platformGroupId) {
        return this.promotionMapper.getOptionPromotionList(platformGroupId);
    }

    @Override
    public BaseJsonVo getPromotionByBindCode(String customerId, String bindCode) {
        ActiveEntity activeEntity = this.activeInterface.getActiveEntityByQrcode(bindCode);
        if (activeEntity != null) {
            if (!this.activeInterface.checkActiveEnable(activeEntity).isSuccess()) {
                BaseJsonVo baseJsonVo = new BaseJsonVo();
                baseJsonVo.setStatus(40002);
                baseJsonVo.setMessage(String.format("\u6d3b\u52a8%s\uff0c\u5df2\u8fc7\u671f", activeEntity.getActiveName()).toString());
                return baseJsonVo;
            }
        } else {
            BaseJsonVo baseJsonVo = new BaseJsonVo();
            baseJsonVo.setStatus(40002);
            return baseJsonVo;
        }
        MallPromotionEntity mallPromotionEntity = this.getMallPromotionEntityByActiveNo(activeEntity.getActiveNo());
        if (mallPromotionEntity != null) {
            BaseJsonVo baseJsonVo = this.buildIndexPromotionVo(mallPromotionEntity.getPromotionId(), customerId);
            if (baseJsonVo.isSuccess()) {
                Integer userLimitCount = mallPromotionEntity.getUserLimitCount();
                if (userLimitCount != null && userLimitCount > 0) {
                    this.logger.info("\u4fc3\u9500\u9650\u5236\u8d2d\u4e70\u6b21\u6570:{}", (Object)userLimitCount);
                    int buyCount = this.mallOrderProductInterface.getUserPromotionBuyCount(mallPromotionEntity.getPromotionId(), customerId);
                    this.logger.info("\u7528\u6237\u4fc3\u9500\u5df2\u8d2d\u4e70\u6b21\u6570:{},customerid={},promotionId={}", new Object[]{buyCount, customerId, mallPromotionEntity.getPromotionId()});
                    if (buyCount >= userLimitCount) {
                        baseJsonVo.setMessage("\u8d85\u8fc7\u8d2d\u4e70\u6b21\u6570\u9650\u5236\uff01");
                        baseJsonVo.setStatus(40004);
                    }
                }
                MallOrderMainEntity orderMainEntity = new MallOrderMainEntity();
                orderMainEntity.setCustomerId(customerId);
                orderMainEntity.setStatus(1);
                orderMainEntity.setBindCode(bindCode);
                List<MallOrderMainEntity> list = this.mallOrderMainInterface.getOrderMainList(orderMainEntity);
                if (list != null && list.size() >= 1) {
                    baseJsonVo.setMessage("\u5b58\u5728\u5f85\u4ed8\u6b3e\u8ba2\u5355\uff01");
                    baseJsonVo.setStatus(40005);
                }
                MallIndexPromotionVo vo = (MallIndexPromotionVo)baseJsonVo.getValue();
                vo.setOrderSource(this.activeInterface.getOrderSourceByActiveType(activeEntity.getActiveType()));
            }
            return baseJsonVo;
        }
        return BaseJsonVo.error((String)"\u4fc3\u9500\u4e0d\u5b58\u5728\u6216\u88ab\u4e0b\u67b6");
    }

    @Override
    @ReadThroughSingleCache(namespace="mallPromotionService.getMallPromotionEntityByActiveNo", expiration=300)
    public MallPromotionEntity getMallPromotionEntityByActiveNo(String acitveNo) {
        MallPromotionEntity queryPromotionEntity = new MallPromotionEntity();
        queryPromotionEntity.setActiveNo(acitveNo);
        queryPromotionEntity.setStatus(1);
        return (MallPromotionEntity)this.promotionMapper.getSingle(queryPromotionEntity);
    }

    @Override
    public List<Map<String, Object>> getPromotionOrder(String promotionId, String start, String end) {
        if (StringUtils.isEmpty((String)start)) {
            start = DateUtils.date();
        }
        if (StringUtils.isEmpty((String)end)) {
            end = DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)1), (String)"") + " 23:59:59";
        }
        this.logger.info("promotionId={},start={},end={}", new Object[]{promotionId, start, end});
        return this.promotionMapper.getPromotionOrder(promotionId, start, end);
    }
}

