/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.sales;

import cc.lechun.framework.common.utils.cache.MemcachedService;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.core.baseclass.BaseService;
import cc.lechun.mall.dao.sales.MallPromotionTimeMapper;
import cc.lechun.mall.entity.sales.MallPromotionEntity;
import cc.lechun.mall.entity.sales.MallPromotionTimeEntity;
import cc.lechun.mall.iservice.sales.MallPromotionTimeInterface;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughSingleCache;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MallPromotionTimeService
extends BaseService
implements MallPromotionTimeInterface {
    @Autowired
    MallPromotionTimeMapper promotionTimeMapper;
    @Autowired
    MemcachedService memcachedService;

    @Override
    @ReadThroughSingleCache(namespace="promotionTimeEntityByTime", expiration=3600)
    public MallPromotionTimeEntity getSingleEntityByTime(@ParameterValueKeyProvider(order=0) String promotionId, @ParameterValueKeyProvider(order=1) String date) {
        String now;
        String endDate;
        String beginDate = date = DateUtils.formatDateChina((String)date, (String)"yyyy-MM-dd");
        List<MallPromotionTimeEntity> promotionTimeEntities = this.promotionTimeMapper.getSingleEntityByTime(promotionId, beginDate, endDate = DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.getDateFromString((String)(now = date + " " + DateUtils.now((String)"HH:mm:ss")), (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
        if (promotionTimeEntities == null || promotionTimeEntities.size() == 0) {
            return null;
        }
        if (promotionTimeEntities.size() == 1) {
            return promotionTimeEntities.get(0);
        }
        if ((promotionTimeEntities = promotionTimeEntities.stream().filter(c -> c.getBeginTime().before(DateUtils.getDateFromString((String)now, (String)"yyyy-MM-dd HH:mm:ss")) && c.getEndTime().after(DateUtils.getDateFromString((String)now, (String)"yyyy-MM-dd HH:mm:ss"))).collect(Collectors.toList())) != null && promotionTimeEntities.size() > 0) {
            return promotionTimeEntities.get(0);
        }
        return null;
    }

    @Override
    @ReadThroughSingleCache(namespace="promotionTimeEntity", expiration=3600)
    public MallPromotionTimeEntity getSingleEntity(@ParameterValueKeyProvider String promotionId) {
        return this.promotionTimeMapper.getSingleEntity(promotionId);
    }

    @Override
    public void addPromotionTime(MallPromotionEntity mallPromotionEntity, int limitCount) {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.removeCache(mallPromotionEntity.getPromotionId(), "");
        this.promotionTimeMapper.deleteByPromotionId(mallPromotionEntity.getPromotionId());
        MallPromotionTimeEntity timeEntity = new MallPromotionTimeEntity();
        if (mallPromotionEntity.getPromotionType() == 1) {
            timeEntity.setPromotionId(mallPromotionEntity.getPromotionId());
            timeEntity.setBeginTime(mallPromotionEntity.getBeginTime());
            timeEntity.setEndTime(mallPromotionEntity.getEndTime());
            timeEntity.setLimitCount(limitCount);
            timeEntity.setUsedCount(0);
            this.promotionTimeMapper.insert(timeEntity);
        } else if (mallPromotionEntity.getPromotionType() == 2) {
            System.out.println(mallPromotionEntity);
            Date beginTime = mallPromotionEntity.getBeginTime();
            Date endTime = mallPromotionEntity.getEndTime();
            Date beginDate = DateUtils.getDateFromString((String)(DateUtils.formatDate((Date)beginTime, (String)"yyyy-MM-dd") + " 00:00:00"), (String)"");
            Date endDate = DateUtils.getDateFromString((String)(DateUtils.formatDate((Date)endTime, (String)"yyyy-MM-dd") + " 00:00:00"), (String)"");
            long dateDif = (endDate.getTime() - beginDate.getTime()) / 86400000L;
            int i = 0;
            while ((long)i < dateDif + 1L) {
                timeEntity = new MallPromotionTimeEntity();
                timeEntity.setPromotionId(mallPromotionEntity.getPromotionId());
                if (i == 0) {
                    timeEntity.setBeginTime(mallPromotionEntity.getBeginTime());
                } else {
                    timeEntity.setBeginTime(Timestamp.valueOf(f.format(beginDate.getTime() + (long)(i * 24 * 60 * 60) * 1000L)));
                }
                if ((long)i == dateDif) {
                    timeEntity.setEndTime(mallPromotionEntity.getEndTime());
                } else {
                    timeEntity.setEndTime(Timestamp.valueOf(f.format(new Date(beginDate.getTime() + (long)((i + 1) * 24 * 60 * 60) * 1000L - 1L))));
                }
                timeEntity.setLimitCount(limitCount);
                timeEntity.setUsedCount(0);
                this.promotionTimeMapper.insert(timeEntity);
                ++i;
            }
        }
    }

    private void removeCache(String promotionId, String promotionTimeId) {
        this.memcachedService.delete("promotionTimeEntity", promotionId);
        this.memcachedService.delete("promotionTimeEntityByTime", new String[]{promotionId, DateUtils.date()});
    }
}

