/*
 * Decompiled with CFR 0.152.
 */
package cc.lechun.mall.service.trade;

import cc.lechun.active.entity.active.ActiveEntity;
import cc.lechun.active.iservice.active.ActiveInterface;
import cc.lechun.common.enums.sales.TransportTypeEnum;
import cc.lechun.common.enums.trade.OrderClassEnum;
import cc.lechun.common.enums.trade.OrderSourceEnum;
import cc.lechun.common.enums.trade.OrderStatusEnum;
import cc.lechun.framework.common.utils.date.DateUtils;
import cc.lechun.framework.common.utils.string.StringUtils;
import cc.lechun.framework.common.vo.BaseJsonVo;
import cc.lechun.framework.core.database.util.SpringContextUtil;
import cc.lechun.mall.entity.dictionary.DictionaryEntity;
import cc.lechun.mall.entity.sales.MallPromotionProductEntity;
import cc.lechun.mall.entity.trade.CancelOrderVo;
import cc.lechun.mall.entity.trade.MallMainOrderVo;
import cc.lechun.mall.entity.trade.MallOrderCacheVo;
import cc.lechun.mall.entity.trade.MallOrderEntity;
import cc.lechun.mall.entity.trade.MallOrderMainEntity;
import cc.lechun.mall.entity.trade.MallOrderMainMessageVo;
import cc.lechun.mall.entity.trade.MallOrderProductEntity;
import cc.lechun.mall.entity.trade.MallOrderSyncInfoEntity;
import cc.lechun.mall.entity.trade.MallOrderVo;
import cc.lechun.mall.entity.trade.OrderListVo;
import cc.lechun.mall.entity.trade.OrderQueryDo;
import cc.lechun.mall.favorstrategy.OrderFavorStrategy;
import cc.lechun.mall.favorstrategy.OrderFavorStrategyCollageNewUser;
import cc.lechun.mall.favorstrategy.OrderFavorStrategyDiscountCollageMulUser;
import cc.lechun.mall.favorstrategy.OrderFavorStrategyEnum;
import cc.lechun.mall.iservice.deliver.MallDeliverConfigClassInterface;
import cc.lechun.mall.iservice.deliver.MallDeliverConfigDetailInterface;
import cc.lechun.mall.iservice.dictionary.DictionaryInterface;
import cc.lechun.mall.iservice.platform.PlatFormInterface;
import cc.lechun.mall.iservice.sales.MallProductInterface;
import cc.lechun.mall.iservice.sales.MallPromotionProductInterface;
import cc.lechun.mall.iservice.shoppingcart.MallPriceCalcInterface;
import cc.lechun.mall.iservice.trade.MallOrderGroupProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderInterface;
import cc.lechun.mall.iservice.trade.MallOrderMainInterface;
import cc.lechun.mall.iservice.trade.MallOrderProductInterface;
import cc.lechun.mall.iservice.trade.MallOrderSyncInfoInterface;
import cc.lechun.mall.iservice.trade.MallTradeCommonInterface;
import cc.lechun.mall.service.trade.cache.MallOrderMainCacheService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MallOrderMainService
extends MallOrderMainCacheService
implements MallOrderMainInterface {
    @Autowired
    private ActiveInterface activeInterface;
    @Autowired
    private PlatFormInterface platFormInterface;
    @Autowired
    private MallOrderInterface orderInterface;
    @Autowired
    private MallOrderProductInterface orderProductInterface;
    @Autowired
    private DictionaryInterface dictionaryInterface;
    @Autowired
    private MallPriceCalcInterface priceCalcInterface;
    @Autowired
    private MallPromotionProductInterface promotionProductInterface;
    @Autowired
    private MallDeliverConfigClassInterface deliverConfigClassInterface;
    @Autowired
    private MallDeliverConfigDetailInterface deliverConfigDetailInterface;
    @Autowired
    private MallProductInterface productInterface;
    @Autowired
    private MallTradeCommonInterface tradeCommonInterface;
    @Autowired
    private MallOrderSyncInfoInterface orderSyncInfoService;
    @Autowired
    private MallOrderGroupProductInterface orderGroupProductService;

    @Override
    public boolean updateOrderMain(MallOrderMainEntity orderMainEntity) {
        int i = this.mallOrderMainMapper.updateByPrimaryKeySelective(orderMainEntity);
        return i == 1;
    }

    @Override
    public boolean insertOrderMain(MallOrderMainEntity orderMainEntity) {
        int i = this.mallOrderMainMapper.insertSelective(orderMainEntity);
        return i == 1;
    }

    @Override
    public boolean deleteOrderMain(String orderMainNo, String customerId) {
        MallOrderMainEntity orderMainEntity = (MallOrderMainEntity)this.mallOrderMainMapper.selectByPrimaryKey((Serializable)((Object)orderMainNo));
        if (orderMainEntity.getStatus() == 0) {
            return this.updateOrderMainStatus(orderMainNo, OrderStatusEnum.DELETE.getName(), customerId, orderMainEntity.getStatus());
        }
        return false;
    }

    @Override
    @Transactional
    public boolean cancelOrderMain(String orderMainNo, String customerId) {
        MallOrderMainEntity orderMainEntity = (MallOrderMainEntity)this.mallOrderMainMapper.selectByPrimaryKey((Serializable)((Object)orderMainNo));
        if (orderMainEntity.getStatus() != 1) {
            return false;
        }
        try {
            boolean b = this.updateOrderMainStatus(orderMainNo, OrderStatusEnum.CANCEL.getName(), customerId, orderMainEntity.getStatus());
            if (!b) {
                throw new RuntimeException();
            }
            List<MallOrderEntity> orderEntities = this.orderInterface.getOrderList(orderMainNo);
            if (orderEntities != null) {
                for (MallOrderEntity o : orderEntities) {
                    if (this.orderInterface.cancelOrder(o.getOrderNo(), customerId)) continue;
                    throw new RuntimeException();
                }
            }
            return true;
        }
        catch (RuntimeException e) {
            this.logger.error(e.toString());
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean paySuccessOrderMain(String orderMainNo) {
        return this.updateOrderMainStatus(orderMainNo, OrderStatusEnum.PAYCONFIRM.getName(), 1);
    }

    @Override
    public boolean updateOrderMainStatus(String orderMainNo, String orderStatus, int oldStatus) {
        MallOrderMainEntity orderMainEntity = (MallOrderMainEntity)this.mallOrderMainMapper.selectByPrimaryKey((Serializable)((Object)orderMainNo));
        if (orderMainEntity.getStatus() >= 2) {
            this.logger.info("\u8ba2\u5355\u72b6\u6001\u5df2\u66f4\u65b0\uff1a{}", (Object)orderMainEntity.getStatus());
            return false;
        }
        if ((oldStatus == 0 || oldStatus == 1 || oldStatus == -1) && orderMainEntity.getCreateTime().before(DateUtils.getAddDateBySecond((Date)DateUtils.now(), (int)-7200))) {
            this.logger.info("2\u5c0f\u65f6\u4e4b\u524d\u7684\u8ba2\u5355,\u65e0\u6cd5\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\uff1a{}", (Object)orderMainEntity.getStatus());
            return false;
        }
        String newStatusName = OrderStatusEnum.PAYCONFIRM.getName();
        if (orderMainEntity.getOrderClass().intValue() == OrderClassEnum.NO_DELIVERY.getValue() || orderMainEntity.getOrderClass().intValue() == OrderClassEnum.CROWD_ORDER.getValue()) {
            newStatusName = OrderStatusEnum.COMPLETION.getName();
        }
        this.logger.info("\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u4e2d\uff1a" + orderMainNo);
        MallOrderMainEntity updateMainOrder = new MallOrderMainEntity();
        updateMainOrder.setOrderMainNo(orderMainNo);
        updateMainOrder.setStatus(OrderStatusEnum.getValue(newStatusName));
        boolean b = this.updateOrderMain(updateMainOrder);
        if (b) {
            ActiveEntity activeEntity;
            if (StringUtils.isNotEmpty((String)orderMainEntity.getBindCode()) && (activeEntity = this.activeInterface.getActiveEntityByQrcode(orderMainEntity.getBindCode())) != null) {
                if (newStatusName == OrderStatusEnum.COMPLETION.getName()) {
                    this.activeInterface.confirmOrder(orderMainEntity, activeEntity);
                } else if (newStatusName == OrderStatusEnum.PAYCONFIRM.getName()) {
                    this.activeInterface.afterPay(orderMainEntity, activeEntity);
                }
            }
            List<MallOrderEntity> orderEntities = this.orderInterface.getOrderList(orderMainNo);
            for (MallOrderEntity o : orderEntities) {
                if (this.orderInterface.paySuccessOrder(o.getOrderNo(), newStatusName)) continue;
                throw new RuntimeException("\u66f4\u65b0\u5b50\u8ba2\u5355\u5f02\u5e38");
            }
        }
        return b;
    }

    @Override
    public boolean updateOrderMainStatus(String orderMainNo, String orderStatus, String customerId, int oldStatus) {
        this.logger.info("\u66f4\u6539\u8ba2\u5355\u72b6\u6001\uff1a\u8ba2\u5355\u53f7\uff1a" + orderMainNo + ",\u72b6\u6001\uff1a" + orderStatus + ",\u7528\u6237\uff1a" + customerId + ",\u8001\u72b6\u6001\uff1a" + oldStatus);
        Integer status = OrderStatusEnum.getValue(orderStatus);
        if (status == null) {
            return false;
        }
        MallOrderMainEntity orderMainEntity = this.tradeCommonInterface.getUpdateStatusOrderMainEntity(orderMainNo, status, oldStatus);
        if (orderMainEntity == null) {
            return false;
        }
        return this.updateOrderMain(orderMainEntity);
    }

    @Override
    public BaseJsonVo buildOrderMainEntity(MallMainOrderVo mainOrderVo) {
        String message = "";
        try {
            MallOrderMainEntity orderMainEntity = new MallOrderMainEntity();
            orderMainEntity.setCompleteTime(null);
            orderMainEntity.setPayTime(null);
            orderMainEntity.setCacheId(mainOrderVo.getOrderCacheVo().getCacheId());
            orderMainEntity.setConfirmPaytime(null);
            orderMainEntity.setCustomerId(mainOrderVo.getCustomerId());
            orderMainEntity.setActiveNo(StringUtils.isEmpty((String)mainOrderVo.getOrderCacheVo().getBindCode()) ? "" : this.activeInterface.getActiveNoByBindCode(mainOrderVo.getOrderCacheVo().getBindCode()));
            orderMainEntity.setBindCode(mainOrderVo.getOrderCacheVo().getBindCode());
            orderMainEntity.setBuyFlag(mainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.LONGPERIOD_BUY.getValue() ? 1 : 0);
            orderMainEntity.setBuyType((short)(mainOrderVo.getOrderCacheVo().getOrderSource() == OrderSourceEnum.PLEASE_MILK_CHANGE.getValue() ? 3 : 0));
            orderMainEntity.setCancelReason("");
            orderMainEntity.setCancelTime(null);
            orderMainEntity.setChannelId(mainOrderVo.getChannelId());
            orderMainEntity.setChannelOrderNo("");
            orderMainEntity.setCookieBindCode(mainOrderVo.getOrderCacheVo().getCookieBindCode());
            orderMainEntity.setCreateTime(DateUtils.now());
            orderMainEntity.setCustomerId(mainOrderVo.getCustomerId());
            orderMainEntity.setDeleteTime(null);
            orderMainEntity.setDeliverCount(mainOrderVo.getMallOrderVos().size());
            orderMainEntity.setDeliverPeriod(mainOrderVo.getMallOrderVos().get(0).getDeliverPeriod());
            orderMainEntity.setFreight(mainOrderVo.getFreight());
            orderMainEntity.setFxUserId("");
            orderMainEntity.setGiftType(mainOrderVo.getOrderCacheVo().getGiftType());
            orderMainEntity.setImportSensorFlag((short)0);
            orderMainEntity.setImportTime(null);
            orderMainEntity.setInvoiceContent("");
            orderMainEntity.setInvoiceFlag((short)2);
            orderMainEntity.setInvoiceTitle("");
            orderMainEntity.setInvoiceType(0);
            orderMainEntity.setIsshow((short)1);
            orderMainEntity.setOrderAmount(mainOrderVo.getOrderAmount());
            orderMainEntity.setOrderClass(this.tradeCommonInterface.orderSourceConvertOrderClass(mainOrderVo));
            orderMainEntity.setOrderMainNo(mainOrderVo.getMainOrderNo());
            orderMainEntity.setOrderType((short)1);
            orderMainEntity.setPayAmount(mainOrderVo.getPayAmount());
            orderMainEntity.setPayTime(null);
            orderMainEntity.setPlatformGroupId(this.platFormInterface.getPlatFormGroupId(mainOrderVo.getPlatFormId()));
            orderMainEntity.setOrderSource(mainOrderVo.getOrderCacheVo().getOrderSource());
            orderMainEntity.setPlatformId(mainOrderVo.getPlatFormId());
            orderMainEntity.setQuantity(mainOrderVo.getQuantity());
            orderMainEntity.setReleaseSystemId("");
            orderMainEntity.setRemark("");
            orderMainEntity.setRemark2("");
            orderMainEntity.setSoldDeptId(1);
            orderMainEntity.setSoldTypeId(1);
            orderMainEntity.setSourceOrderNo("");
            orderMainEntity.setStatus(1);
            orderMainEntity.setSubBindCode("");
            orderMainEntity.setTotalAmount(mainOrderVo.getTotalAmount());
            orderMainEntity.setUserTerminal(mainOrderVo.getPlatFormId());
            orderMainEntity.setVersionDetailId(mainOrderVo.getOrderCacheVo().getVersionDetailId());
            orderMainEntity.setDeliverType(mainOrderVo.getMallOrderVos().get(0).getDeliverType());
            return BaseJsonVo.success((Object)orderMainEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
            message = "\u521b\u5efa\u8ba2\u5355\u5bf9\u8c61\u5f02\u5e38";
            this.logger.error(message + e.toString());
            return BaseJsonVo.error((String)message);
        }
    }

    @Override
    public MallOrderMainEntity getLastOrder(String customerId) {
        return this.mallOrderMainMapper.getLastOrder(customerId);
    }

    @Override
    public MallMainOrderVo getMainOrderVo(int platFormId, String customerId, List<MallOrderVo> orderVosIn, MallOrderCacheVo orderCacheVo) {
        MallMainOrderVo mallMainOrderVo = new MallMainOrderVo();
        mallMainOrderVo.setOrderCacheVo(orderCacheVo);
        for (MallOrderVo orderVo : orderVosIn) {
            orderVo.setTransportType(this.productInterface.getTransportType(orderVo));
            this.priceCalcInterface.totalOrderPrice(orderVo);
            if (orderVo.getOrderSource() == OrderSourceEnum.PLEASE_MILK_CHANGE.getValue() && (orderVo.getDeliverCount() != 1 || orderVo.getDeliverPeriod() != 1)) {
                mallMainOrderVo.setBaseError("\u793c\u54c1\u5151\u6362\u53ea\u80fd\u914d\u9001\u4e00\u6b21");
                return mallMainOrderVo;
            }
            if (orderVo.getDeliverPeriod() > 30 || orderVo.getDeliverPeriod() < 0) {
                mallMainOrderVo.setBaseError("\u914d\u9001\u6570\u636e\u5f02\u5e38-\u914d\u9001\u95f4\u9694\u4e0d\u6b63\u786e");
                return mallMainOrderVo;
            }
            if (orderVo.getDeliverCount() > 100) {
                mallMainOrderVo.setBaseError("\u914d\u9001\u6570\u636e\u5f02\u5e38-\u914d\u9001\u6b21\u6570\u4e0d\u80fd\u8d85\u8fc7100\u6b21");
                return mallMainOrderVo;
            }
            if (orderVo.isBaseSuccess()) continue;
            mallMainOrderVo.setBaseError(orderVo.getBaseErrMsg());
            return mallMainOrderVo;
        }
        mallMainOrderVo.setCustomerId(customerId);
        mallMainOrderVo.setPlatFormId(platFormId);
        mallMainOrderVo.setMallOrderVos(orderVosIn);
        mallMainOrderVo.setChannelId(this.tradeCommonInterface.platformConvertChannel(platFormId));
        if (mallMainOrderVo.getChannelId() == 0) {
            mallMainOrderVo.setBaseError("\u6e20\u9053\u6ca1\u6709\u5b9a\u4e49");
            return mallMainOrderVo;
        }
        mallMainOrderVo.setQuantity(orderVosIn.stream().mapToInt(e -> e.getQuantity()).sum());
        if (orderCacheVo.getOrderSource() == OrderSourceEnum.COLLAGE.getValue()) {
            ArrayList<OrderFavorStrategy> orderFavorStrategies = new ArrayList<OrderFavorStrategy>();
            OrderFavorStrategy collageNewUser = (OrderFavorStrategy)SpringContextUtil.getBean(OrderFavorStrategyCollageNewUser.class);
            collageNewUser.setStrategy(OrderFavorStrategyEnum.ORDER_FAVOR_STRATEGY_ENUM_COLLAGE_NEWUSER);
            collageNewUser.setShowText(OrderFavorStrategyEnum.ORDER_FAVOR_STRATEGY_ENUM_COLLAGE_NEWUSER.getName());
            OrderFavorStrategy collageMulUser = (OrderFavorStrategy)SpringContextUtil.getBean(OrderFavorStrategyDiscountCollageMulUser.class);
            collageMulUser.setStrategy(OrderFavorStrategyEnum.ORDER_FAVOR_STRATEGY_ENUM_COLLAGE_MULUSER);
            collageMulUser.setShowText(OrderFavorStrategyEnum.ORDER_FAVOR_STRATEGY_ENUM_COLLAGE_MULUSER.getName());
            orderFavorStrategies.add(collageNewUser);
            orderFavorStrategies.add(collageMulUser);
            mallMainOrderVo.setOrderFavorStrategies(orderFavorStrategies);
        }
        return mallMainOrderVo;
    }

    @Override
    public List<OrderListVo> getOrderMainList(String customerId, int[] status, int statusClass, int pageSize, int pageCount) {
        pageCount = pageCount == 0 || pageCount == 1 ? 0 : (pageCount - 1) * pageSize;
        return this.mallOrderMainMapper.getCustomerOrderList(customerId, statusClass, status, pageSize, pageCount);
    }

    @Override
    public PageInfo<OrderListVo> getOrderMainList4cms(String customerId, int[] status, int statusClass, int pageSize, int pageCount) {
        Page page = PageHelper.startPage((int)pageCount, (int)pageSize);
        page.setOrderBy("CREATE_TIME desc");
        this.mallOrderMainMapper.getCustomerOrderList4cms(customerId, statusClass, status);
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    @Override
    public PageInfo<MallOrderMainEntity> getOrderList4cms(OrderQueryDo orderQueryDo) {
        this.logger.info("\u67e5\u8be2\u53c2\u6570:[{}]", (Object)orderQueryDo.toString());
        Page page = PageHelper.startPage((int)orderQueryDo.getCurrentPage(), (int)orderQueryDo.getPageSize());
        page.setOrderBy("CREATE_TIME desc");
        this.mallOrderMainMapper.getOrderList4cms(orderQueryDo);
        PageInfo pg = page.toPageInfo();
        return pg;
    }

    @Override
    public boolean iseditOrder(String orderNo, Date deliverDate, Date pickUpdate, int platformGroupId, int status) {
        int transportType;
        if (orderNo == null || orderNo.isEmpty()) {
            return false;
        }
        MallOrderEntity order = this.orderInterface.getmallOrder(orderNo);
        if ("1".equals(order.getSpeedUp())) {
            this.logger.info("\u8ba2\u5355" + orderNo + "\u6781\u901f\u8fbe\uff0c\u4e0d\u53ef\u4fee\u6539");
            return false;
        }
        MallOrderSyncInfoEntity syncInfo = new MallOrderSyncInfoEntity();
        syncInfo.setOrderNo(orderNo);
        syncInfo.setApiName("edbTradeAdd_LC");
        syncInfo.setSuccess(1);
        List<MallOrderSyncInfoEntity> list = this.orderSyncInfoService.getList(syncInfo);
        if (list != null && list.size() > 0) {
            this.logger.info("\u8ba2\u5355" + orderNo + "\u5df2\u540c\u6b65\u5230EDB\uff0c\u4e0d\u53ef\u4fee\u6539");
            return false;
        }
        List<DictionaryEntity> dictionaryEntities = this.dictionaryInterface.getValidDictionaryList(platformGroupId, 16);
        MallOrderProductEntity orderProductEntity = new MallOrderProductEntity();
        orderProductEntity.setOrderNo(orderNo);
        List<MallOrderProductEntity> orderProductEntities = this.orderProductInterface.getOrderProductList(orderProductEntity);
        if (dictionaryEntities != null && dictionaryEntities.size() > 0) {
            String[] dicName = dictionaryEntities.get(0).getDictionaryName().split(",");
            if (orderProductEntities != null && dicName != null) {
                for (String d : dicName) {
                    if (orderProductEntities.stream().filter(c -> c.getProductId().equals(d)).count() <= 0L) continue;
                    return false;
                }
            }
        }
        if (orderProductEntities != null && (orderProductEntities = orderProductEntities.stream().filter(c -> c.getPromotionProductId() != null && !c.getPromotionProductId().isEmpty()).collect(Collectors.toList())) != null && orderProductEntities.size() > 0) {
            for (MallOrderProductEntity p : orderProductEntities) {
                MallPromotionProductEntity promotionProductEntity;
                if (!p.getPromotionProductId().isEmpty() && (promotionProductEntity = this.promotionProductInterface.getPromotionProduct(p.getPromotionProductId())) == null) continue;
            }
        }
        if ((transportType = this.productInterface.getTransportType(this.orderGroupProductService.getOrderGroupProductListByOrderNo(orderNo))) == TransportTypeEnum.NORMAL_CHAIN.getValue()) {
            this.logger.info("\u5e38\u6e29\u8ba2\u5355\u4e0d\u80fd\u4fee\u6539");
            return false;
        }
        return deliverDate != null && DateUtils.currentDate().before(deliverDate) && status == OrderStatusEnum.PAYCONFIRM.getValue();
    }

    @Override
    public OrderListVo getOrderMainDetail(String customerId, String orderMainNo) {
        return this.mallOrderMainMapper.getCustomerOrderDetail(customerId, orderMainNo);
    }

    @Override
    public List<CancelOrderVo> getBacthCancelMainOrderList(String cancelTime, int size) {
        String fistTime = DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)-3), (String)"yyyy-MM-dd HH:mm:ss");
        return this.mallOrderMainMapper.getBacthCancelMainOrderList(cancelTime, fistTime, size);
    }

    @Override
    public List<MallOrderMainMessageVo> getCustomerConfirmGoods(int days) {
        String edate;
        Date date = DateUtils.getAddDateByDay((Date)DateUtils.currentDate(), (int)(-days));
        String sdate = DateUtils.formatDate((Date)date, (String)"yyyy-MM-dd");
        List<MallOrderMainMessageVo> orderMainMessageVos = this.mallOrderMainMapper.getConfirmGoodsCustomerByDays(sdate, edate = DateUtils.formatDate((Date)DateUtils.getAddDateByDay((Date)date, (int)1), (String)"yyyy-MM-dd"));
        if (orderMainMessageVos == null) {
            return new ArrayList<MallOrderMainMessageVo>();
        }
        return orderMainMessageVos;
    }

    @Override
    public List<MallOrderMainEntity> getOrderMainList(MallOrderMainEntity mallOrderMainEntity) {
        return this.mallOrderMainMapper.getList(mallOrderMainEntity);
    }

    @Override
    public int updateOrderStatusByEdb(String orderMainNo, String orderStatus) {
        return this.mallOrderMainMapper.updateOrderStatusByEdb(orderMainNo, orderStatus);
    }

    @Override
    public List<Map<String, Object>> getOrderInfo(Integer orderClass, String activeNo, String bindCode, String date) {
        return this.mallOrderMainMapper.getOrderInfo(orderClass, activeNo, bindCode, date);
    }

    @Override
    public Integer getOrderNum(String customerId) {
        return this.mallOrderMainMapper.getOrderNum(customerId);
    }

    @Override
    public int getOrderNum(String customerId, Integer day) {
        return this.mallOrderMainMapper.getOrderNumByDay(customerId, day);
    }

    @Override
    public List<MallOrderMainEntity> getTeamSaleOrderList(Date date) {
        return this.mallOrderMainMapper.getTeamSaleOrderList(date);
    }
}

